package com.autonavi.amapauto.remotecontrol.server;

import android.net.Uri;
import android.text.TextUtils;
import com.autonavi.amapauto.remotecontrol.AndroidRemoteControl;
import com.autonavi.amapauto.remotecontrol.HttpSession;
import com.autonavi.amapauto.remotecontrol.RemoteControlResponse;
import defpackage.aa0;
import defpackage.ep0;
import defpackage.fq0;
import defpackage.gq0;
import defpackage.rq;
import defpackage.s80;
import defpackage.so0;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class LinkAutoServer extends fq0 {
    public static final int ERROR_CODE_ROUTE_REQUEST_URL = 100;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR1 = 101;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR2 = 102;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR3 = 103;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR4 = 104;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR5 = 105;
    public static final int ERROR_CODE_ROUTE_RESULT_FILE_ERROR6 = 106;
    public static final String PARAM_REQUEST = "request";
    public static final String PARAM_SESSION_ID = "sessionid";
    public static final String PARAM_SOURCE = "source";
    public static final String TAG = "LinkAutoServer";
    public static String mSessionId;

    @fq0.a(path = "/autoservice/accept/onekey/exchange_peer")
    public gq0.o serveAcceptExchangePeer(gq0.m mVar) {
        aa0.a(TAG, "start exchange_peer request", new Object[0]);
        HashMap hashMap = new HashMap(16);
        if (mVar == null) {
            return s80.a(106);
        }
        try {
            mVar.a(hashMap);
            if (hashMap.size() <= 0) {
                aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR3", new Object[0]);
                return s80.a(103);
            }
            try {
                byte[] bArr = (byte[]) hashMap.get("rawContent");
                if (bArr == null) {
                    aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR5", new Object[0]);
                    return s80.a(105);
                }
                String str = new String(bArr);
                aa0.a(TAG, "LinkAutoServer exchange_peer rawData ={?}", str);
                if (!TextUtils.isEmpty(str)) {
                    try {
                        JSONObject jSONObject = new JSONObject(str);
                        String optString = jSONObject.optString("displayName");
                        String optString2 = jSONObject.optString("featureCode");
                        ep0 ep0Var = new ep0();
                        ep0Var.c = optString;
                        ep0Var.b = optString2;
                        aa0.a(TAG, "LinkAutoServer exchange_peer displayName ={?},featureCode = {?}", optString, optString2);
                        so0.g().d().a(ep0Var);
                    } catch (Exception e) {
                        aa0.a(TAG, "LinkAutoServer parse directDevice error {?}", e.getMessage());
                    }
                }
                ep0 a = so0.g().d().a();
                if (a != null) {
                    return s80.a(true, 1, "{\"displayName\":\"" + a.c + "\",\"featureCode\":\"" + a.b + "\"}");
                }
                return s80.a(105);
            } catch (Exception e2) {
                aa0.a("Exception", e2, new Object[0]);
                return s80.a(104);
            }
        } catch (gq0.p e3) {
            aa0.a("ResponseException", e3, new Object[0]);
            return s80.a(102);
        } catch (IOException e4) {
            aa0.a("Exception", e4, new Object[0]);
            return s80.a(101);
        } catch (Exception e5) {
            aa0.a("Exception", e5, new Object[0]);
            return s80.a(106);
        }
    }

    @fq0.a(path = "/autoservice/accept/exchange/tid")
    public gq0.o serveAcceptExchangeTid(gq0.m mVar) {
        aa0.a(TAG, "start serveAcceptExchangeTid", new Object[0]);
        return s80.a(true, 1, "{\"tid\":\"" + Uri.encode(rq.N(), "UTF-8") + "\"}");
    }

    @fq0.a(path = "/autoservice/accept/onekey/query")
    public gq0.o serveAcceptOnekeyQuery(gq0.m mVar) {
        aa0.a(TAG, "start onekey query request", new Object[0]);
        HttpSession httpSession = new HttpSession();
        String path = Uri.parse(mVar.c()).getPath();
        httpSession.url = path;
        aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyQuery uri={?}", path);
        RemoteControlResponse onHttpResponse = AndroidRemoteControl.onHttpResponse(httpSession);
        aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyQuery end", new Object[0]);
        return s80.b(onHttpResponse.code);
    }

    @fq0.a(path = "/autoservice/accept/onekey/start")
    public gq0.o serveAcceptOnekeyStart(gq0.m mVar) {
        aa0.a(TAG, "start onekey_start request", new Object[0]);
        HashMap hashMap = new HashMap(16);
        if (mVar == null) {
            return s80.a(106);
        }
        try {
            mVar.a(hashMap);
            if (hashMap.size() <= 0) {
                aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR3", new Object[0]);
                return s80.a(103);
            }
            try {
                byte[] bArr = (byte[]) hashMap.get("rawContent");
                if (bArr == null) {
                    aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR5", new Object[0]);
                    return s80.a(105);
                }
                HttpSession httpSession = new HttpSession();
                httpSession.rawContent = bArr;
                String path = Uri.parse(mVar.c()).getPath();
                httpSession.url = path;
                aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyStart uri={?}，httpSession.rawContent ={?}", path, new String(httpSession.rawContent));
                AndroidRemoteControl.onHttpResponse(httpSession);
                aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyStart end", new Object[0]);
                return s80.a();
            } catch (Exception e) {
                aa0.a("Exception", e, new Object[0]);
                return s80.a(104);
            }
        } catch (gq0.p e2) {
            aa0.a("ResponseException", e2, new Object[0]);
            return s80.a(102);
        } catch (IOException e3) {
            aa0.a("Exception", e3, new Object[0]);
            return s80.a(101);
        } catch (Exception e4) {
            aa0.a("Exception", e4, new Object[0]);
            return s80.a(106);
        }
    }

    @fq0.a(path = "/autoservice/accept/onekey/stop")
    public gq0.o serveAcceptOnekeyStop(gq0.m mVar) {
        aa0.a(TAG, "start onekey stop request", new Object[0]);
        HttpSession httpSession = new HttpSession();
        String path = Uri.parse(mVar.c()).getPath();
        httpSession.url = path;
        aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyStop uri={?}", path);
        AndroidRemoteControl.onHttpResponse(httpSession);
        aa0.a(TAG, "LinkAutoServer serveAcceptOnekeyStop end", new Object[0]);
        return s80.a();
    }

    @fq0.a(path = "/autoservice/accept/navi/poi_result")
    public gq0.o serveAcceptPOIResult(gq0.m mVar) {
        HashMap hashMap = new HashMap(16);
        if (mVar == null) {
            return s80.a(106);
        }
        try {
            mVar.a(hashMap);
            if (hashMap.size() <= 0) {
                aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR3", new Object[0]);
                return s80.a(103);
            }
            try {
                byte[] bArr = (byte[]) hashMap.get("rawContent");
                if (bArr == null) {
                    aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR5", new Object[0]);
                    return s80.a(105);
                }
                HttpSession httpSession = new HttpSession();
                httpSession.rawContent = bArr;
                httpSession.url = Uri.parse(mVar.c()).getPath();
                byte[] bArr2 = httpSession.rawContent;
                aa0.a(TAG, "LinkAutoServer serveAcceptPOIResult uri={?}，length={?}, httpSession.rawContent ={?}", httpSession.url, Integer.valueOf(bArr2 != null ? bArr2.length : 0), new String(httpSession.rawContent));
                AndroidRemoteControl.onHttpResponse(httpSession);
                aa0.a(TAG, "LinkAutoServer serveAcceptPOIResult end", new Object[0]);
                return s80.a();
            } catch (Exception e) {
                aa0.a("Exception", e, new Object[0]);
                return s80.a(104);
            }
        } catch (gq0.p e2) {
            aa0.a("ResponseException", e2, new Object[0]);
            return s80.a(102);
        } catch (IOException e3) {
            aa0.a("Exception", e3, new Object[0]);
            return s80.a(101);
        } catch (Exception e4) {
            aa0.a("Exception", e4, new Object[0]);
            return s80.a(106);
        }
    }

    @fq0.a(path = "/autoservice/accept/navi/route_request")
    public gq0.o serveAcceptRouteRequest(gq0.m mVar) {
        String str;
        HttpSession httpSession = new HttpSession();
        Map<String, String> b = mVar.b();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(PARAM_SESSION_ID, b.get(PARAM_SESSION_ID));
            jSONObject.put(PARAM_SOURCE, b.get(PARAM_SOURCE));
            jSONObject.put("request", new JSONObject(b.get("request")));
        } catch (Exception e) {
            aa0.a(TAG, "serveAcceptRouteRequest Exception", e);
        }
        httpSession.parms = jSONObject.toString();
        String path = Uri.parse(mVar.c()).getPath();
        httpSession.url = path;
        aa0.a(TAG, "LinkAutoServer serveAcceptRouteRequest AndroidRemoteControl url={?}", path);
        RemoteControlResponse onHttpResponse = AndroidRemoteControl.onHttpResponse(httpSession);
        if (onHttpResponse != null && (str = onHttpResponse.requestUrl) != null) {
            aa0.a(TAG, "LinkAutoServer serveAcceptRouteRequest AndroidRemoteControl url={?}", str);
            mSessionId = b.get(PARAM_SESSION_ID);
            return s80.b(onHttpResponse.requestUrl);
        }
        return s80.a(100);
    }

    @fq0.a(path = "/autoservice/accept/navi/route_restore")
    public gq0.o serveAcceptRouteRestore(gq0.m mVar) {
        HashMap hashMap = new HashMap(16);
        if (mVar == null) {
            return s80.a(106);
        }
        try {
            mVar.a(hashMap);
            if (hashMap.size() <= 0) {
                aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR3", new Object[0]);
                return s80.a(103);
            }
            try {
                byte[] bArr = (byte[]) hashMap.get("rawContent");
                if (bArr == null) {
                    aa0.a(TAG, "ERROR_CODE_ROUTE_RESULT_FILE_ERROR5", new Object[0]);
                    return s80.a(105);
                }
                HttpSession httpSession = new HttpSession();
                httpSession.rawContent = bArr;
                String path = Uri.parse(mVar.c()).getPath();
                httpSession.url = path;
                aa0.a(TAG, "LinkAutoServer serveAcceptRouteRestore uri={?}，httpSession.rawContent ={?}", path, new String(httpSession.rawContent));
                AndroidRemoteControl.onHttpResponse(httpSession);
                aa0.a(TAG, "LinkAutoServer serveAcceptRouteRestore end", new Object[0]);
                return s80.a();
            } catch (Exception e) {
                aa0.a("Exception", e, new Object[0]);
                return s80.a(104);
            }
        } catch (gq0.p e2) {
            aa0.a("ResponseException", e2, new Object[0]);
            return s80.a(102);
        } catch (IOException e3) {
            aa0.a("Exception", e3, new Object[0]);
            return s80.a(101);
        } catch (Exception e4) {
            aa0.a("Exception", e4, new Object[0]);
            return s80.a(106);
        }
    }

    @fq0.a(path = "/autoservice/accept/navi/route_result")
    public gq0.o serveAcceptRouteResult(gq0.m mVar) {
        if (mVar == null) {
            aa0.a(TAG, "serveAcceptRouteResult sessionid == null", new Object[0]);
            return s80.a(106);
        }
        String str = mVar.b().get(PARAM_SESSION_ID);
        if (!TextUtils.isEmpty(str) && !str.equals(mSessionId)) {
            aa0.a(TAG, "serveAcceptRouteResult sessionid no match", new Object[0]);
            return s80.a(PARAM_SESSION_ID);
        }
        HashMap hashMap = new HashMap(16);
        try {
            mVar.a(hashMap);
            if (hashMap.size() <= 0) {
                aa0.a(TAG, "serveAcceptRouteResult ERROR_CODE_ROUTE_RESULT_FILE_ERROR3", new Object[0]);
                return s80.a(103);
            }
            try {
                byte[] bArr = (byte[]) hashMap.get("rawContent");
                if (bArr == null) {
                    aa0.a(TAG, "serveAcceptRouteResult ERROR_CODE_ROUTE_RESULT_FILE_ERROR5", new Object[0]);
                    return s80.a(105);
                }
                HttpSession httpSession = new HttpSession();
                httpSession.rawContent = bArr;
                httpSession.url = Uri.parse(mVar.c()).getPath();
                byte[] bArr2 = httpSession.rawContent;
                aa0.a(TAG, "LinkAutoServer serveAcceptRouteResult uri={?}，length={?}; httpSession.rawContent ={?}", httpSession.url, Integer.valueOf(bArr2 != null ? bArr2.length : 0), new String(httpSession.rawContent));
                AndroidRemoteControl.onHttpResponse(httpSession);
                aa0.a(TAG, "LinkAutoServer serveAcceptRouteResult end", new Object[0]);
                return s80.a();
            } catch (Exception e) {
                aa0.a("serveAcceptRouteResult Exception", e, new Object[0]);
                return s80.a(104);
            }
        } catch (gq0.p e2) {
            aa0.a("serveAcceptRouteResult ResponseException", e2, new Object[0]);
            return s80.a(102);
        } catch (IOException e3) {
            aa0.a("serveAcceptRouteResult Exception", e3, new Object[0]);
            return s80.a(101);
        } catch (Exception e4) {
            aa0.a("serveAcceptRouteResult Exception", e4, new Object[0]);
            return s80.a(106);
        }
    }
}
