package com.autonavi.amapauto.settings;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import com.autonavi.amapauto.jni.protocol.data.HttpRequestParam;
import com.autonavi.amapauto.jni.protocol.data.HttpResponseData;
import com.autonavi.amapauto.jni.protocol.data.LastOneKmInfoData;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import defpackage.kq;
import defpackage.n90;
import defpackage.qp;
import defpackage.ra0;

/* loaded from: classes.dex */
public class AndroidSystemSetting {
    public static final String TAG = "AndroidSystemSetting";
    public static boolean mNoaIsStatus;
    public static TimeBroadcastReceiver mTimeBroadcastReceiver;

    public static void callApplicationDetailSetting() {
        try {
            if (jp.I().l(10039)) {
                aa0.a(TAG, "channel disposed call app detail seting", new Object[0]);
                return;
            }
            aa0.a(TAG, "default call app detail seting", new Object[0]);
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setFlags(268435456);
            intent.setData(Uri.fromParts("package", ee.A().o(), null));
            ee.A().f().startActivity(intent);
        } catch (Exception e) {
            aa0.a(TAG, "callApplicationDetailSetting Exception ", e);
        }
    }

    public static void callSystemApp(int i) {
        if (i == 1) {
            jp.I().l(10007);
        } else {
            if (i != 2) {
                return;
            }
            jp.I().l(10008);
        }
    }

    public static void callSystemGPSSetting() {
        try {
            if (jp.I().l(10058)) {
                aa0.a(TAG, "channel disposed call system GPS setting", new Object[0]);
                return;
            }
            Intent intent = new Intent();
            intent.setAction("android.settings.LOCATION_SOURCE_SETTINGS");
            intent.setFlags(268435456);
            ee.A().f().startActivity(intent);
        } catch (Exception e) {
            aa0.a(TAG, "callSystemGPSSetting Exception ", e);
        }
    }

    public static void callSystemNetworkSetting() {
        aa0.a(TAG, "callSystemNetworkSetting", new Object[0]);
        jp.I().l(10001);
    }

    public static void callSystemSetting() {
        try {
            if (jp.I().l(10051)) {
                aa0.a(TAG, "channel disposed call system setting", new Object[0]);
                return;
            }
            aa0.a(TAG, "default call system setting", new Object[0]);
            Intent intent = new Intent();
            intent.setAction("android.settings.SETTINGS");
            intent.setFlags(268435456);
            ee.A().f().startActivity(intent);
        } catch (Exception e) {
            aa0.a(TAG, "callSystemSetting Exception ", e);
        }
    }

    public static boolean getNoaStatus() {
        return mNoaIsStatus;
    }

    public static String getSystemWifiName() {
        aa0.a(TAG, "[getSystemWifiName]start", new Object[0]);
        if (jp.I().j(60001).b()) {
            return "";
        }
        if (n90.g(ee.A().f())) {
            String c = n90.c();
            aa0.a(TAG, "[getSystemWifiName]end, wifiName:{?}", c);
            return c;
        }
        aa0.a(TAG, "[getSystemWifiName]end,wifi no connect,return null ", new Object[0]);
        return null;
    }

    public static String getTime() {
        return ra0.a();
    }

    public static int getTimeType() {
        return ra0.b();
    }

    public static void jniDispatchLastOneKmInfo(LastOneKmInfoData lastOneKmInfoData) {
        aa0.a(TAG, "[jniDispatchLastOneKmInfo]{?}", lastOneKmInfoData.toString());
        kq.b(lastOneKmInfoData);
    }

    public static void jniHttpRequestCallback(HttpResponseData httpResponseData) {
        aa0.a(TAG, "[jniHttpRequestCallback] {?}", httpResponseData.toString());
        qp.a().a(httpResponseData);
    }

    public static native void nativeHttpRequest(HttpRequestParam httpRequestParam);

    public static native void notifyTimeChange(String str, int i);

    public static void registerTimeChangeReceiver() {
        if (jp.I().l(10045)) {
            aa0.a(TAG, "[registerTimeChangeReceiver]notice: adapter custom timeChange receiver.", new Object[0]);
            return;
        }
        if (mTimeBroadcastReceiver == null) {
            mTimeBroadcastReceiver = new TimeBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.DATE_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_SET");
            try {
                ee.A().e().registerReceiver(mTimeBroadcastReceiver, intentFilter);
            } catch (Exception e) {
                aa0.a(TAG, "[registerTimeChangeReceiver]Exception", e, new Object[0]);
            }
            mTimeBroadcastReceiver.a();
            return;
        }
        aa0.a(TAG, "TimeBroadcastReceiver have already registered！", new Object[0]);
    }

    public static void setNoaStatus(boolean z) {
        aa0.a(TAG, "setNoaStatus: noaIsStatus={?}", Boolean.valueOf(z));
        mNoaIsStatus = z;
    }

    public static void unRegisterTimeChangeReceiver() {
        if (mTimeBroadcastReceiver != null) {
            try {
                ee.A().e().unregisterReceiver(mTimeBroadcastReceiver);
            } catch (Exception e) {
                aa0.a(TAG, "[unRegisterTimeChangeReceiver]unregisterReceiver", e, new Object[0]);
            }
            mTimeBroadcastReceiver = null;
        }
    }
}
