package com.autonavi.amapauto.textfont;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.Keep;
import defpackage.aa0;
import defpackage.d90;
import defpackage.e90;
import defpackage.f90;
import defpackage.g90;
import java.nio.ByteBuffer;

@Keep
/* loaded from: classes.dex */
public class GlyphLoader {
    public static final String TAG = "GlyphLoader";

    public static long createGlyphLoader() {
        return nativeCreateGlyphLoader();
    }

    public static String decodeUnicode(short s) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char) s);
        return stringBuffer.toString();
    }

    public static void destroyGlyphLoader(long j) {
        nativeDestroyGlyphLoader(j);
    }

    public static e90 genFontMetricsParam(byte[] bArr) {
        e90 e90Var = new e90();
        try {
            e90Var.a = g90.a(bArr, 0) * 0.001f;
            e90Var.b = g90.a(bArr, 4);
            int i = 12;
            if (1 == g90.a(bArr, 8)) {
                int a = g90.a(bArr, 12);
                e90Var.c = new String(bArr, 16, a);
                i = 16 + a;
            }
            e90Var.d = new String(bArr, i + 4, g90.a(bArr, i));
            return e90Var;
        } catch (Exception e) {
            aa0.a(TAG, "genFontMetricsParam error!", e, new Object[0]);
            return null;
        }
    }

    public static GlyphRequestParam genGlyphRequestParam(byte[] bArr) {
        GlyphRequestParam glyphRequestParam = new GlyphRequestParam();
        try {
            int a = g90.a(bArr, 0);
            glyphRequestParam.strBuffer = new String(bArr, 4, a);
            int i = a + 4;
            d90 d90Var = new d90();
            d90Var.a = g90.a(bArr, i);
            int i2 = i + 4;
            d90Var.b = g90.a(bArr, i2);
            int i3 = i2 + 4;
            int a2 = g90.a(bArr, i3);
            int i4 = i3 + 4;
            if (a2 > 0) {
                new String(bArr, i4, a2);
                i4 += a2;
            }
            FontMetrics fontMetrics = new FontMetrics();
            int a3 = g90.a(bArr, i4);
            int i5 = i4 + 4;
            fontMetrics.fAscent = a3 * 0.001f;
            int a4 = g90.a(bArr, i5);
            int i6 = i5 + 4;
            fontMetrics.fDescent = a4 * 0.001f;
            int a5 = g90.a(bArr, i6);
            int i7 = i6 + 4;
            fontMetrics.fLeading = a5 * 0.001f;
            int a6 = g90.a(bArr, i7);
            int i8 = i7 + 4;
            fontMetrics.fHeight = a6 * 0.001f;
            glyphRequestParam.font = d90Var;
            glyphRequestParam.drawingMode = g90.a(bArr, i8);
            int i9 = i8 + 4;
            int a7 = g90.a(bArr, i9);
            int i10 = i9 + 4;
            glyphRequestParam.strokeWidth = a7 * 0.001f;
            int a8 = g90.a(bArr, i10);
            int i11 = i10 + 4;
            glyphRequestParam.languageArr = new String(bArr, i11, a8);
            glyphRequestParam.isEmoji = g90.a(bArr, i11);
            int i12 = i11 + 4;
            glyphRequestParam.isSDF = g90.a(bArr, i12);
            int i13 = i12 + 4;
            int a9 = g90.a(bArr, i13);
            int i14 = i13 + 4;
            if (1 != a9) {
                return glyphRequestParam;
            }
            GlyphMetrics glyphMetrics = new GlyphMetrics();
            glyphMetrics.nWidth = g90.a(bArr, i14);
            int i15 = i14 + 4;
            glyphMetrics.nHeight = g90.a(bArr, i15);
            int i16 = i15 + 4;
            int a10 = g90.a(bArr, i16);
            int i17 = i16 + 4;
            glyphMetrics.fLeft = a10 * 0.001f;
            glyphMetrics.fTop = g90.a(bArr, i17) * 0.001f;
            glyphMetrics.fAdvance = g90.a(bArr, i17 + 4) * 0.001f;
            glyphRequestParam.fGlyphMetrics = glyphMetrics;
            return glyphRequestParam;
        } catch (Exception e) {
            aa0.a(TAG, "genGlyphRequestParam error!", e, new Object[0]);
            return null;
        }
    }

    public static FontMetrics getFontMetrics(byte[] bArr) {
        return getFontMetrics(genFontMetricsParam(bArr));
    }

    public static GlyphMetrics getGlyphMetrics(byte[] bArr) {
        return getGlyphMetrics(genGlyphRequestParam(bArr));
    }

    public static GlyphRaster getGlyphRaster(byte[] bArr) {
        return getGlyphRaster(genGlyphRequestParam(bArr));
    }

    public static GlyphMetrics loadGlyphMetrics(String str, f90 f90Var, float f, String str2, boolean z, float f2, boolean z2, boolean z3) {
        GlyphMetrics glyphMetrics = new GlyphMetrics();
        if (f90Var == null || TextUtils.isEmpty(str)) {
            return glyphMetrics;
        }
        try {
            if (!z2) {
                aa0.a(TAG, "loadGlyphMetrics, newTextPaint", new Object[0]);
                TextPaint newTextPaint = newTextPaint(f90Var, f, str2, z, f2);
                Rect rect = new Rect();
                newTextPaint.getTextBounds(str, 0, str.length(), rect);
                if (rect.width() == 0 && rect.height() == 0) {
                    float measureText = newTextPaint.measureText(" ", 0, 1);
                    float abs = Math.abs(newTextPaint.getFontMetrics().ascent) + Math.abs(newTextPaint.getFontMetrics().descent);
                    rect.top = 0;
                    rect.left = 0;
                    rect.right = (int) measureText;
                    rect.bottom = (int) abs;
                }
                if (z && f2 > 0.0f) {
                    float f3 = f2 / 2.0f;
                    rect.top = (int) (rect.top - f3);
                    rect.left = (int) (rect.left - f3);
                    rect.right = (int) (rect.right + f3);
                    rect.bottom = (int) (rect.bottom + f3);
                }
                glyphMetrics.bSuccess = true;
                glyphMetrics.fLeft = rect.left;
                glyphMetrics.fTop = Math.abs(newTextPaint.getFontMetrics().ascent) - Math.abs(rect.top);
                glyphMetrics.nWidth = rect.width();
                glyphMetrics.nHeight = rect.height();
                glyphMetrics.fAdvance = newTextPaint.measureText(str);
            } else {
                glyphMetrics.bSuccess = true;
                glyphMetrics.fLeft = 0.0f;
                glyphMetrics.fTop = 0.0f;
                int i = (int) f;
                glyphMetrics.nWidth = i;
                glyphMetrics.nHeight = i;
                glyphMetrics.fAdvance = f;
            }
        } catch (Exception unused) {
            glyphMetrics.bSuccess = false;
        }
        aa0.a(TAG, "loadGlyphMetrics, info:{?}", glyphMetrics.toString());
        return glyphMetrics;
    }

    /* JADX WARN: Removed duplicated region for block: B:30:0x00dc  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x011c A[Catch: Exception -> 0x0153, TryCatch #1 {Exception -> 0x0153, blocks: (B:13:0x0061, B:15:0x0077, B:17:0x007d, B:21:0x00a9, B:22:0x00c8, B:24:0x00ce, B:31:0x00df, B:33:0x011c, B:36:0x0122, B:38:0x0126, B:40:0x0134, B:43:0x0138, B:45:0x013e, B:46:0x0144, B:47:0x0142, B:49:0x00d7, B:50:0x014e), top: B:12:0x0061 }] */
    /* JADX WARN: Removed duplicated region for block: B:45:0x013e A[Catch: Exception -> 0x0153, TryCatch #1 {Exception -> 0x0153, blocks: (B:13:0x0061, B:15:0x0077, B:17:0x007d, B:21:0x00a9, B:22:0x00c8, B:24:0x00ce, B:31:0x00df, B:33:0x011c, B:36:0x0122, B:38:0x0126, B:40:0x0134, B:43:0x0138, B:45:0x013e, B:46:0x0144, B:47:0x0142, B:49:0x00d7, B:50:0x014e), top: B:12:0x0061 }] */
    /* JADX WARN: Removed duplicated region for block: B:47:0x0142 A[Catch: Exception -> 0x0153, TryCatch #1 {Exception -> 0x0153, blocks: (B:13:0x0061, B:15:0x0077, B:17:0x007d, B:21:0x00a9, B:22:0x00c8, B:24:0x00ce, B:31:0x00df, B:33:0x011c, B:36:0x0122, B:38:0x0126, B:40:0x0134, B:43:0x0138, B:45:0x013e, B:46:0x0144, B:47:0x0142, B:49:0x00d7, B:50:0x014e), top: B:12:0x0061 }] */
    /* JADX WARN: Removed duplicated region for block: B:48:0x00de  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static com.autonavi.amapauto.textfont.GlyphRaster loadGlyphRaster(java.lang.String r8, defpackage.f90 r9, float r10, java.lang.String r11, boolean r12, float r13, boolean r14, boolean r15) {
        /*
            Method dump skipped, instructions count: 355
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.amapauto.textfont.GlyphLoader.loadGlyphRaster(java.lang.String, f90, float, java.lang.String, boolean, float, boolean, boolean):com.autonavi.amapauto.textfont.GlyphRaster");
    }

    public static GlyphRaster loadPathRaster(String str, f90 f90Var, float f, String str2, boolean z, float f2) {
        GlyphRaster glyphRaster = new GlyphRaster();
        if (f90Var == null || TextUtils.isEmpty(str)) {
            return glyphRaster;
        }
        try {
            TextPaint newTextPaint = newTextPaint(f90Var, f, str2, false, 0.0f);
            Rect rect = new Rect();
            newTextPaint.getTextBounds(str, 0, str.length(), rect);
            new Canvas(Bitmap.createBitmap(rect.width(), rect.height(), Bitmap.Config.ALPHA_8)).drawText(str, 0 - rect.left, 0 - rect.top, newTextPaint);
            TextPaint newTextPaint2 = newTextPaint(f90Var, f, str2, z, f2);
            Rect rect2 = new Rect();
            newTextPaint2.getTextBounds(str, 0, str.length(), rect2);
            if (z && f2 > 0.0f) {
                float f3 = 0.5f * f2;
                rect2.top = (int) (rect2.top - f3);
                rect2.left = (int) (rect2.left - f3);
                rect2.right = (int) (rect2.right + f3);
                rect2.bottom = (int) (rect2.bottom + f3);
            }
            if (!rect2.isEmpty()) {
                Bitmap createBitmap = Bitmap.createBitmap(rect2.width(), rect2.height(), Bitmap.Config.ALPHA_8);
                Canvas canvas = new Canvas(createBitmap);
                float f4 = 0 - rect2.left;
                float f5 = 0 - rect2.top;
                Path path = new Path();
                newTextPaint.getTextPath(str, 0, str.length(), f4, f5, path);
                canvas.drawPath(path, newTextPaint2);
                int width = rect2.width() * rect2.height();
                byte[] bArr = new byte[width];
                ByteBuffer wrap = ByteBuffer.wrap(bArr);
                glyphRaster.bitmapWidth = rect2.width();
                glyphRaster.bitmapHeight = rect2.height();
                glyphRaster.bitmapPixelMode = 0;
                glyphRaster.bitmapSize = width;
                createBitmap.copyPixelsToBuffer(wrap);
                createBitmap.recycle();
                glyphRaster.bitmapBuffer = bArr;
                glyphRaster.bSuccess = true;
            }
        } catch (Exception unused) {
            glyphRaster.bSuccess = false;
        }
        aa0.a(TAG, "loadPathRaster, info:{?}", glyphRaster.toString());
        return glyphRaster;
    }

    public static native long nativeCreateGlyphLoader();

    public static native void nativeDestroyGlyphLoader(long j);

    /* JADX WARN: Code restructure failed: missing block: B:28:0x0054, code lost:            if (r3 != false) goto L29;     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static android.text.TextPaint newTextPaint(defpackage.f90 r2, float r3, java.lang.String r4, boolean r5, float r6) {
        /*
            android.text.TextPaint r0 = new android.text.TextPaint
            r0.<init>()
            if (r2 != 0) goto L8
            return r0
        L8:
            r1 = -1
            r0.setColor(r1)
            r1 = 1
            r0.setAntiAlias(r1)
            r0.setFilterBitmap(r1)
            r0.setTextSize(r3)
            android.graphics.Paint$Align r3 = android.graphics.Paint.Align.LEFT
            r0.setTextAlign(r3)
            if (r5 == 0) goto L26
            android.graphics.Paint$Style r3 = android.graphics.Paint.Style.STROKE
            r0.setStyle(r3)
            r0.setStrokeWidth(r6)
            goto L2b
        L26:
            android.graphics.Paint$Style r3 = android.graphics.Paint.Style.FILL
            r0.setStyle(r3)
        L2b:
            int r3 = r2.a()
            r5 = 2
            r6 = 0
            if (r3 == 0) goto L3a
            if (r3 == r1) goto L38
            if (r3 == r5) goto L38
            goto L3a
        L38:
            r3 = 1
            goto L3b
        L3a:
            r3 = 0
        L3b:
            int r2 = r2.b()
            switch(r2) {
                case 0: goto L45;
                case 100: goto L45;
                case 200: goto L45;
                case 300: goto L45;
                case 400: goto L45;
                case 500: goto L43;
                case 600: goto L43;
                case 700: goto L43;
                case 800: goto L43;
                case 900: goto L43;
                case 1000: goto L43;
                default: goto L42;
            }
        L42:
            goto L45
        L43:
            r2 = 1
            goto L46
        L45:
            r2 = 0
        L46:
            if (r2 == 0) goto L4e
            if (r3 == 0) goto L4e
            r0.setFakeBoldText(r1)
            goto L57
        L4e:
            if (r2 == 0) goto L54
            r0.setFakeBoldText(r1)
            goto L57
        L54:
            if (r3 == 0) goto L57
            goto L58
        L57:
            r5 = 0
        L58:
            boolean r2 = android.text.TextUtils.isEmpty(r4)
            if (r2 == 0) goto L65
            android.graphics.Typeface r2 = android.graphics.Typeface.DEFAULT
            android.graphics.Typeface r2 = android.graphics.Typeface.create(r2, r5)
            goto L69
        L65:
            android.graphics.Typeface r2 = android.graphics.Typeface.create(r4, r5)
        L69:
            r0.setTypeface(r2)
            return r0
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.amapauto.textfont.GlyphLoader.newTextPaint(f90, float, java.lang.String, boolean, float):android.text.TextPaint");
    }

    public static FontMetrics getFontMetrics(e90 e90Var) {
        FontMetrics fontMetrics = new FontMetrics();
        if (e90Var == null) {
            return fontMetrics;
        }
        aa0.a(TAG, "getFontMetrics, param:{?}", e90Var.toString());
        Paint.FontMetrics fontMetrics2 = newTextPaint(new f90(e90Var.b), e90Var.a, e90Var.d, false, 0.0f).getFontMetrics();
        fontMetrics.bSuccess = true;
        fontMetrics.fAscent = Math.abs(fontMetrics2.ascent);
        fontMetrics.fDescent = Math.abs(fontMetrics2.descent);
        fontMetrics.fLeading = Math.abs(fontMetrics2.leading);
        fontMetrics.fHeight = Math.abs(fontMetrics2.ascent) + Math.abs(fontMetrics2.descent);
        aa0.a(TAG, "getFontMetrics, fm:{?}", fontMetrics.toString());
        return fontMetrics;
    }

    public static GlyphMetrics getGlyphMetrics(GlyphRequestParam glyphRequestParam) {
        if (glyphRequestParam == null) {
            return new GlyphMetrics();
        }
        aa0.a(TAG, "getGlyphMetrics, glyphRequestParam:{?}", glyphRequestParam.toString());
        return loadGlyphMetrics(glyphRequestParam.strBuffer, new f90(glyphRequestParam.font.a), glyphRequestParam.font.b, glyphRequestParam.languageArr, glyphRequestParam.drawingMode != 0, glyphRequestParam.strokeWidth, glyphRequestParam.isEmoji > 0, glyphRequestParam.isSDF > 0);
    }

    public static GlyphRaster getGlyphRaster(GlyphRequestParam glyphRequestParam) {
        if (glyphRequestParam == null) {
            return new GlyphRaster();
        }
        aa0.a(TAG, "getGlyphRaster, param:{?}", glyphRequestParam.toString());
        f90 f90Var = new f90(glyphRequestParam.font.a);
        boolean z = glyphRequestParam.drawingMode != 0;
        if (glyphRequestParam.drawingMode == 3) {
            return loadPathRaster(glyphRequestParam.strBuffer, f90Var, glyphRequestParam.font.b, glyphRequestParam.languageArr, z, glyphRequestParam.strokeWidth * 2.0f);
        }
        return loadGlyphRaster(glyphRequestParam.strBuffer, f90Var, glyphRequestParam.font.b, glyphRequestParam.languageArr, z, glyphRequestParam.strokeWidth, glyphRequestParam.isEmoji > 0, glyphRequestParam.isSDF > 0);
    }

    public static String decodeUnicode(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(str);
        return stringBuffer.toString();
    }
}
