package com.autonavi.amapauto.textfont;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Environment;
import android.text.TextPaint;
import android.text.TextUtils;
import defpackage.aa0;
import defpackage.da0;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;

/* loaded from: classes.dex */
public class TextTextureGenerator {
    public static final int ALIGNCENTER = 51;
    public static final int ALIGNLEFT = 49;
    public static final int ALIGNRIGHT = 50;
    public static final int AN_LABEL_MAXCHARINLINE = 7;
    public static final int AN_LABEL_MULITYLINE_SPAN = 2;
    public static final int BREAK_TO_CHARACTERS_TYPE = 2;
    public static final int BREAK_TO_WORDS_TYPE = 1;
    public static final String TAG = "TextTextureGenerator";
    public static int TEXT_FONTSIZE = -1;
    public static int TEXT_FONTSIZE_TRUE = -1;
    public float base_line = 0.0f;
    public float start_x = 0.0f;
    public Paint text_paint = null;

    public TextTextureGenerator() {
        createTextParam();
    }

    public static int GetNearstSize2N(int i) {
        int i2 = 1;
        while (i > i2) {
            i2 *= 2;
        }
        return i2;
    }

    public static String[] breakCharacters(String str, int i) {
        BreakIterator wordInstance;
        aa0.a(TAG, "breakCharacters text:{?}, breakType:{?}", str, Integer.valueOf(i));
        ArrayList arrayList = new ArrayList(str.length());
        if (i != 1) {
            wordInstance = BreakIterator.getCharacterInstance();
        } else {
            wordInstance = BreakIterator.getWordInstance();
        }
        wordInstance.setText(str);
        int first = wordInstance.first();
        int next = wordInstance.next();
        while (true) {
            int i2 = next;
            int i3 = first;
            first = i2;
            if (first != -1) {
                String substring = str.substring(i3, first);
                aa0.a(TAG, "breakCharacters subStr:{?}", substring);
                arrayList.add(substring);
                next = wordInstance.next();
            } else {
                return (String[]) arrayList.toArray(new String[0]);
            }
        }
    }

    private void createTextParam() {
        float f;
        int i = TEXT_FONTSIZE - 2;
        TEXT_FONTSIZE_TRUE = i;
        aa0.a(TAG, "createTextParam TEXT_FONTSIZE_TRUE={?}", Integer.valueOf(i));
        Paint newPaint = newPaint(null, TEXT_FONTSIZE_TRUE, 49);
        this.text_paint = newPaint;
        float f2 = (TEXT_FONTSIZE - TEXT_FONTSIZE_TRUE) / 2.0f;
        this.start_x = f2;
        float f3 = 0.0f;
        float f4 = 7.3242188f;
        float f5 = -27.832031f;
        float f6 = -31.68457f;
        float f7 = 8.129883f;
        try {
            Paint.FontMetrics fontMetrics = newPaint.getFontMetrics();
            f4 = fontMetrics.descent;
            f5 = fontMetrics.ascent;
            f6 = fontMetrics.top;
            f7 = fontMetrics.bottom;
            f = fontMetrics.leading;
        } catch (Exception unused) {
            f = 0.0f;
        }
        if (f > 10.0f) {
            aa0.a(TAG, "leading:{?}", Float.valueOf(f));
        } else {
            f3 = f;
        }
        this.base_line = (((TEXT_FONTSIZE_TRUE + f3) - (f4 + f5)) / 2.0f) + f2 + 0.5f;
        aa0.a(TAG, "descent:{?}, ascent:{?}, top:{?}, bottom:{?}, leading:{?}, delta:{?}, base_line:{?}", Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f3), Float.valueOf(f2), Float.valueOf(this.base_line));
    }

    public static void generaAsccIITexturePng() throws Exception {
        if (Environment.getExternalStorageState().equals("mounted")) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(da0.g(), "asccii.png"));
            Paint newPaint = newPaint(null, TEXT_FONTSIZE, 49);
            int i = TEXT_FONTSIZE;
            Bitmap createBitmap = Bitmap.createBitmap(i * 16, i * 16, Bitmap.Config.ARGB_8888);
            Paint.FontMetricsInt fontMetricsInt = newPaint.getFontMetricsInt();
            Canvas canvas = new Canvas(createBitmap);
            Paint newPaint2 = newPaint(null, TEXT_FONTSIZE, 49);
            float[] fArr = new float[1];
            for (int i2 = 0; i2 < 16; i2++) {
                for (int i3 = 0; i3 < 16; i3++) {
                    char c = (char) ((i2 * 16) + i3);
                    canvas.drawText(c + "", i3 * 16, (r10 - fontMetricsInt.ascent) - 2, newPaint2);
                    newPaint2.getTextWidths(c + "", fArr);
                }
            }
            createBitmap.compress(Bitmap.CompressFormat.PNG, 100, fileOutputStream);
            if (createBitmap != null && !createBitmap.isRecycled()) {
                createBitmap.recycle();
            }
            fileOutputStream.close();
        }
    }

    public static float getFontHeight(Paint paint) {
        if (paint == null) {
            return 0.0f;
        }
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.descent - fontMetrics.ascent;
    }

    public static float getFontlength(Paint paint, String str) {
        if (paint == null) {
            return 0.0f;
        }
        return paint.measureText(str);
    }

    public static Paint newPaint(String str, int i, int i2) {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize(i);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTypeface(Typeface.DEFAULT_BOLD);
        switch (i2) {
            case 49:
                textPaint.setTextAlign(Paint.Align.LEFT);
                return textPaint;
            case 50:
                textPaint.setTextAlign(Paint.Align.RIGHT);
                return textPaint;
            case 51:
                textPaint.setTextAlign(Paint.Align.CENTER);
                return textPaint;
            default:
                textPaint.setTextAlign(Paint.Align.LEFT);
                return textPaint;
        }
    }

    public byte[] getCharsWidths(int[] iArr, int i) {
        aa0.a(TAG, "getCharsWidths, TEXT_FONTSIZE={?}, fontsize={?}", Integer.valueOf(TEXT_FONTSIZE), Integer.valueOf(i));
        if (iArr == null) {
            return null;
        }
        if (TEXT_FONTSIZE != i) {
            TEXT_FONTSIZE = i;
            createTextParam();
        }
        int length = iArr.length;
        byte[] bArr = new byte[length];
        float[] fArr = new float[1];
        for (int i2 = 0; i2 < length; i2++) {
            fArr[0] = this.text_paint.measureText(((char) iArr[i2]) + "");
            bArr[i2] = (byte) ((int) (fArr[0] + ((float) (TEXT_FONTSIZE - TEXT_FONTSIZE_TRUE))));
        }
        aa0.a(TAG, "getCharsWidths chars:{?}, bs:{?}", Arrays.toString(iArr), Arrays.toString(bArr));
        return bArr;
    }

    public CharInfo getGFrameChar(CharData charData) {
        aa0.a(TAG, "getGFrameChar", new Object[0]);
        CharInfo charInfo = new CharInfo();
        if (charData.Size != 0 && charData.wcChar != 0) {
            TextPaint textPaint = new TextPaint();
            textPaint.setColor(-256);
            textPaint.setTextSize(charData.Size);
            textPaint.setAntiAlias(true);
            textPaint.setFilterBitmap(true);
            int i = charData.Type;
            if ((i & 2) == 2 && (i & 4) == 4) {
                textPaint.setTypeface(Typeface.defaultFromStyle(3));
            } else {
                int i2 = charData.Type;
                if ((i2 & 2) == 2) {
                    textPaint.setTypeface(Typeface.defaultFromStyle(1));
                } else if ((i2 & 4) == 4) {
                    textPaint.setTypeface(Typeface.defaultFromStyle(2));
                }
            }
            if ((charData.Type & 8) == 8) {
                textPaint.setUnderlineText(true);
            }
            textPaint.setTextAlign(Paint.Align.LEFT);
            Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
            charInfo.advanceX = (int) (textPaint.getTextSize() * 0.85f);
            charInfo.ascender = (int) (-fontMetrics.top);
            charInfo.descender = (int) fontMetrics.bottom;
            String valueOf = String.valueOf(new char[]{(char) charData.wcChar}[0]);
            int measureText = TextUtils.isEmpty(valueOf) ? 0 : (int) textPaint.measureText(valueOf);
            int i3 = charInfo.ascender + charInfo.descender;
            if (measureText > 0 && i3 > 0) {
                charInfo.ptPointX = measureText;
                charInfo.ptPointY = i3;
                charInfo.advanceX = measureText;
                Bitmap createBitmap = Bitmap.createBitmap(measureText, i3, Bitmap.Config.ALPHA_8);
                byte[] bArr = new byte[measureText * i3];
                Canvas canvas = new Canvas(createBitmap);
                ByteBuffer wrap = ByteBuffer.wrap(bArr);
                this.text_paint.measureText(valueOf);
                canvas.drawText(valueOf, 0.0f, charInfo.ascender, textPaint);
                createBitmap.copyPixelsToBuffer(wrap);
                if (createBitmap != null && !createBitmap.isRecycled()) {
                    createBitmap.recycle();
                }
                charInfo.buffer = bArr;
            }
        }
        return charInfo;
    }

    public byte[] getTextPixelBuffer(int i, int i2) {
        aa0.a(TAG, "getTextPixelBuffer, aChar={?}, fontsize={?}", Integer.valueOf(i), Integer.valueOf(i2));
        if (TEXT_FONTSIZE != i2) {
            TEXT_FONTSIZE = i2;
            createTextParam();
        }
        try {
            char c = (char) i;
            char[] cArr = {c};
            aa0.a(TAG, "getTextPixelBuffer, aChar={?}", String.valueOf(c));
            float f = this.base_line;
            Bitmap createBitmap = Bitmap.createBitmap(TEXT_FONTSIZE, TEXT_FONTSIZE, Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(createBitmap);
            byte[] bArr = new byte[TEXT_FONTSIZE * TEXT_FONTSIZE];
            ByteBuffer wrap = ByteBuffer.wrap(bArr);
            float measureText = this.text_paint.measureText(String.valueOf(c));
            if (cArr[0] > 0 && cArr[0] < 256) {
                f -= 1.5f;
            }
            float f2 = f;
            Paint.Align textAlign = this.text_paint.getTextAlign();
            float textSize = this.text_paint.getTextSize();
            float f3 = measureText - TEXT_FONTSIZE_TRUE;
            if (textAlign != Paint.Align.CENTER && f3 >= 4.0f) {
                this.text_paint.setTextAlign(Paint.Align.CENTER);
                this.text_paint.setTextSize(TEXT_FONTSIZE_TRUE - f3);
                canvas.drawText(cArr, 0, 1, (TEXT_FONTSIZE_TRUE - f3) / 2.0f, f2, this.text_paint);
                this.text_paint.setTextAlign(textAlign);
                this.text_paint.setTextSize(textSize);
            } else {
                canvas.drawText(cArr, 0, 1, this.start_x, f2, this.text_paint);
            }
            createBitmap.copyPixelsToBuffer(wrap);
            if (createBitmap != null && !createBitmap.isRecycled()) {
                createBitmap.recycle();
            }
            return bArr;
        } catch (Exception e) {
            aa0.a(TAG, "getTextPixelBuffer Exception", e, new Object[0]);
            e.printStackTrace();
            return null;
        }
    }
}
