package com.autonavi.amapauto.user;

import android.text.TextUtils;
import defpackage.aa0;
import defpackage.fa0;
import java.util.regex.Pattern;

/* loaded from: classes.dex */
public class UserPhone implements Comparable<UserPhone> {
    public static final String FIRST_LETTER = "历";
    public static final String SPECIAL_LETTER = "#";
    public String firstLetter;
    public boolean isHistory;
    public String name;
    public String phone;
    public String pinyin;

    public UserPhone(String str, String str2, boolean z) {
        this.name = str;
        this.phone = str2;
        this.isHistory = z;
        if (z) {
            this.pinyin = FIRST_LETTER;
            return;
        }
        if (TextUtils.isEmpty(str)) {
            this.pinyin = SPECIAL_LETTER;
            this.firstLetter = SPECIAL_LETTER;
            return;
        }
        if (Pattern.compile("[一-龥]").matcher(str).find()) {
            String upperCase = fa0.c(str).toUpperCase();
            this.pinyin = upperCase;
            if (TextUtils.isEmpty(upperCase)) {
                this.pinyin = SPECIAL_LETTER;
                this.firstLetter = SPECIAL_LETTER;
                return;
            } else {
                this.firstLetter = String.valueOf(this.pinyin.charAt(0));
                return;
            }
        }
        this.pinyin = SPECIAL_LETTER;
        this.firstLetter = SPECIAL_LETTER;
    }

    public String getFirstLetter() {
        return this.firstLetter;
    }

    public boolean getIsHistory() {
        return this.isHistory;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    @Override // java.lang.Comparable
    public int compareTo(UserPhone userPhone) {
        int compareTo;
        String name = userPhone.getName();
        String pinyin = userPhone.getPinyin();
        boolean isEmpty = TextUtils.isEmpty(this.pinyin);
        boolean isEmpty2 = TextUtils.isEmpty(this.name);
        boolean isEmpty3 = TextUtils.isEmpty(pinyin);
        boolean isEmpty4 = TextUtils.isEmpty(name);
        if (!isEmpty && !isEmpty3) {
            compareTo = this.pinyin.compareToIgnoreCase(pinyin);
        } else if (!isEmpty2 && !isEmpty4) {
            compareTo = this.name.compareTo(name);
        } else if (!isEmpty && !isEmpty4) {
            compareTo = this.pinyin.compareTo(name);
        } else {
            compareTo = (isEmpty2 || isEmpty3) ? 0 : this.name.compareTo(pinyin);
        }
        aa0.a("UserPhoneCompare", "pinyin={?};name={?};pinyinToCompare={?};nameToCompare={?};result={?}", this.pinyin, this.name, pinyin, name, Integer.valueOf(compareTo));
        return compareTo;
    }
}
