package com.autonavi.amapauto.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import com.autonavi.indoor.pdr.ErrorCode;
import defpackage.aa0;
import defpackage.ca0;
import defpackage.ee;
import defpackage.ua0;
import defpackage.y90;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/* loaded from: classes.dex */
public class FileUtils {
    public static final int CHECK_STATUS_BOTH_ERROR = 3;
    public static final int CHECK_STATUS_BOTH_SUCCESS = 0;
    public static final int CHECK_STATUS_MD5_ERROR = 2;
    public static final int CHECK_STATUS_PKG_ERROR = 1;
    public static final String ILLEGAL_CHAR = "\\.\\./";
    public static String TAG = "FileUtils";

    public static boolean checkApkMD5(String str, File file) {
        String a;
        return (file == null || !file.exists() || TextUtils.isEmpty(str) || (a = ca0.a(file)) == null || !str.equalsIgnoreCase(a)) ? false : true;
    }

    public static boolean checkApkPkgName(Context context, String str) {
        PackageInfo packageArchiveInfo = context.getPackageManager().getPackageArchiveInfo(replaceIllegalChar(str), 1);
        if (packageArchiveInfo == null || packageArchiveInfo.applicationInfo == null) {
            return false;
        }
        aa0.a("AutoAppUpdateUtil", "checkApkPkgName app = {?}, apk = {?}", context.getPackageName(), packageArchiveInfo.applicationInfo.packageName);
        return context.getPackageName().equals(packageArchiveInfo.applicationInfo.packageName);
    }

    public static char cleanChar(char c) {
        if ('0' <= c && c < ':') {
            return c;
        }
        if ('A' <= c && c < '[') {
            return c;
        }
        if (('a' <= c && c < '{') || c == ' ' || c == '_') {
            return c;
        }
        switch (c) {
            case '-':
            case '.':
            case '/':
                return c;
            default:
                return '%';
        }
    }

    public static final String cleanIllegalString(String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i++) {
            sb.append(cleanChar(str.charAt(i)));
        }
        return sb.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r3v0, types: [java.io.File] */
    /* JADX WARN: Type inference failed for: r3v1 */
    /* JADX WARN: Type inference failed for: r3v10 */
    /* JADX WARN: Type inference failed for: r3v11 */
    /* JADX WARN: Type inference failed for: r3v12 */
    /* JADX WARN: Type inference failed for: r3v13 */
    /* JADX WARN: Type inference failed for: r3v14 */
    /* JADX WARN: Type inference failed for: r3v15 */
    /* JADX WARN: Type inference failed for: r3v16, types: [java.io.FileOutputStream] */
    /* JADX WARN: Type inference failed for: r3v20 */
    /* JADX WARN: Type inference failed for: r3v21 */
    /* JADX WARN: Type inference failed for: r3v4 */
    /* JADX WARN: Type inference failed for: r3v5, types: [java.io.Closeable] */
    /* JADX WARN: Type inference failed for: r3v7 */
    public static void copyFile(File file, File file2) {
        Object obj;
        Object obj2;
        Closeable closeable;
        if (!file2.exists()) {
            new File(file2.getParent() + "/").mkdirs();
            createFile(file2, true);
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                FileInputStream fileInputStream2 = new FileInputStream((File) file);
                try {
                    file = new FileOutputStream(file2);
                    try {
                        byte[] bArr = new byte[ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR];
                        while (fileInputStream2.read(bArr) != -1) {
                            file.write(bArr);
                        }
                        closeQuietly(fileInputStream2);
                        closeable = file;
                    } catch (FileNotFoundException e) {
                        e = e;
                        fileInputStream = fileInputStream2;
                        obj2 = file;
                        e.printStackTrace();
                        file = obj2;
                        closeQuietly(fileInputStream);
                        closeable = file;
                        closeQuietly(closeable);
                    } catch (IOException e2) {
                        e = e2;
                        fileInputStream = fileInputStream2;
                        obj = file;
                        e.printStackTrace();
                        file = obj;
                        closeQuietly(fileInputStream);
                        closeable = file;
                        closeQuietly(closeable);
                    } catch (Throwable th) {
                        th = th;
                        fileInputStream = fileInputStream2;
                        closeQuietly(fileInputStream);
                        closeQuietly(file);
                        throw th;
                    }
                } catch (FileNotFoundException e3) {
                    e = e3;
                    file = 0;
                } catch (IOException e4) {
                    e = e4;
                    file = 0;
                } catch (Throwable th2) {
                    th = th2;
                    file = 0;
                }
            } catch (FileNotFoundException e5) {
                e = e5;
                obj2 = null;
            } catch (IOException e6) {
                e = e6;
                obj = null;
            } catch (Throwable th3) {
                th = th3;
                file = 0;
            }
            closeQuietly(closeable);
        } catch (Throwable th4) {
            th = th4;
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null || outputStream == null) {
            return;
        }
        byte[] bArr = new byte[ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR];
        while (true) {
            try {
                int read = inputStream.read(bArr);
                if (read == -1) {
                    break;
                } else {
                    outputStream.write(bArr, 0, read);
                }
            } catch (IOException unused) {
            } catch (Throwable th) {
                closeQuietly(inputStream);
                closeQuietly(outputStream);
                throw th;
            }
        }
        closeQuietly(inputStream);
        closeQuietly(outputStream);
    }

    public static void createFile(File file, boolean z) {
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            createFile(file.getParentFile(), false);
            return;
        }
        if (z) {
            try {
                file.createNewFile();
                return;
            } catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        file.mkdir();
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        File[] listFiles = file.listFiles();
        if (file.isDirectory() && listFiles != null) {
            for (File file2 : listFiles) {
                deleteFile(file2);
            }
        }
        file.delete();
    }

    public static long getAvailableByteSize(String str) {
        long blockSize;
        long availableBlocks;
        try {
            StatFs statFs = new StatFs(str);
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFs.getBlockSizeLong();
                availableBlocks = statFs.getAvailableBlocksLong();
            } else {
                blockSize = statFs.getBlockSize();
                availableBlocks = statFs.getAvailableBlocks();
            }
            return availableBlocks * blockSize;
        } catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static void installApk(String str) {
        aa0.a(TAG, "install: filePath = {?}", str);
        File file = new File(replaceIllegalChar(str));
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(268435456);
        intent.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
        Activity j = ee.A().j();
        if (j != null) {
            j.startActivity(intent);
        } else {
            aa0.a(TAG, "installApk get null hostActivity", new Object[0]);
        }
    }

    public static int installApkAndCheck(String str, String str2) {
        aa0.a(TAG + " AppDownLoader getDepinfo : result = {?}", str);
        File file = new File(replaceIllegalChar(str));
        boolean checkApkMD5 = checkApkMD5(str2, file);
        boolean checkApkPkgName = checkApkPkgName(ee.A().f(), str);
        if (checkApkMD5 && checkApkPkgName) {
            installApk(str);
            return 0;
        }
        deleteFile(file);
        if (checkApkMD5) {
            aa0.a(TAG, " VoiceDownloader getDepinfo : 包名校验失败", new Object[0]);
            return 1;
        }
        if (checkApkPkgName) {
            aa0.a(TAG, " VoiceDownloader getDepinfo : MD5校验失败", new Object[0]);
            return 2;
        }
        aa0.a(TAG, " VoiceDownloader getDepinfo : 包名校验失败，MD5校验失败", new Object[0]);
        return 3;
    }

    public static byte[] readFile(String str) {
        if (str == null) {
            return null;
        }
        return readFile(new File(replaceIllegalChar(str)));
    }

    public static String readStringFromAsets(Context context, String str) {
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().getAssets().open(str);
            byte[] bArr = new byte[inputStream.available()];
            int read = inputStream.read(bArr);
            if (read <= 0) {
                aa0.a(TAG, "readStringFromAsets - the number of bytes read into the buffer is {?} !!!!!", Integer.valueOf(read));
            }
            String a = ua0.a(bArr, "utf-8");
            y90.a(inputStream);
            return a;
        } catch (Exception unused) {
            y90.a(inputStream);
            return "";
        } catch (Throwable th) {
            y90.a(inputStream);
            throw th;
        }
    }

    public static String replaceIllegalChar(String str) {
        return TextUtils.isEmpty(str) ? "" : str.replaceAll(ILLEGAL_CHAR, "");
    }

    public static void writeDatasToFile(String str, byte[] bArr) {
        ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        writeLock.lock();
        FileOutputStream fileOutputStream = null;
        if (bArr != null) {
            try {
                try {
                } catch (Throwable th) {
                    th = th;
                }
            } catch (Exception e) {
                e = e;
            }
            if (bArr.length != 0) {
                File file = new File(replaceIllegalChar(str));
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream fileOutputStream2 = new FileOutputStream(file);
                try {
                    fileOutputStream2.write(bArr);
                    fileOutputStream2.flush();
                    y90.a(fileOutputStream2);
                } catch (Exception e2) {
                    fileOutputStream = fileOutputStream2;
                    e = e2;
                    aa0.a(TAG, "writeDatasToFile ex:" + e.toString(), new Object[0]);
                    y90.a(fileOutputStream);
                    writeLock.unlock();
                    return;
                } catch (Throwable th2) {
                    fileOutputStream = fileOutputStream2;
                    th = th2;
                    y90.a(fileOutputStream);
                    writeLock.unlock();
                    throw th;
                }
                writeLock.unlock();
                return;
            }
        }
        y90.a(null);
        writeLock.unlock();
    }

    /* JADX WARN: Code restructure failed: missing block: B:19:0x0030, code lost:            if (r1 == null) goto L26;     */
    /* JADX WARN: Code restructure failed: missing block: B:20:0x0033, code lost:            return null;     */
    /* JADX WARN: Code restructure failed: missing block: B:22:0x002b, code lost:            r1.close();     */
    /* JADX WARN: Code restructure failed: missing block: B:26:0x0029, code lost:            if (r1 == null) goto L26;     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static byte[] readFile(java.io.File r3) {
        /*
            r0 = 0
            if (r3 != 0) goto L4
            return r0
        L4:
            java.io.FileInputStream r1 = new java.io.FileInputStream     // Catch: java.lang.Throwable -> L21 java.io.IOException -> L28 java.io.FileNotFoundException -> L2f
            r1.<init>(r3)     // Catch: java.lang.Throwable -> L21 java.io.IOException -> L28 java.io.FileNotFoundException -> L2f
            int r3 = r1.available()     // Catch: java.lang.Throwable -> L1a java.io.IOException -> L1d java.io.FileNotFoundException -> L1f
            byte[] r3 = new byte[r3]     // Catch: java.lang.Throwable -> L1a java.io.IOException -> L1d java.io.FileNotFoundException -> L1f
            int r2 = r1.read(r3)     // Catch: java.lang.Throwable -> L1a java.io.IOException -> L1d java.io.FileNotFoundException -> L1f
            if (r2 <= 0) goto L16
            r0 = r3
        L16:
            r1.close()     // Catch: java.io.IOException -> L19
        L19:
            return r0
        L1a:
            r3 = move-exception
            r0 = r1
            goto L22
        L1d:
            goto L29
        L1f:
            goto L30
        L21:
            r3 = move-exception
        L22:
            if (r0 == 0) goto L27
            r0.close()     // Catch: java.io.IOException -> L27
        L27:
            throw r3
        L28:
            r1 = r0
        L29:
            if (r1 == 0) goto L33
        L2b:
            r1.close()     // Catch: java.io.IOException -> L33
            goto L33
        L2f:
            r1 = r0
        L30:
            if (r1 == 0) goto L33
            goto L2b
        L33:
            return r0
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.amapauto.utils.FileUtils.readFile(java.io.File):byte[]");
    }
}
