package com.autonavi.amapauto.utils;

import android.os.Build;
import android.os.LocaleList;
import defpackage.aa0;
import defpackage.ee;
import defpackage.jp;
import java.util.Locale;

/* loaded from: classes.dex */
public class LanguageUtils {
    public static String getCurLanguage() {
        Locale locale;
        String o = jp.I().o(40010);
        if (o != null) {
            return o;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            locale = LocaleList.getDefault().get(0);
        } else {
            locale = ee.A().f().getResources().getConfiguration().locale;
        }
        if (locale == null) {
            return "zh";
        }
        String language = locale.getLanguage();
        aa0.a("LanguageUtils", "getCurLanguage ={?}", language);
        return language;
    }

    public static boolean isNoLimit() {
        return jp.I().l(10047);
    }

    public static native void nativeNotifyLangChange(String str);

    public static native void nativeNotifyLangChangeNoLimit(String str);

    public static void notifyLanageChange(String str) {
        boolean l = jp.I().l(10047);
        aa0.a("LanguageUtils", "notifyLanageChange ={?} ,langChangeNoLimit = {?}", str, Boolean.valueOf(l));
        if (l) {
            nativeNotifyLangChangeNoLimit(str);
        } else {
            nativeNotifyLangChange(str);
        }
    }
}
