package com.autonavi.amapauto.widget.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.autonavi.amapauto.widget.jni.LightBarItem;
import defpackage.aa0;
import defpackage.ee;
import defpackage.ia0;
import defpackage.n90;
import defpackage.rh0;
import java.util.ArrayList;
import java.util.List;

/* loaded from: classes.dex */
public class WidgetTmcBarViewAFV extends View {
    public static final int h = ia0.a(rh0.auto_color_252525);
    public static final int i = ia0.a(rh0.auto_color_2e7aff);
    public static final int j = ia0.a(rh0.auto_color_007d5d);
    public static final int k = ia0.a(rh0.auto_color_149441);
    public static final int l = ia0.a(rh0.auto_color_feb31d);
    public static final int m = ia0.a(rh0.auto_color_fe352e);
    public static final int n = ia0.a(rh0.auto_color_8b0c13);
    public List<LightBarItem> a;
    public int c;
    public float d;
    public Paint e;
    public Bitmap f;
    public Canvas g;

    public WidgetTmcBarViewAFV(Context context) {
        super(context);
        this.a = new ArrayList();
    }

    public void a(List<LightBarItem> list, int i2) {
        this.a.clear();
        if (list != null) {
            this.a.addAll(list);
        }
        this.c = i2;
    }

    public final Paint b(int i2) {
        if (this.e == null) {
            Paint paint = new Paint();
            this.e = paint;
            paint.setAntiAlias(true);
            this.e.setStyle(Paint.Style.FILL);
        }
        this.e.setColor(i2);
        return this.e;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = getWidth();
        int height = getHeight();
        List<LightBarItem> list = this.a;
        if (list == null || list.size() == 0 || this.a == null) {
            return;
        }
        float f = width;
        Path path = new Path();
        path.addRoundRect(new RectF(0.0f, 0.0f, f, height), new float[]{f, f, f, f, f, f, f, f}, Path.Direction.CW);
        canvas.clipPath(path);
        Bitmap bitmap = this.f;
        if (bitmap != null && !bitmap.isRecycled()) {
            int i2 = Build.VERSION.SDK_INT;
            if (i2 >= 19) {
                aa0.a("WidgetTmcBarViewAFV", "bufferBitmap allocation:{?}", Integer.valueOf(this.f.getAllocationByteCount()));
            } else {
                aa0.a("WidgetTmcBarViewAFV", "bufferBitmap allocation:unknown sdkint:{?}", Integer.valueOf(i2));
            }
            canvas.drawBitmap(a(this.f, width, height, width, 0, true), 0.0f, 0.0f, (Paint) null);
            return;
        }
        a();
        Bitmap bitmap2 = this.f;
        if (bitmap2 == null || bitmap2.isRecycled()) {
            return;
        }
        int i3 = Build.VERSION.SDK_INT;
        if (i3 >= 19) {
            aa0.a("WidgetTmcBarViewAFV", "bufferBitmap allocation:{?}", Integer.valueOf(this.f.getAllocationByteCount()));
        } else {
            aa0.a("WidgetTmcBarViewAFV", "bufferBitmap allocation:unknown sdkint:{?}", Integer.valueOf(i3));
        }
        canvas.drawBitmap(a(this.f, width, height, width, 0, true), 0.0f, 0.0f, (Paint) null);
    }

    public void setCursorPos(float f) {
        this.d = f;
        a();
    }

    public void setNightMode(boolean z) {
        b();
    }

    public WidgetTmcBarViewAFV(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a = new ArrayList();
    }

    public final void a() {
        List<LightBarItem> list;
        List<LightBarItem> list2;
        char c;
        aa0.a("WidgetTmcBarViewAFV", "drawTMC enter", new Object[0]);
        int width = getWidth();
        int height = getHeight();
        if (width == 0 || height == 0 || (list = this.a) == null || list.size() == 0 || (list2 = this.a) == null) {
            return;
        }
        int size = list2.size();
        float f = height;
        float f2 = (f * 1.0f) / (this.c * 1.0f);
        if (this.f == null) {
            this.f = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            this.g = new Canvas(this.f);
        }
        int i2 = 0;
        for (int i3 = size - 1; i3 >= 0; i3--) {
            LightBarItem lightBarItem = this.a.get(i3);
            float round = Math.round(lightBarItem.length * f2);
            i2 = (int) (i2 + round);
            float f3 = i2;
            float f4 = f3 - round;
            this.g.drawRect(0.0f, f4, width, f3, b(a(lightBarItem.status)));
            aa0.a("WidgetTmcBarViewAFV", " 绘制路况 top :{?} bottom:{?} mCursorPos:{?} status:{?}", Float.valueOf(f4), Integer.valueOf(i2), Float.valueOf(this.d), Integer.valueOf(lightBarItem.status));
        }
        if (i2 < height) {
            c = 3;
            this.g.drawRect(0.0f, i2, width, f, b(a(this.a.get(0).status)));
            aa0.a("WidgetTmcBarViewAFV", " 绘制路况 top :{?} bottom:{?} mCursorPos:{?}", Integer.valueOf(height), Integer.valueOf(i2), Float.valueOf(this.d));
        } else {
            c = 3;
        }
        if (f > this.d) {
            int a = a(10);
            this.g.drawRect(0.0f, this.d, width, f, b(-14342875));
            Object[] objArr = new Object[5];
            objArr[0] = Float.valueOf(this.d);
            objArr[1] = Integer.valueOf(height);
            objArr[2] = 10;
            objArr[c] = Integer.valueOf(a);
            objArr[4] = -14342875;
            aa0.a("WidgetTmcBarViewAFV", " 走过的路置灰 top :{?} bottom:{?}  status:{?}, color:{?},trueColor:{?}", objArr);
        }
    }

    public WidgetTmcBarViewAFV(Context context, AttributeSet attributeSet, int i2) {
        super(context, attributeSet, i2);
        this.a = new ArrayList();
    }

    public void b() {
        invalidate();
    }

    public static Bitmap a(Bitmap bitmap, int i2, int i3, int i4, int i5, boolean z) {
        if (z) {
            return bitmap;
        }
        if (bitmap == null) {
            return null;
        }
        float height = (i3 * 1.0f) / bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale((i2 * 1.0f) / bitmap.getWidth(), height);
        Bitmap createBitmap = Bitmap.createBitmap(i2, i3, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        Paint paint = new Paint(1);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode);
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader(bitmapShader);
        float f = i5;
        RectF rectF = new RectF(f, f, i2 - i5, i3 - i5);
        float f2 = i4;
        canvas.drawRoundRect(rectF, f2, f2, paint);
        if (i5 > 0) {
            Paint paint2 = new Paint(1);
            paint2.setColor(-16777216);
            paint2.setStyle(Paint.Style.STROKE);
            paint2.setStrokeWidth(f);
            canvas.drawRoundRect(rectF, f2, f2, paint2);
        }
        return createBitmap;
    }

    public final int a(int i2) {
        if (i2 == 10) {
            return h;
        }
        if (!n90.f(ee.A().f())) {
            return i;
        }
        if (i2 == 0) {
            return i;
        }
        if (i2 == 1) {
            return k;
        }
        if (i2 == 2) {
            return l;
        }
        if (i2 == 3) {
            return m;
        }
        if (i2 == 4) {
            return n;
        }
        if (i2 != 5) {
            return h;
        }
        return j;
    }
}
