package com.autonavi.amapauto.z;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.Keep;

@Keep
/* loaded from: classes.dex */
public class AutonaviTestPLoad {
    public static final String TAG = "AutonaviTestPLoad";

    public static String getBaseVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            Log.i(TAG, "base version name " + packageInfo.versionName);
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getPatchVersionNameForBuild(Context context) {
        String baseVersionName = getBaseVersionName(context);
        Log.i(TAG, "patch version name " + baseVersionName);
        return baseVersionName;
    }

    public static boolean isP(Context context) {
        boolean z = !getBaseVersionName(context).equals(getPatchVersionNameForBuild(context));
        Log.d(TAG, " is patch " + z);
        return z;
    }
}
