package com.autonavi.auto.search.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.autonavi.amapauto.jni.protocol.data.ALResponeData;
import com.autonavi.amapauto.jni.protocol.data.CitysuggestionData;
import com.autonavi.amapauto.jni.protocol.data.EnteryData;
import com.autonavi.amapauto.jni.protocol.data.HomeOrCopInfoData;
import com.autonavi.amapauto.jni.protocol.data.PoiData;
import com.autonavi.amapauto.jni.protocol.data.SearchData;
import com.autonavi.amapauto.jni.protocol.data.SearchResultData;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import defpackage.aa0;
import defpackage.ee;
import defpackage.ga0;
import defpackage.ja0;
import defpackage.oh0;
import defpackage.oq;
import defpackage.ph0;
import defpackage.t80;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class ThirdPartSearchProvider extends ContentProvider {
    public static final UriMatcher f;
    public List<PoiData> a;
    public List<CitysuggestionData> c;
    public b d = b.STATUS_NONE;
    public ga0.a e = new a();

    /* loaded from: classes.dex */
    public class a implements ga0.a {
        public a() {
        }

        @Override // ga0.a
        public void a(ALResponeData aLResponeData) {
            aa0.a("ThirdPartSearchProvider", "onSearchCallBack,isSuccessed={?}" + aLResponeData.isSuccessed, new Object[0]);
            if (aLResponeData instanceof SearchResultData) {
                SearchResultData searchResultData = (SearchResultData) aLResponeData;
                ThirdPartSearchProvider.this.a = searchResultData.getPois();
                ThirdPartSearchProvider.this.c = searchResultData.getCityList();
            } else if (aLResponeData instanceof HomeOrCopInfoData) {
                ThirdPartSearchProvider.this.a = ((HomeOrCopInfoData) aLResponeData).getPoiDatas();
            }
            if (ThirdPartSearchProvider.this.a != null && ThirdPartSearchProvider.this.a.size() > 0) {
                ThirdPartSearchProvider.this.d = b.STATUS_SEARCH_SUCCESS;
            } else {
                ThirdPartSearchProvider.this.d = b.STATUS_SEARCH_FAIL;
            }
        }
    }

    /* loaded from: classes.dex */
    public enum b {
        STATUS_NONE,
        STATUS_SEARCHING,
        STATUS_SEARCH_SUCCESS,
        STATUS_SEARCH_FAIL
    }

    static {
        UriMatcher uriMatcher = new UriMatcher(-1);
        f = uriMatcher;
        uriMatcher.addURI("com.autonavi.amapauto.provider.search", "search_poi", 1);
        f.addURI("com.autonavi.amapauto.provider.search", "home_company_poi", 2);
        f.addURI("com.autonavi.amapauto.provider.search", "get_fav_poi", 4);
        f.addURI("com.autonavi.amapauto.provider.search", "param", 5);
        Uri.parse("content://com.autonavi.amapauto.provider.search/param");
    }

    @Override // android.content.ContentProvider
    public int delete(Uri uri, String str, String[] strArr) {
        return 0;
    }

    @Override // android.content.ContentProvider
    public String getType(Uri uri) {
        return null;
    }

    @Override // android.content.ContentProvider
    public Uri insert(Uri uri, ContentValues contentValues) {
        if (f.match(uri) != 5 || contentValues == null) {
            return null;
        }
        aa0.a("Joker", "NetworkParam getIsn insert", new Object[0]);
        SharedPreferences.Editor edit = ee.A().b(getContext()).getSharedPreferences("SharedPreferences", 0).edit();
        edit.putString("isn1", contentValues.getAsString("isn1"));
        edit.putString("isn", contentValues.getAsString("isn"));
        if (Build.VERSION.SDK_INT >= 9) {
            edit.apply();
        } else {
            edit.commit();
        }
        return null;
    }

    @Override // android.content.ContentProvider
    public boolean onCreate() {
        aa0.a("ThirdPartSearchProvider", "onCreate pid " + Process.myPid(), new Object[0]);
        return false;
    }

    @Override // android.content.ContentProvider
    public Cursor query(Uri uri, String[] strArr, String str, String[] strArr2, String str2) {
        aa0.a("ThirdPartSearchProvider", "query", new Object[0]);
        if (strArr != null && strArr.length != 0 && uri != null) {
            if (f.match(uri) == 5) {
                SharedPreferences sharedPreferences = ee.A().b(getContext()).getSharedPreferences("SharedPreferences", 0);
                String string = sharedPreferences.getString("isn1", "");
                String string2 = sharedPreferences.getString("isn", "");
                MatrixCursor matrixCursor = new MatrixCursor(oh0.a);
                matrixCursor.addRow(new Object[]{string, string2});
                return matrixCursor;
            }
            Map<String, String> a2 = a(getContext());
            if ((a2 != null && a2.size() > 0 && Build.VERSION.SDK_INT >= 23) || this.d == b.STATUS_SEARCHING) {
                return null;
            }
            this.a = null;
            int match = f.match(uri);
            aa0.a("ThirdPartSearchProvider", "start init uri={?}", uri.toString());
            return a(match, strArr, strArr2, str2);
        }
        aa0.a("ThirdPartSearchProvider", "projection == null || projection.length == 0 || uri == null", new Object[0]);
        return null;
    }

    @Override // android.content.ContentProvider
    public int update(Uri uri, ContentValues contentValues, String str, String[] strArr) {
        return 0;
    }

    public final Cursor a(int i, String[] strArr, String[] strArr2, String str) {
        if (!t80.d().b()) {
            t80.d().a(ee.A().e());
        }
        long elapsedRealtime = SystemClock.elapsedRealtime();
        while (!t80.d().b()) {
            try {
                Thread.sleep(100L);
            } catch (InterruptedException unused) {
            }
            if (SystemClock.elapsedRealtime() - elapsedRealtime >= 5000) {
                return null;
            }
        }
        if (1 == i) {
            if (!a(strArr2, str)) {
                return null;
            }
            a();
            SearchData searchData = new SearchData();
            searchData.keyword = ph0.c(strArr2);
            searchData.centerLat = ph0.a(strArr2, 1);
            searchData.centerLon = ph0.a(strArr2, 2);
            searchData.maxCount = ph0.d(strArr2);
            searchData.searchType = ph0.h(strArr2);
            searchData.requestId = 5102;
            searchData.needClassify = ph0.f(strArr2);
            searchData.needSort = ph0.g(strArr2);
            searchData.needChildPoi = ph0.e(strArr2);
            searchData.classify = ph0.b(strArr2);
            searchData.sort = ph0.i(strArr2);
            searchData.city = ph0.a(strArr2);
            searchData.requestType = 1;
            if (String.valueOf(1).equalsIgnoreCase(str)) {
                searchData.sortOrder = 1;
            } else {
                searchData.sortOrder = 0;
            }
            ga0.a().a(searchData, this.e);
        } else if (2 == i) {
            a();
            ga0.a().a(this.e, 3);
        } else if (4 == i) {
            a();
            ga0.a().a(this.e, 0);
        }
        long elapsedRealtime2 = SystemClock.elapsedRealtime();
        while (this.d == b.STATUS_SEARCHING) {
            try {
                Thread.sleep(100L);
            } catch (InterruptedException e) {
                aa0.a("ThirdPartSearchProvider", "Exception={?}", e, new Object[0]);
            }
            if (this.d != b.STATUS_SEARCHING) {
                break;
            }
            if (SystemClock.elapsedRealtime() - elapsedRealtime2 >= 30000) {
                this.d = b.STATUS_NONE;
                return null;
            }
        }
        if (this.a == null) {
            return null;
        }
        return a(strArr);
    }

    public final Cursor a(String[] strArr) {
        MatrixCursor matrixCursor = new MatrixCursor(strArr);
        List<PoiData> list = this.a;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < this.a.size(); i++) {
                PoiData poiData = this.a.get(i);
                int length = strArr.length;
                Object[] objArr = new Object[length];
                for (int i2 = 0; i2 < length; i2++) {
                    ph0.a aVar = ph0.a.DEFAULT;
                    int i3 = poiData.homecopType;
                    if (i3 == 1) {
                        aVar = ph0.a.HOME;
                    } else if (i3 == 2) {
                        aVar = ph0.a.COMPANY;
                    }
                    objArr[i2] = a(poiData, strArr[i2], aVar, (String) null);
                }
                matrixCursor.addRow(objArr);
            }
        }
        List<CitysuggestionData> list2 = this.c;
        if (list2 != null && list2.size() > 0) {
            int size = this.c.size();
            for (int i4 = 0; i4 < size; i4++) {
                CitysuggestionData citysuggestionData = this.c.get(i4);
                int length2 = strArr.length;
                Object[] objArr2 = new Object[length2];
                for (int i5 = 11; i5 < length2; i5++) {
                    objArr2[i5] = a(citysuggestionData, strArr[i5], ph0.a.DEFAULT);
                }
                matrixCursor.addRow(objArr2);
            }
        }
        return matrixCursor;
    }

    public final Object a(PoiData poiData, String str, ph0.a aVar, String str2) {
        JSONObject a2;
        if (poiData == null) {
            return null;
        }
        if (StandardProtocolKey.POIID.equals(str)) {
            return poiData.poiid;
        }
        if (StandardProtocolKey.NAME.equals(str)) {
            return !TextUtils.isEmpty(str2) ? str2 : poiData.name;
        }
        if (StandardProtocolKey.POI_ADDRESS.equals(str)) {
            return poiData.address;
        }
        if ("latitude".equals(str)) {
            return Double.valueOf(poiData.latitude);
        }
        if ("longitude".equals(str)) {
            return Double.valueOf(poiData.longitude);
        }
        if (StandardProtocolKey.POI_DISTANCE.equals(str)) {
            return Integer.valueOf(poiData.distance);
        }
        if (StandardProtocolKey.TEL.equals(str)) {
            return poiData.tel;
        }
        if (StandardProtocolKey.POIDEEPINFO_CATEGORY.equals(str)) {
            return Integer.valueOf(poiData.poitype);
        }
        if (StandardProtocolKey.POITYPE.equals(str)) {
            return Integer.valueOf(aVar.ordinal());
        }
        double d = 0.0d;
        if ("navilongitude".equals(str)) {
            List<EnteryData> enteryList = poiData.getEnteryList();
            if (enteryList != null && enteryList.size() > 0) {
                d = enteryList.get(0).longitude;
            }
            return Double.valueOf(d);
        }
        if ("navilatitude".equals(str)) {
            List<EnteryData> enteryList2 = poiData.getEnteryList();
            if (enteryList2 != null && enteryList2.size() > 0) {
                d = enteryList2.get(0).latitude;
            }
            return Double.valueOf(d);
        }
        if (!str.equals(StandardProtocolKey.POIDEEPINFO) || poiData.getPoideepinfo() == null || (a2 = ja0.a(poiData.getPoideepinfo())) == null) {
            return null;
        }
        return a2.toString();
    }

    public final Object a(CitysuggestionData citysuggestionData, String str, ph0.a aVar) {
        if (citysuggestionData == null) {
            return null;
        }
        if (StandardProtocolKey.CITY_SUGGESTION_NAME.equals(str)) {
            return citysuggestionData.cityname;
        }
        if (StandardProtocolKey.CITY_SUGGESTION_NUM.equals(str)) {
            return Integer.valueOf(citysuggestionData.citynum);
        }
        return null;
    }

    public final boolean a(String[] strArr, String str) {
        if (strArr != null && strArr.length > 0) {
            if (ph0.c(strArr) != null) {
                return true;
            }
            aa0.a("ThirdPartSearchProvider", "请求keywords不能为空！", new Object[0]);
            return false;
        }
        aa0.a("ThirdPartSearchProvider", "请求selectionArgs不能为空！", new Object[0]);
        return false;
    }

    public final void a() {
        this.d = b.STATUS_SEARCHING;
    }

    public final Map<String, String> a(Context context) {
        if (!oq.i().a("isNeedFrontMemory", true) || Build.VERSION.SDK_INT < 23) {
            return null;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("存储", "android.permission.WRITE_EXTERNAL_STORAGE");
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String str = (String) entry.getKey();
            String str2 = (String) entry.getValue();
            if (context.checkSelfPermission(str2) == -1) {
                linkedHashMap2.put(str, str2);
            }
        }
        return linkedHashMap2;
    }
}
