package com.autonavi.autofloat.simulate;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.ViewDebug;
import android.widget.TextView;
import java.util.Calendar;
import java.util.TimeZone;

/* loaded from: classes.dex */
public class TimeTextView extends TextView {
    public Calendar a;
    public boolean c;
    public String d;

    @ViewDebug.ExportedProperty
    public final CharSequence e;
    public final Runnable f;
    public final BroadcastReceiver g;

    /* loaded from: classes.dex */
    public class a implements Runnable {
        public a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            TimeTextView.this.a();
            long uptimeMillis = SystemClock.uptimeMillis();
            long j = uptimeMillis + (1000 - (uptimeMillis % 1000));
            Handler handler = TimeTextView.this.getHandler();
            if (handler != null) {
                handler.postAtTime(TimeTextView.this.f, j);
            }
        }
    }

    /* loaded from: classes.dex */
    public class b extends BroadcastReceiver {
        public b() {
        }

        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (TimeTextView.this.d == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                TimeTextView.this.a(intent.getStringExtra("time-zone"));
            }
            TimeTextView.this.a();
        }
    }

    public TimeTextView(Context context) {
        this(context, null);
    }

    @Override // android.widget.TextView, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.c) {
            return;
        }
        this.c = true;
        b();
        a(this.d);
        this.f.run();
    }

    @Override // android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.c) {
            c();
            Handler handler = getHandler();
            if (handler != null) {
                handler.removeCallbacks(this.f);
            }
            this.c = false;
        }
    }

    public TimeTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public final void b() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.TIME_TICK");
        intentFilter.addAction("android.intent.action.TIME_SET");
        intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
        getContext().registerReceiver(this.g, intentFilter, null, getHandler());
    }

    public final void c() {
        getContext().unregisterReceiver(this.g);
    }

    public TimeTextView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.e = "yyyy-MM-dd HH:mm:ss";
        this.f = new a();
        this.g = new b();
    }

    public final void a() {
        this.a.setTimeInMillis(System.currentTimeMillis());
        setText(DateFormat.format(this.e, this.a));
    }

    public final void a(String str) {
        if (str != null) {
            this.a = Calendar.getInstance(TimeZone.getTimeZone(str));
        } else {
            this.a = Calendar.getInstance();
        }
    }
}
