package com.autonavi.common.tool;

import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import defpackage.m90;
import defpackage.sj0;
import defpackage.vi0;
import defpackage.vj0;
import defpackage.yi0;
import defpackage.zi0;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Map;

/* loaded from: classes.dex */
public class dumpcrash {
    public static final int GETMAPS_FLAG_1 = 1;
    public static final int GETMAPS_FLAG_10 = 16;
    public static final int GETMAPS_FLAG_2 = 2;
    public static final int GETMAPS_FLAG_4 = 4;
    public static final int GETMAPS_FLAG_8 = 8;
    public static final String LIB_DUMPCRASH = "dumpcrash";
    public static final String LIB_DUMPCRASH_FULL_NAME = "libdumpcrash.so";
    public static boolean hasLoadLibrary;

    /* loaded from: classes.dex */
    public class a implements Comparator<b> {
        @Override // java.util.Comparator
        /* renamed from: a, reason: merged with bridge method [inline-methods] */
        public int compare(b bVar, b bVar2) {
            long j = bVar.b;
            long j2 = bVar2.b;
            if (j < j2) {
                return 1;
            }
            return j > j2 ? -1 : 0;
        }
    }

    /* loaded from: classes.dex */
    public class b {
        public File a;
        public long b;

        public b(File file, long j) {
            this.a = file;
            this.b = j;
        }
    }

    static {
        loadLibrary();
        hasLoadLibrary = false;
    }

    public static String collectMoreInfo(String str, Thread thread, StackTraceElement[] stackTraceElementArr, boolean z) {
        try {
            StringBuffer stringBuffer = new StringBuffer(str);
            if (z) {
                String currentJavaStackTrace = getCurrentJavaStackTrace(thread, stackTraceElementArr);
                if (!TextUtils.isEmpty(currentJavaStackTrace)) {
                    stringBuffer.append(currentJavaStackTrace);
                }
            }
            if (str.contains("(SIGABRT)")) {
                stringBuffer.append(getOtherJavaStackTrace(thread));
                stringBuffer.append(vj0.f());
                if (str.contains("(SI_USER)")) {
                    stringBuffer.append(readAnrTraces());
                }
            } else if (str.contains("(SIGSEGV)") || str.contains("(SIGBUS)") || str.contains("(SIGILL)")) {
                stringBuffer.append(vj0.f());
                zi0.f().e();
            }
            return stringBuffer.toString();
        } catch (Throwable unused) {
            return str;
        }
    }

    public static native int[] getApkInfo(String str, String str2);

    public static String getCurrentJavaStackTrace(Thread thread, StackTraceElement[] stackTraceElementArr) {
        return "\nJavaStack:\n" + getJavaStackTrace(thread, thread, stackTraceElementArr);
    }

    public static String getJavaStackTrace(Thread thread, Thread thread2, StackTraceElement[] stackTraceElementArr) {
        if (stackTraceElementArr == null || stackTraceElementArr.length == 0) {
            if (thread != null) {
                sj0.a("dc: TN: " + thread.toString());
            }
            if (stackTraceElementArr == null) {
                sj0.a("dc: element null");
                return "";
            }
            sj0.a("dc: element length 0");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (thread == thread2) {
            int i2 = 0;
            while (true) {
                if (i2 >= stackTraceElementArr.length) {
                    break;
                }
                int i3 = i2 + 1;
                if (stackTraceElementArr[i2].getMethodName().equals("recordInLocal")) {
                    i2 = i3;
                    break;
                }
                i2 = i3;
            }
            if (i2 < stackTraceElementArr.length) {
                i = i2;
            }
        } else {
            sb.append(thread2.toString());
            sb.append(" ");
            sb.append(thread2.getState());
            sb.append("\n");
        }
        while (i < stackTraceElementArr.length) {
            sb.append("  ");
            sb.append(stackTraceElementArr[i].toString());
            sb.append("\n");
            i++;
        }
        return sb.toString();
    }

    public static native String getMaps(int i);

    public static native void getNativeAnrThreadInfo(String str, String str2, String str3);

    public static native String getNativeThreadBacktrace(int i);

    public static String getOtherJavaStackTrace(Thread thread) {
        Map<Thread, StackTraceElement[]> c = vj0.c();
        if (c == null || c.size() < 2) {
            return "";
        }
        StringBuilder sb = new StringBuilder("\nOtherJavaStack:\n");
        for (Thread thread2 : c.keySet()) {
            if (!thread2.equals(thread) && thread2 == Looper.getMainLooper().getThread()) {
                sb.append(getJavaStackTrace(thread, thread2, c.get(thread2)));
            }
        }
        return sb.toString();
    }

    public static native String getThreadInfos();

    public static long getThreadNativePeerValue(Thread thread) {
        if (thread == null) {
            return -1L;
        }
        try {
            Field declaredField = Thread.class.getDeclaredField("nativePeer");
            declaredField.setAccessible(true);
            return declaredField.getLong(thread);
        } catch (Throwable unused) {
            return -1L;
        }
    }

    public static native long getUsableSpace(String str);

    public static native void install(int i, String str, String str2);

    public static void install(String str) {
        install(Build.VERSION.SDK_INT, vi0.h().getApplicationInfo().nativeLibraryDir + File.separator, str);
        setAppFileDir();
    }

    public static synchronized void loadLibrary() {
        synchronized (dumpcrash.class) {
            sj0.a(1, "dumpcrash loadLibrary");
            if (hasLoadLibrary) {
                return;
            }
            m90.d(LIB_DUMPCRASH);
            hasLoadLibrary = true;
            sj0.a(1, "dumpcrash loadLibrary hasLoadLibrary = " + hasLoadLibrary);
        }
    }

    public static synchronized void logSwitch(int i) {
        synchronized (dumpcrash.class) {
            setLogSwitch(i);
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:46:0x0079, code lost:            if (r10 == false) goto L72;     */
    /* JADX WARN: Code restructure failed: missing block: B:48:0x007b, code lost:            r5.append(r11);        r5.append("\n");     */
    /* JADX WARN: Removed duplicated region for block: B:54:0x00c9  */
    /* JADX WARN: Removed duplicated region for block: B:57:0x00eb A[RETURN] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static java.lang.String readAnrTraces() {
        /*
            Method dump skipped, instructions count: 238
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.common.tool.dumpcrash.readAnrTraces():java.lang.String");
    }

    public static void recordInLocal(String str, boolean z) {
        yi0.a(str, null, z);
    }

    public static void setAppFileDir() {
        setFileDir(vi0.h().getFilesDir() + File.separator);
    }

    public static native void setAppVersion(String str);

    public static native void setCrashNotifyDir(String str);

    public static native void setCrashNotifyFilePath(String str);

    public static native void setFileDir(String str);

    public static native void setLogSwitch(int i);

    public static native void setRepotOtherThread(boolean z);

    public static native void testNativeCrash();

    public static native void uninstall();

    public static void recordInLocal(String str, long j, boolean z) {
        if (z) {
            yi0.a(str, null, z);
            return;
        }
        Map<Thread, StackTraceElement[]> c = vj0.c();
        if (c != null && c.size() != 0) {
            for (Map.Entry<Thread, StackTraceElement[]> entry : c.entrySet()) {
                if (getThreadNativePeerValue(entry.getKey()) == j) {
                    yi0.a(str, entry.getKey(), z);
                    return;
                }
            }
            yi0.a(str, null, z);
            return;
        }
        yi0.a(str, null, z);
    }
}
