package com.autonavi.eaglet.multiscreen;

import android.util.Log;
import android.view.Surface;
import androidx.annotation.Keep;

@Keep
/* loaded from: classes.dex */
public class MultiScreenImpl implements IMultiScreenHandler {
    public static final String TAG = "MultiScreenImpl";

    public static native void onTouchEventNative(int i, int[] iArr, float[] fArr, float[] fArr2, int i2);

    public static native int surfaceChangedNative(int i, Surface surface, EagletViewInfo eagletViewInfo);

    public static native int surfaceCreatedNative(int i, Surface surface, EagletViewInfo eagletViewInfo);

    public static native int surfaceDestroyedNative(int i);

    public static native void surfaceStatusNative(int i, int i2);

    @Override // com.autonavi.eaglet.multiscreen.IMultiScreenHandler
    public int handleSurfaceChanged(int i, Surface surface, EagletViewInfo eagletViewInfo) {
        Log.d(TAG, "handleSurfaceChanged");
        return surfaceChangedNative(i, surface, eagletViewInfo);
    }

    @Override // com.autonavi.eaglet.multiscreen.IMultiScreenHandler
    public int handleSurfaceCreated(int i, Surface surface, EagletViewInfo eagletViewInfo) {
        Log.d(TAG, "handleSurfaceCreated");
        return surfaceCreatedNative(i, surface, eagletViewInfo);
    }

    @Override // com.autonavi.eaglet.multiscreen.IMultiScreenHandler
    public int handleSurfaceDestroy(int i) {
        return surfaceDestroyedNative(i);
    }

    @Override // com.autonavi.eaglet.multiscreen.IMultiScreenHandler
    public void handleSurfaceStatusChanged(int i, int i2) {
        surfaceStatusNative(i, i2);
    }

    @Override // com.autonavi.eaglet.multiscreen.IMultiScreenHandler
    public void handleTouchEvent(int i, int[] iArr, float[] fArr, float[] fArr2, int i2) {
        onTouchEventNative(i, iArr, fArr, fArr2, i2);
    }
}
