package com.autonavi.eaglet.surfacemng;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.ViewTreeObserver;
import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import defpackage.gn0;
import defpackage.tm0;
import defpackage.um0;
import java.lang.ref.WeakReference;

@Keep
/* loaded from: classes.dex */
public class ActivityStateManager implements um0, Application.ActivityLifecycleCallbacks, ViewTreeObserver.OnWindowFocusChangeListener {
    public static final String TAG = "SurfaceViewManagerAty";
    public boolean isWidgetJumpIntent;
    public WeakReference<Activity> mActivity;
    public boolean mIsActivityCreating;
    public boolean mIsActivityStarting;
    public boolean mIsFocused = true;
    public boolean mIsResumed;

    public ActivityStateManager() {
        if (Config.isSupport()) {
            Adapter.getApplication().registerActivityLifecycleCallbacks(this);
        }
    }

    @Override // defpackage.um0
    public /* synthetic */ boolean a(Activity activity) {
        return tm0.a(this, activity);
    }

    public boolean checkWidgetJump(Intent intent) {
        debugLog("checkWidgetJump=" + intent);
        Uri data = intent.getData();
        if (data == null) {
            return false;
        }
        String lowerCase = data.toString().toLowerCase();
        if (!lowerCase.contains("search") && !lowerCase.contains("set") && !lowerCase.contains("home") && !lowerCase.contains("company")) {
            return false;
        }
        debugLog("checkWidgetJump=true");
        return true;
    }

    public void debugLog(String str) {
        Config.debugLog(TAG, str);
    }

    @Override // defpackage.sm0
    public Activity getActivity() {
        WeakReference<Activity> weakReference = this.mActivity;
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    public gn0 getPluginManager() {
        return Adapter.getManager().a();
    }

    public boolean hasFocus() {
        return this.mIsFocused;
    }

    @Override // defpackage.sm0
    public boolean isActivityCreating() {
        return this.mIsActivityCreating;
    }

    public boolean isActivityStarting() {
        return this.mIsActivityStarting;
    }

    @Override // defpackage.sm0
    public boolean isInMultiWindowMode() {
        WeakReference<Activity> weakReference;
        return Build.VERSION.SDK_INT >= 24 && (weakReference = this.mActivity) != null && weakReference.get().isInMultiWindowMode();
    }

    @Override // defpackage.sm0
    public boolean isResumed() {
        return this.mIsResumed;
    }

    @Override // defpackage.sm0
    public boolean isWidgetJumpIntent() {
        return this.isWidgetJumpIntent;
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityCreated(Activity activity, Bundle bundle) {
        if (this.mActivity == null && a(activity)) {
            this.mIsActivityCreating = true;
            this.mActivity = new WeakReference<>(activity);
            getPluginManager().onActivityCreated();
        }
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityDestroyed(Activity activity) {
        if (getActivity() == activity) {
            debugLog("onActivityDestroyed: ");
            WeakReference<Activity> weakReference = this.mActivity;
            if (weakReference != null) {
                weakReference.get().getWindow().getDecorView().getViewTreeObserver().removeOnWindowFocusChangeListener(this);
                this.mActivity = null;
            }
            getPluginManager().onActivityDestroyed();
            Adapter.getManager().reset();
        }
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityPaused(Activity activity) {
        if (getActivity() == activity) {
            debugLog("onActivityPaused: ");
            this.mIsResumed = false;
            getPluginManager().onActivityPaused();
        }
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityResumed(Activity activity) {
        if (getActivity() == activity) {
            this.mIsResumed = true;
            getPluginManager().onActivityResumed();
        }
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityStarted(Activity activity) {
        if (getActivity() == activity) {
            debugLog("onActivityStarted");
            this.mIsActivityStarting = true;
            this.isWidgetJumpIntent = checkWidgetJump(activity.getIntent());
            getPluginManager().onActivityStarted();
        }
    }

    @Override // android.app.Application.ActivityLifecycleCallbacks
    public void onActivityStopped(Activity activity) {
        if (getActivity() == activity) {
            debugLog("onActivityStopped: ");
            this.mIsActivityCreating = false;
            this.mIsActivityStarting = false;
            this.isWidgetJumpIntent = false;
            getPluginManager().onActivityStopped();
        }
    }

    @Override // defpackage.um0
    public void onViewInflated() {
        getActivity().getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(this);
        getPluginManager().onViewInflated();
    }

    @Override // android.view.ViewTreeObserver.OnWindowFocusChangeListener
    public void onWindowFocusChanged(boolean z) {
        debugLog("onWindowFocusChanged: " + z);
        this.mIsFocused = z;
        getPluginManager().onWindowFocusChanged(z, Adapter.getManager().e().getMapRenderStatus());
    }
}
