package com.autonavi.eaglet.surfacemng;

import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import com.autonavi.eaglet.surfacemng.cfg.ConfigHmi;
import defpackage.gn0;
import defpackage.hn0;
import defpackage.vm0;
import defpackage.xm0;

@Keep
/* loaded from: classes.dex */
public class AutoStateManager implements xm0 {
    public static final String TAG = "SurfaceViewManagerState";
    public boolean mGFrameFirstDrew;
    public boolean mIndexFragmentForeground;
    public boolean mIsGuiding;
    public boolean mIsGuidingLastFore;
    public boolean mIsInitFinished;
    public boolean mIsMainPage;
    public Boolean mIsModeDay;
    public Boolean mIsWarnChecked;
    public boolean mIsWarnPage;
    public vm0.a mapRenderStatus = vm0.a.Destroyed;

    private void debugLog(String str) {
        Config.debugLog(TAG, str);
    }

    private void onAutoModeDay() {
        Boolean bool = this.mIsModeDay;
        if (bool == null || !bool.booleanValue()) {
            this.mIsModeDay = true;
            getPluginManager().AUTO_MODE_DAY();
        }
    }

    private void onAutoModeNight() {
        Boolean bool = this.mIsModeDay;
        if (bool == null || bool.booleanValue()) {
            this.mIsModeDay = false;
            getPluginManager().AUTO_MODE_NIGHT();
        }
    }

    private void onBackGround() {
        this.mIsGuidingLastFore = this.mIsGuiding;
        debugLog("onStateChange: BACKGROUND isGuiding=" + this.mIsGuiding);
    }

    private void onChildPage() {
        debugLog("CHILD_PAGE");
        if (this.mIsMainPage) {
            this.mIsMainPage = false;
            getPluginManager().CHILD_PAGE();
        }
    }

    private void onEnterWarn() {
        debugLog("onStateChange: ENTER_WARN");
        this.mIsWarnPage = true;
        this.mIsWarnChecked = false;
        getPluginManager().ENTER_WARN();
    }

    private void onForeGround() {
        debugLog("onStateChange: FOREGROUND");
        this.mIsWarnPage = false;
        this.mIsWarnChecked = true;
        boolean z = !this.mIndexFragmentForeground;
        this.mIndexFragmentForeground = true;
        getPluginManager().FOREGROUND(z);
    }

    private void onGframeFirstDrew() {
        debugLog("onStateChange: GFRAME_FIRST_DRAW");
        this.mGFrameFirstDrew = true;
        getPluginManager().GFRAME_FIRST_DRAW();
    }

    private void onGuidStart(int i) {
        debugLog("onStateChange: GuideStart=" + i);
        this.mIsGuiding = true;
        this.mIsGuidingLastFore = true;
        getPluginManager().GUIDING_START(i);
    }

    private void onGuidStop(int i) {
        debugLog("onStateChange: GuideStop=" + i);
        this.mIsGuiding = false;
        getPluginManager().GUIDING_STOP(i);
    }

    private void onMainPage() {
        debugLog("MAIN_PAGE ");
        if (this.mIsMainPage) {
            return;
        }
        this.mIsMainPage = true;
        getPluginManager().MAIN_PAGE();
    }

    private void onMapRenderSurfaceCreated() {
        debugLog("onStateChange SURFACE_CREATED, status=" + this.mapRenderStatus + ", suf=" + manager().d().e().e());
        this.mapRenderStatus = vm0.a.Created;
        getPluginManager().INFO_MAPRENDER_STATE(this.mapRenderStatus);
    }

    private void onMapSwapBuffered() {
        debugLog("onStateChange MAP_FOREGROUNDED, status=" + this.mapRenderStatus);
        if (vm0.a.Destroyed != this.mapRenderStatus) {
            this.mapRenderStatus = vm0.a.Swapped;
            getPluginManager().INFO_MAPRENDER_STATE(this.mapRenderStatus);
        }
    }

    private void onStartFinish() {
        debugLog("onStateChange: START_FINISH");
        if (this.mIsInitFinished) {
            return;
        }
        this.mIsInitFinished = true;
        getPluginManager().START_FINISH();
    }

    @Override // defpackage.vm0
    public vm0.a getMapRenderStatus() {
        return this.mapRenderStatus;
    }

    public gn0 getPluginManager() {
        return manager().a();
    }

    @Override // defpackage.vm0
    public boolean isGFrameFirstDrew() {
        return this.mGFrameFirstDrew;
    }

    @Override // defpackage.vm0
    public boolean isGuiding() {
        return this.mIsGuiding;
    }

    @Override // defpackage.vm0
    public boolean isGuidingLastFore() {
        return this.mIsGuidingLastFore;
    }

    @Override // defpackage.vm0
    public boolean isIndexFragmentForeground() {
        return this.mIndexFragmentForeground;
    }

    @Override // defpackage.vm0
    public boolean isInitFinished() {
        return this.mIsInitFinished;
    }

    @Override // defpackage.vm0
    public boolean isMainPage() {
        return this.mIsMainPage;
    }

    @Override // defpackage.vm0
    public boolean isMapBufferSwapped() {
        return vm0.a.Swapped == this.mapRenderStatus;
    }

    @Override // defpackage.vm0
    public boolean isWarnChecked() {
        if (this.mIsWarnChecked == null) {
            this.mIsWarnChecked = Boolean.valueOf(ConfigHmi.isWarnChecked());
        }
        return this.mIsWarnChecked.booleanValue();
    }

    public boolean isWarnPage() {
        return this.mIsWarnPage;
    }

    public hn0 manager() {
        return Adapter.getManager();
    }

    @Override // defpackage.xm0
    public void onStateChange(int i) {
        if (i != 1) {
            if (i != 43) {
                if (i == 60) {
                    onEnterWarn();
                    return;
                }
                if (i == 116) {
                    getPluginManager().FIRST_DRAW();
                    return;
                }
                if (i == 200) {
                    getPluginManager().EXSCREEN_FIRST_DRAW();
                    return;
                }
                if (i == 311) {
                    onGframeFirstDrew();
                    return;
                }
                if (i == 319) {
                    onMapSwapBuffered();
                    return;
                }
                if (i == 2001) {
                    onMapRenderSurfaceCreated();
                    return;
                }
                if (i == 3) {
                    onForeGround();
                    return;
                }
                if (i == 4) {
                    onBackGround();
                    return;
                }
                if (i == 37) {
                    onAutoModeDay();
                    return;
                }
                if (i == 38) {
                    onAutoModeNight();
                    return;
                }
                if (i == 46) {
                    onMainPage();
                    return;
                }
                if (i == 47) {
                    onChildPage();
                    return;
                }
                if (i != 401) {
                    if (i != 402) {
                        switch (i) {
                            case 8:
                            case 10:
                                break;
                            case 9:
                            case 11:
                            case 12:
                                break;
                            default:
                                return;
                        }
                    }
                    onGuidStop(i);
                    return;
                }
            }
            onGuidStart(i);
            return;
        }
        onStartFinish();
    }

    @Override // defpackage.xm0
    public void reset() {
        this.mIsMainPage = false;
        this.mIndexFragmentForeground = false;
        this.mGFrameFirstDrew = false;
        this.mIsGuiding = false;
        this.mIsGuidingLastFore = false;
        this.mapRenderStatus = vm0.a.Destroyed;
    }

    @Override // defpackage.vm0
    public void setMapRenderStatus(vm0.a aVar) {
        this.mapRenderStatus = aVar;
    }
}
