package com.autonavi.eaglet.surfacemng;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import defpackage.en0;
import defpackage.fn0;
import defpackage.gm0;
import defpackage.gn0;
import defpackage.hm0;
import defpackage.im0;
import defpackage.jm0;
import defpackage.km0;
import defpackage.lm0;
import defpackage.mm0;
import defpackage.nm0;
import defpackage.om0;
import defpackage.pm0;
import defpackage.sm0;
import defpackage.vm0;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Keep
/* loaded from: classes.dex */
public class PluginManager implements gn0 {
    public static final String TAG = "SurfaceViewManagerPlg";
    public final List<en0> mPluginsDeclared = new ArrayList();
    public final List<en0> mPluginsAttached = new CopyOnWriteArrayList();

    public PluginManager() {
        declarePlugin(mm0.class);
        if (Build.VERSION.SDK_INT >= 21) {
            declarePlugin(pm0.class);
        }
        declarePlugin(om0.class);
        declarePlugin(gm0.class);
        declarePlugin(jm0.class);
        declarePlugin(lm0.class);
        declarePlugin(nm0.class);
        declarePlugin(im0.class);
        declarePlugin(km0.class);
        if (Build.VERSION.SDK_INT >= 24) {
            declarePlugin(hm0.class);
        }
    }

    private void debugLog(String str) {
        Config.debugLog(TAG, str);
    }

    private <T> void declarePlugin(Class<T> cls) {
        try {
            this.mPluginsDeclared.add((en0) cls.newInstance());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private vm0 getINavigationState() {
        return Adapter.getManager().e();
    }

    private void tryAttachPlugin(sm0.a aVar) {
        for (en0 en0Var : this.mPluginsDeclared) {
            if (!this.mPluginsAttached.contains(en0Var)) {
                en0Var.tryAttachPlugin(aVar);
            }
        }
    }

    @Override // defpackage.gn0
    public void AUTO_MODE_DAY() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().d(true);
        }
    }

    @Override // defpackage.gn0
    public void AUTO_MODE_NIGHT() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().d(false);
        }
    }

    @Override // defpackage.gn0
    public void CHILD_PAGE() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().a(true);
        }
    }

    @Override // defpackage.gn0
    public void ENTER_WARN() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().l();
        }
    }

    @Override // defpackage.gn0
    public void EXSCREEN_FIRST_DRAW() {
        debugLog("EXSCREEN_FIRST_DRAW");
    }

    @Override // defpackage.gn0
    public void FIRST_DRAW() {
        debugLog("FIRST_DRAW");
    }

    @Override // defpackage.gn0
    public void FOREGROUND(boolean z) {
        if (z) {
            tryAttachPlugin(sm0.a.OnIndexForeground);
        }
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().c(z);
        }
    }

    @Override // defpackage.gn0
    public void GFRAME_FIRST_DRAW() {
        tryAttachPlugin(sm0.a.OnGFrameFirstDraw);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().h();
        }
    }

    @Override // defpackage.gn0
    public void GUIDING_START(int i) {
        debugLog("GUIDING_START");
    }

    @Override // defpackage.gn0
    public void GUIDING_STOP(int i) {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().b(false);
        }
    }

    @Override // defpackage.gn0
    public void INFO_MAPRENDER_STATE(vm0.a aVar) {
        if (vm0.a.Created == aVar) {
            Iterator<en0> it = this.mPluginsAttached.iterator();
            while (it.hasNext()) {
                it.next().e();
            }
        } else if (vm0.a.Swapped == aVar) {
            Iterator<en0> it2 = this.mPluginsAttached.iterator();
            while (it2.hasNext()) {
                it2.next().k();
            }
        }
    }

    @Override // defpackage.gn0
    public void MAIN_PAGE() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().a(false);
        }
    }

    @Override // defpackage.gn0
    public void START_FINISH() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().f();
        }
    }

    @Override // defpackage.gn0
    public /* synthetic */ <T> T a(Class<T> cls) {
        return (T) fn0.a(this, cls);
    }

    @Override // defpackage.gn0
    public void attachPlugin(en0 en0Var) {
        if (this.mPluginsAttached.contains(en0Var)) {
            return;
        }
        this.mPluginsAttached.add(en0Var);
        debugLog("attach " + en0Var.g());
    }

    @Override // defpackage.gn0
    public void detachPlugin(en0 en0Var) {
        if (this.mPluginsAttached.contains(en0Var)) {
            this.mPluginsAttached.remove(en0Var);
            debugLog("detach " + en0Var.g());
        }
    }

    @Override // defpackage.gn0
    public List<en0> getPluginsAttached() {
        return this.mPluginsAttached;
    }

    @Override // defpackage.rm0
    public void onActivityCreated() {
        tryAttachPlugin(sm0.a.OnActivityCreated);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityCreated();
        }
    }

    @Override // defpackage.rm0
    public void onActivityDestroyed() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityDestroyed();
        }
    }

    @Override // defpackage.rm0
    public void onActivityPaused() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityPaused();
        }
    }

    @Override // defpackage.rm0
    public void onActivityResumed() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityResumed();
        }
    }

    @Override // defpackage.rm0
    public void onActivityStarted() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityStarted();
        }
    }

    @Override // defpackage.rm0
    public void onActivityStopped() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onActivityStopped();
        }
    }

    @Override // defpackage.rm0
    public void onApplicationCreated(Context context) {
        tryAttachPlugin(sm0.a.OnApplicationInitiated);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onApplicationCreated(context);
        }
    }

    @Override // defpackage.nn0
    public void onCoverVisibleChange(boolean z) {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onCoverVisibleChange(z);
        }
    }

    @Override // defpackage.nn0
    public void onMapCreated() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onMapCreated();
        }
    }

    @Override // defpackage.nn0
    public void onMapDestroyed() {
        getINavigationState().setMapRenderStatus(vm0.a.Destroyed);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onMapDestroyed();
        }
    }

    @Override // defpackage.nn0
    public void onMapRedrawNeeded() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onMapRedrawNeeded();
        }
    }

    @Override // defpackage.nn0
    public void onMapSizeChanged(int i, int i2) {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onMapSizeChanged(i, i2);
        }
    }

    @Override // defpackage.nn0
    public void onUICreated() {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onUICreated();
        }
    }

    @Override // defpackage.nn0
    public void onUIDestroyed() {
        if (!getINavigationState().isIndexFragmentForeground()) {
            debugLog("onUIDestroyed isIndexFragmentForeground=false");
        }
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onUIDestroyed();
        }
    }

    @Override // defpackage.nn0
    public void onUISizeChanged(int i, int i2) {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onUISizeChanged(i, i2);
        }
    }

    @Override // defpackage.rm0
    public void onUiTouched(View view, MotionEvent motionEvent) {
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onUiTouched(view, motionEvent);
        }
    }

    @Override // defpackage.rm0
    public void onViewInflated() {
        tryAttachPlugin(sm0.a.OnViewInflated);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onViewInflated();
        }
    }

    @Override // defpackage.gn0
    public void onWindowFocusChanged(boolean z, vm0.a aVar) {
        debugLog("onWindowFocusChanged: " + z);
        Iterator<en0> it = this.mPluginsAttached.iterator();
        while (it.hasNext()) {
            it.next().onWindowFocusChanged(z, aVar);
        }
    }
}
