package com.autonavi.eaglet.surfacemng.cfg;

import android.util.Log;
import androidx.annotation.Keep;
import com.amap.location.common.model.AmapLoc;
import com.autonavi.eaglet.surfacemng.Adapter;
import defpackage.pn0;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Keep
/* loaded from: classes.dex */
public class Config {
    public static final boolean DEBUG = true;
    public static final String FALSE = "false";
    public static final String NULL = "";
    public static final String TAG = "SurfaceViewManagerCfg";
    public static Boolean sSupported;
    public static final b performanceCheck = new b("sm_enable_performance_check");
    public static final String TRUE = "true";
    public static final b dummy = new b("sm_enable_dummy", TRUE);
    public static final b adapterRes = new b("sm_enable_adapter_res");
    public static final b sync = new b("sm_enable_surface_sync");
    public static final b cover = new b("sm_enable_cover");
    public static final b fence = new b("sm_enable_surface_fence");
    public static final b wndReuse = new b("sm_enable_wnd_reuse");
    public static final b widgetCover = new b("sm_enable_widget_cover");
    public static final b fitMapSize = new b("sm_enable_fit_map_size");
    public static final b cleanStartupBg = new b("sm_clean_startup_bg");
    public static final b removeCoverOnStart = new b("sm_support_remove_cover_on_start");
    public static final b adapterLogo = new b("sm_support_adapter_logo");
    public static final b fillStatusBar = new b("sm_support_fill_status_bar");
    public static final b fillNaviBar = new b("sm_support_fill_navi_bar");
    public static final b colorStatusBar = new b("sm_support_color_status_bar", "#00000000");
    public static final b colorNaviBar = new b("sm_support_color_navi_bar", "#00000000");
    public static final b resBackDoor = new b("sm_support_res_backdoor");
    public static final b eagletBackDoor = new b("sm_support_eaglet_backdoor");
    public static final b multiWnd = new b("sm_support_multi_wnd");
    public static final b uiOffset = new b("sm_support_ui_offset");
    public static final b disableMapColorClear = new b("sm_disable_map_color_clear");
    public static final b firstStartup = new b("sm_support_first_startup");
    public static final b exitAnimate = new b("sm_support_exit_animate");
    public static final b coverDelay = new b("sm_support_cover_delay", "0");
    public static final b coverDelayOnCreate = new b("sm_support_cover_delay_on_create", "0");
    public static final b coverCopyProxy = new b("sm_support_cover_copy_proxy", "onPause");
    public static final b widgetWndId = new b("sm_enable_widgetCoverForWndId");
    public static final b widgetClearColor = new b("sm_support_widget_clear_color", "127");
    public static final b widgetCoverMaxFrame = new b("sm_support_widgetCoverMaxFrame", AmapLoc.RESULT_TYPE_FUSED);
    public static final b mapInitMaxWait = new b("sm_support_mapInitMaxWait", "4000");
    public static final b mapCallback2 = new b("sm_support_map_cb2");
    public static final b mapCb2MaxWait = new b("sm_support_map_cb2_max_wait", "4000");
    public static final b mapCb2Delay = new b("sm_support_map_cb2_delay", "0");
    public static final b mapResumeOnViewCreate = new b("sm_support_map_resume_on_view_create");
    public static final b mapRebindMultiWnd = new b("sm_rebind_on_multi_wnd");
    public static final b mapRebindChangedSize = new b("sm_rebind_map_changed_size");
    public static final b mapRebindDelay = new b("sm_rebind_map_delay");

    /* loaded from: classes.dex */
    public static class a {
        public final String a;
        public String b;

        public a(String str, String str2) {
            this.a = str;
            this.b = str2;
        }

        public String a() {
            return this.b;
        }

        public void a(String str) {
            this.b = str;
            Config.debugLog("set " + this.a + "=" + str);
        }
    }

    /* loaded from: classes.dex */
    public static class b extends a {
        public static final List<b> c = new ArrayList();

        public b(String str) {
            this(str, null);
        }

        public int a(int i) {
            try {
                return Integer.parseInt(a());
            } catch (Exception unused) {
                Config.debugLog("getInt error:" + this.a + "=" + a());
                return i;
            }
        }

        public int b() {
            return a(0);
        }

        public boolean c() {
            if (a() == null || a().length() == 0 || Config.FALSE.equals(a())) {
                return false;
            }
            if (a().equals(Config.TRUE)) {
                return true;
            }
            return a().contains(Adapter.JNIContext().d());
        }

        public b(String str, String str2) {
            super(str, str2);
            c.add(this);
        }
    }

    public static void debugLog(String str, String str2) {
        Adapter.Logger().d(str, str2);
    }

    public static void finishLoad() {
        ConfigEaglet.finishLoad();
        ConfigHmi.finishLoad();
        ConfigHmiVar.finishLoad();
    }

    public static List<b> getConfigList() {
        return b.c;
    }

    public static boolean isSupport() {
        if (sSupported == null) {
            Iterator it = b.c.iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                if (((b) it.next()).c()) {
                    sSupported = true;
                    break;
                }
            }
        }
        if (sSupported == null) {
            sSupported = false;
        }
        return sSupported.booleanValue();
    }

    public static void preLoad() {
        pn0.f();
        ConfigEaglet.preLoad();
        ConfigHmi.preLoad();
        ConfigHmiVar.preLoad();
    }

    public static void debugLog(String str) {
        if (!Adapter.Logger().a()) {
            Log.d(TAG, str);
        }
        debugLog(TAG, str);
    }
}
