package com.autonavi.eaglet.surfacemng.cfg;

import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.Adapter;
import com.autonavi.eaglet.surfacemng.cfg.Config;

@Keep
/* loaded from: classes.dex */
public class ConfigHmi {
    public static final b CONFIG_sm_eagletVariables;
    public static final b CONFIG_u_forebackState;
    public static final b CONFIG_u_wndFocusState;
    public static final String TAG_FN_WRITE = "sm_func_config_write_enable";
    public static final String TAG_VER_DEVELOP = "sm_is_verDevelop";
    public static final Config.b smDeclareFnConfig = new Config.b("sm_def_fn_config");
    public static final Config.b smDeclareUIConfig = new Config.b("sm_def_ui_config");

    /* loaded from: classes.dex */
    public static class b extends Config.a {
        @Override // com.autonavi.eaglet.surfacemng.cfg.Config.a
        public void a(String str) {
            if (str != null && str.equals(a())) {
                Config.debugLog(String.format("set same value %s=%s", this.a, str));
            } else {
                super.a(str);
                c();
            }
        }

        public String b() {
            return Adapter.TurboConfig().d(this.a, "");
        }

        public void c() {
            if (a() == null) {
                return;
            }
            Config.debugLog(String.format("setString ret=%b", Boolean.valueOf(Adapter.TurboConfig().a(this.a, a()))));
        }

        public b(String str, String str2, boolean z) {
            super(str, str2);
            if (z) {
                c();
            }
        }
    }

    static {
        boolean z = false;
        CONFIG_sm_eagletVariables = new b("sm_eagletVariables", null, z);
        String str = "-1";
        CONFIG_u_forebackState = new b("u_forebackState", str, true);
        CONFIG_u_wndFocusState = new b("u_wndFocusState", str, z);
    }

    public static void finishLoad() {
        initFnUIConfig();
    }

    public static void initFnUIConfig() {
        setFnConfigByDeclare();
        if (isWarnChecked()) {
            return;
        }
        setUiConfigByDeclare();
    }

    public static boolean isWarnChecked() {
        String d = Adapter.TurboConfig().d("warn", "0");
        Config.debugLog("WarnChecked: " + d);
        return d.equals("1") || d.equals(Config.TRUE);
    }

    public static void preLoad() {
    }

    public static void setFnConfigByDeclare() {
        String[] split;
        if (smDeclareFnConfig.a() == null || smDeclareFnConfig.a().length() == 0 || (split = smDeclareFnConfig.a().split("\\|")) == null) {
            return;
        }
        VarBuilder.setEagletVariable("sm_is_verDevelop", 1);
        VarBuilder.setEagletVariable(TAG_FN_WRITE, 1);
        for (String str : split) {
            String[] split2 = str.split("=");
            if (split2.length >= 2) {
                Config.debugLog(String.format("setFnConfig %s=%s, %b", split2[0], split2[1], Boolean.valueOf(Adapter.TurboConfig().b(split2[0], split2[1]))));
            }
        }
        VarBuilder.setEagletVariable(TAG_FN_WRITE, 0);
        VarBuilder.setEagletVariable("sm_is_verDevelop", 0);
    }

    public static void setUiConfigByDeclare() {
        String[] split;
        if (smDeclareUIConfig.a() == null || smDeclareUIConfig.a().length() == 0 || (split = smDeclareUIConfig.a().split("\\|")) == null) {
            return;
        }
        for (String str : split) {
            String[] split2 = str.split("=");
            if (split2.length >= 2) {
                Config.debugLog(String.format("setUIConfig %s=%s, %b", split2[0], split2[1], Boolean.valueOf(Adapter.TurboConfig().a(split2[0], split2[1]))));
            }
        }
    }
}
