package com.autonavi.eaglet.surfacemng.cfg;

import android.app.Application;
import android.content.res.Resources;
import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import com.autonavi.eaglet.surfacemng.cfg.XmlLoader;
import defpackage.qn0;
import java.io.FileInputStream;
import java.io.InputStream;

@Keep
/* loaded from: classes.dex */
public class ConfigLoader {
    public static final String BACK_DOOR_FILE = "sm_channels";
    public static final boolean DEBUG = true;
    public static final String TAG = "SurfaceViewManagerLoad";
    public static final String TAG_NEW_CONFIG = "string";

    public static void debugLog(String str) {
        Config.debugLog(TAG, str);
    }

    public static boolean init(Application application) {
        Config.preLoad();
        boolean z = initFromBackdoor(XmlLoader.getBackDoorFullPath("sm_channels.xml")) || initFromRaw(application) || initFromValues(application);
        Config.finishLoad();
        return z;
    }

    public static boolean initFromBackdoor(String str) {
        boolean z = false;
        if (str != null && str.length() != 0) {
            debugLog("initFromBackdoor begin " + str);
            try {
                try {
                    z = initFromStream(new FileInputStream(str));
                } finally {
                }
            } catch (Exception e) {
                debugLog(e.toString());
            }
            debugLog("initFromBackdoor end");
        }
        return z;
    }

    public static boolean initFromRaw(Application application) {
        int identifier = application.getResources().getIdentifier(BACK_DOOR_FILE, "raw", application.getPackageName());
        debugLog("initFromRaw resId=" + identifier);
        boolean z = false;
        if (identifier == 0) {
            return false;
        }
        try {
            InputStream openRawResource = application.getResources().openRawResource(identifier);
            try {
                z = initFromStream(openRawResource);
                if (openRawResource != null) {
                    openRawResource.close();
                }
            } finally {
            }
        } catch (Exception e) {
            debugLog(e.toString());
        }
        debugLog("initFromRaw end");
        return z;
    }

    public static boolean initFromStream(InputStream inputStream) {
        XmlLoader xmlLoader = new XmlLoader();
        xmlLoader.addBuilder("resources", a.class);
        xmlLoader.addBuilder(TAG_NEW_CONFIG, XmlLoader.a.class);
        return xmlLoader.initFromStream(inputStream) != null;
    }

    public static boolean initFromValues(Application application) {
        debugLog("initFromRes begin");
        Resources resources = application.getResources();
        String packageName = application.getPackageName();
        for (Config.b bVar : Config.getConfigList()) {
            int identifier = resources.getIdentifier(bVar.a, TAG_NEW_CONFIG, packageName);
            if (identifier != 0) {
                bVar.a(resources.getString(identifier));
            }
        }
        debugLog("initFromRes end");
        return true;
    }

    /* loaded from: classes.dex */
    public static class a implements XmlLoader.b {
        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public void a(XmlLoader.b bVar) {
            if (bVar instanceof XmlLoader.a) {
                a((XmlLoader.a) bVar);
            }
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ void a(String str, String str2) {
            qn0.a(this, str, str2);
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ boolean a() {
            return qn0.a(this);
        }

        public final void a(XmlLoader.a aVar) {
            for (Config.b bVar : Config.getConfigList()) {
                if (bVar.a.equals(aVar.a)) {
                    bVar.a(aVar.b);
                    return;
                }
            }
        }
    }
}
