package com.autonavi.eaglet.surfacemng.cfg;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Window;
import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.XmlLoader;
import com.autonavi.indoor.pdr.ErrorCode;
import defpackage.qn0;
import defpackage.wn0;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Keep
/* loaded from: classes.dex */
public final class ThemeLoader {
    public static final String BACK_DOOR_THEME_NAVI = "styles.xml";
    public static final String BACK_DOOR_THEME_USB = "styles_usb.xml";
    public static final String TAG = "SurfaceViewManagerThm";
    public boolean mInitiated;
    public b mRootBuilder;

    /* loaded from: classes.dex */
    public static class c implements XmlLoader.b {
        public final List<XmlLoader.a> a = new ArrayList();

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public void a(XmlLoader.b bVar) {
            if (bVar instanceof XmlLoader.a) {
                this.a.add((XmlLoader.a) bVar);
            }
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ void a(String str, String str2) {
            qn0.a(this, str, str2);
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ boolean a() {
            return qn0.a(this);
        }
    }

    /* loaded from: classes.dex */
    public static class d {
        public static final ThemeLoader a = new ThemeLoader();

        public static b a() {
            return a.mRootBuilder;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void applyTheme(Activity activity, String str) {
        if (!this.mInitiated) {
            initRootBuilder(activity, str);
            this.mInitiated = true;
        }
        b bVar = this.mRootBuilder;
        if (bVar != null) {
            bVar.a(activity);
        }
    }

    public static void debugLog(String str) {
        Config.debugLog(TAG, str);
    }

    private boolean initFromFile(Activity activity, String str) {
        boolean z = false;
        if (str != null && str.length() != 0) {
            if (this.mRootBuilder != null) {
                return true;
            }
            debugLog("initFromFile begin: " + str);
            try {
            } catch (Exception e) {
                debugLog(e.toString());
                e.printStackTrace();
            }
            try {
                z = initFromStream(new FileInputStream(str));
                debugLog("initFromFile end: " + z);
            } finally {
            }
        }
        return z;
    }

    private boolean initFromRes(Activity activity, String str) {
        String replace = str.replace(".xml", "");
        int identifier = activity.getResources().getIdentifier(replace, "raw", activity.getPackageName());
        debugLog(replace + "=" + identifier);
        boolean z = false;
        if (identifier == 0) {
            return false;
        }
        debugLog("initFromRes begin");
        try {
            InputStream openRawResource = activity.getResources().openRawResource(identifier);
            try {
                z = initFromStream(openRawResource);
                if (openRawResource != null) {
                    openRawResource.close();
                }
            } finally {
            }
        } catch (Exception e) {
            debugLog(e.toString());
        }
        debugLog("initFromRes end");
        return z;
    }

    private boolean initFromStream(InputStream inputStream) {
        XmlLoader xmlLoader = new XmlLoader();
        xmlLoader.addBuilder("resources", b.class);
        xmlLoader.addBuilder("style", c.class);
        xmlLoader.addBuilder("item", XmlLoader.a.class);
        b bVar = (b) xmlLoader.initFromStream(inputStream);
        this.mRootBuilder = bVar;
        return bVar != null;
    }

    public void initRootBuilder(Activity activity, String str) {
        if (initFromFile(activity, XmlLoader.getBackDoorFullPath(str))) {
            return;
        }
        initFromRes(activity, str);
    }

    /* loaded from: classes.dex */
    public static class b implements XmlLoader.b {
        public c a;
        public Drawable b;
        public int c = -1;

        public static void d(Window window, XmlLoader.a aVar) {
            int parseColor = Color.parseColor(aVar.b);
            if (Build.VERSION.SDK_INT >= 21) {
                window.setNavigationBarColor(parseColor);
            }
            ThemeLoader.debugLog("naviBarColor=" + parseColor);
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public void a(XmlLoader.b bVar) {
            if (bVar instanceof c) {
                this.a = (c) bVar;
            }
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ void a(String str, String str2) {
            qn0.a(this, str, str2);
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ boolean a() {
            return qn0.a(this);
        }

        public final void b(Activity activity, XmlLoader.a aVar) {
            if (aVar.b()) {
                int a = wn0.a(aVar.b, "style");
                if (a >= 0) {
                    activity.getWindow().setWindowAnimations(a);
                    return;
                }
                return;
            }
            activity.getWindow().setWindowAnimations(0);
        }

        public final void c(Window window, XmlLoader.a aVar) {
            Drawable c = wn0.c(aVar.b);
            if (c != null) {
                window.setBackgroundDrawable(c);
            }
        }

        public void a(Activity activity) {
            ThemeLoader.debugLog("applyTheme " + this.a);
            c cVar = this.a;
            if (cVar == null) {
                return;
            }
            for (XmlLoader.a aVar : cVar.a) {
                ThemeLoader.debugLog("applyTheme " + aVar.a + ", " + aVar.b);
                a(activity, aVar);
            }
        }

        public final void b(Window window, XmlLoader.a aVar) {
            int parseColor = Color.parseColor(aVar.b);
            if (Build.VERSION.SDK_INT >= 21) {
                window.setStatusBarColor(parseColor);
            }
        }

        /* JADX WARN: Can't fix incorrect switch cases order, some code will duplicate */
        public final void a(Activity activity, XmlLoader.a aVar) {
            char c;
            Window window = activity.getWindow();
            String str = aVar.a;
            switch (str.hashCode()) {
                case -1860584248:
                    if (str.equals("android:windowAnimationStyle")) {
                        c = 3;
                        break;
                    }
                    c = 65535;
                    break;
                case -1528967536:
                    if (str.equals("android:windowTranslucentStatus")) {
                        c = 5;
                        break;
                    }
                    c = 65535;
                    break;
                case -1382446670:
                    if (str.equals("android:windowTranslucentNavigation")) {
                        c = 6;
                        break;
                    }
                    c = 65535;
                    break;
                case -991306286:
                    if (str.equals("autonavi:cover")) {
                        c = '\t';
                        break;
                    }
                    c = 65535;
                    break;
                case -756582084:
                    if (str.equals("android:windowNoTitle")) {
                        c = 0;
                        break;
                    }
                    c = 65535;
                    break;
                case -148258279:
                    if (str.equals("autonavi:immersiveMode")) {
                        c = '\n';
                        break;
                    }
                    c = 65535;
                    break;
                case 30393065:
                    if (str.equals("android:windowBackground")) {
                        c = 1;
                        break;
                    }
                    c = 65535;
                    break;
                case 51431821:
                    if (str.equals("android:statusBarColor")) {
                        c = 7;
                        break;
                    }
                    c = 65535;
                    break;
                case 1472653686:
                    if (str.equals("android:windowFullscreen")) {
                        c = 2;
                        break;
                    }
                    c = 65535;
                    break;
                case 1908511791:
                    if (str.equals("android:navigationBarColor")) {
                        c = '\b';
                        break;
                    }
                    c = 65535;
                    break;
                case 2087619125:
                    if (str.equals("android:windowDrawsSystemBarBackgrounds")) {
                        c = 4;
                        break;
                    }
                    c = 65535;
                    break;
                default:
                    c = 65535;
                    break;
            }
            switch (c) {
                case 0:
                    a(aVar);
                    return;
                case 1:
                    c(window, aVar);
                    return;
                case 2:
                    a(window, aVar, ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR);
                    return;
                case 3:
                    b(activity, aVar);
                    return;
                case 4:
                    a(window, aVar, Integer.MIN_VALUE);
                    return;
                case 5:
                    a(window, aVar, 67108864);
                    return;
                case 6:
                    a(window, aVar, 134217728);
                    return;
                case 7:
                    b(window, aVar);
                    return;
                case '\b':
                    d(window, aVar);
                    return;
                case '\t':
                    this.b = wn0.c(aVar.b);
                    return;
                case '\n':
                    a(window, aVar);
                    return;
                default:
                    return;
            }
        }

        public final void a(XmlLoader.a aVar) {
            aVar.b();
        }

        public final void a(Window window, XmlLoader.a aVar, int i) {
            if (aVar.b()) {
                window.addFlags(i);
            } else {
                window.clearFlags(i);
            }
        }

        public final void a(Window window, XmlLoader.a aVar) {
            int a = a.a(aVar.b);
            this.c = a;
            if (a > 0) {
                window.getDecorView().setSystemUiVisibility(this.c);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class a {
        public static final Map<String, Integer> a;

        static {
            HashMap hashMap = new HashMap();
            a = hashMap;
            hashMap.put("SYSTEM_UI_FLAG_VISIBLE", 0);
            a.put("SYSTEM_UI_FLAG_LOW_PROFILE", 1);
            a.put("SYSTEM_UI_FLAG_HIDE_NAVIGATION", 2);
            a.put("SYSTEM_UI_FLAG_FULLSCREEN", 4);
            a.put("SYSTEM_UI_FLAG_LAYOUT_STABLE", 256);
            a.put("SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION", 512);
            a.put("SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN", Integer.valueOf(ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR));
            a.put("SYSTEM_UI_FLAG_IMMERSIVE", Integer.valueOf(ErrorCode.SENSOR_GRAVITY_TIMESTAMP_ERROR));
            a.put("SYSTEM_UI_FLAG_IMMERSIVE_STICKY", Integer.valueOf(ErrorCode.SENSOR_GYRO_TIMESTAMP_ERROR));
            a.put("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR", Integer.valueOf(ErrorCode.SENSOR_MAGNETIC_TIMESTAMP_ERROR));
            a.put("SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR", 16);
        }

        public static int a(String str) {
            int i = 0;
            for (String str2 : str.split("\\|")) {
                if (a.get(str2) == null) {
                    ThemeLoader.debugLog("immersiveMode not find " + str2);
                } else {
                    i |= a.get(str2).intValue();
                    ThemeLoader.debugLog(str2 + " = " + a.get(str2));
                }
            }
            ThemeLoader.debugLog("immersiveMode = " + i);
            return i;
        }

        public static void a(int i) {
            ThemeLoader.debugLog("parseIntMode:" + i);
            for (Map.Entry<String, Integer> entry : a.entrySet()) {
                if ((entry.getValue().intValue() & i) != 0) {
                    ThemeLoader.debugLog(entry.getKey());
                }
            }
        }
    }
}
