package com.autonavi.eaglet.surfacemng.cfg;

import androidx.annotation.Keep;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.eaglet.surfacemng.Adapter;
import defpackage.qn0;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Keep
/* loaded from: classes.dex */
public final class XmlLoader {
    public static final boolean DEBUG = false;
    public static final String NAVI_PATH = "/amapauto9/";
    public static final String SDCARD_PATH = "/sdcard";
    public static final String TAG = "SurfaceViewManagerXml";
    public final Map<String, Class> declareInfoMap = new HashMap();

    /* loaded from: classes.dex */
    public static class a implements b {
        public String a;
        public String b;

        public a() {
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ void a(b bVar) {
            qn0.a(this, bVar);
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public void a(String str, String str2) {
            XmlLoader.debugLog("BaseItemBuilder setTag " + str + "=" + str2);
            this.a = str;
            this.b = str2;
        }

        @Override // com.autonavi.eaglet.surfacemng.cfg.XmlLoader.b
        public /* synthetic */ boolean a() {
            return qn0.a(this);
        }

        public boolean b() {
            return Config.TRUE.equals(this.b);
        }

        public a(Element element) {
            if (element.getAttribute(StandardProtocolKey.NAME).length() == 0) {
                this.a = element.getTagName();
            } else {
                this.a = element.getAttribute(StandardProtocolKey.NAME);
            }
            this.b = element.getFirstChild().getNodeValue().trim();
            XmlLoader.debugLog("BaseItemBuilder name " + this.a + ", value=" + this.b);
        }
    }

    /* loaded from: classes.dex */
    public interface b {
        void a(b bVar);

        void a(String str, String str2);

        boolean a();
    }

    /* loaded from: classes.dex */
    public static class c {
        public static b b(String str, XmlLoader xmlLoader) {
            try {
                try {
                    return b(new FileInputStream(str), xmlLoader);
                } finally {
                }
            } catch (Exception e) {
                XmlLoader.debugLog(e.toString());
                return null;
            }
        }

        public static b a(Element element, XmlLoader xmlLoader) {
            XmlLoader.debugLog("readXmlByDOM: parseElement=" + element.getTagName());
            b object = xmlLoader.getObject(element.getTagName());
            if (object == null) {
                return null;
            }
            a(element, object);
            if (object.a()) {
                XmlLoader.debugLog("readXmlByDOM: ignoredItem=" + element.getTagName());
                return null;
            }
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); i++) {
                Node item = childNodes.item(i);
                if (item instanceof Element) {
                    a(xmlLoader, object, (Element) item);
                }
            }
            return object;
        }

        public static b b(InputStream inputStream, XmlLoader xmlLoader) {
            try {
                return a(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream).getDocumentElement(), xmlLoader);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void a(Element element, b bVar) {
            for (int i = 0; i < element.getAttributes().getLength(); i++) {
                Node item = element.getAttributes().item(i);
                XmlLoader.debugLog("readXmlByDOM: attr nodeName=" + item.getNodeName() + ", nodeValue=" + item.getNodeValue());
                bVar.a(item.getNodeName(), item.getNodeValue());
            }
        }

        public static void b(XmlLoader xmlLoader, b bVar, Element element) {
            b object = xmlLoader.getObject(element.getTagName());
            if (object == null) {
                object = new a(element);
            } else {
                object.a(element.getAttribute(StandardProtocolKey.NAME), element.getFirstChild().getNodeValue().trim());
            }
            bVar.a(object);
        }

        public static void a(XmlLoader xmlLoader, b bVar, Element element) {
            if (element.getChildNodes().getLength() == 1) {
                b(xmlLoader, bVar, element);
                return;
            }
            b a = a(element, xmlLoader);
            if (a != null) {
                bVar.a(a);
            }
        }
    }

    public static void debugLog(String str) {
    }

    public static String getBackDoorFullPath(String str) {
        try {
            File file = new File(Adapter.JNIContext().c() + str);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
        } catch (Exception e) {
            debugLog(e.toString());
        }
        try {
            File file2 = new File(SDCARD_PATH + (NAVI_PATH + str));
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
            return null;
        } catch (Exception e2) {
            debugLog(e2.toString());
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public b getObject(String str) {
        try {
            Class cls = this.declareInfoMap.get(str);
            r0 = cls != null ? cls.newInstance() : null;
            if (cls == null) {
                debugLog("Item not declared: " + str);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (b) r0;
    }

    public <T extends b> void addBuilder(String str, Class<T> cls) {
        this.declareInfoMap.put(str, cls);
    }

    public b initFromFile(String str) {
        return c.b(str, this);
    }

    public b initFromStream(InputStream inputStream) {
        return c.b(inputStream, this);
    }
}
