package com.autonavi.eaglet.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Keep;
import com.autonavi.eaglet.surfacemng.cfg.XmlLoader;
import defpackage.rl0;
import defpackage.vl0;
import java.io.File;

@Keep
/* loaded from: classes.dex */
public class AndroidPlatform {
    public static final String ACTION_GFRAME_PER_DRAW = "action_gframe_per_draw";
    public static final String FALLBACK_BBK_FONT = "DroidSansFallbackBBK.ttf";
    public static final String FALLBACK_FONT = "DroidSansFallback.ttf";
    public static final String SANS_CJK_FONT = "NotoSansCJK-Regular.ttc";
    public static final String SANS_HANS_FONT = "NotoSansHans-Regular.otf";
    public static final String SANS_SC_FONT = "NotoSansSC-Regular.otf";
    public static final String SYSTEM_FONT_LOCATION = "/system/fonts/";
    public static final String TAG = "AndroidPlatform";

    public static Object getAssetManager(Context context) {
        return context.getAssets();
    }

    public static String getConfigPath() {
        File filesDir;
        Application a = rl0.g().a();
        if (a == null || (filesDir = a.getFilesDir()) == null) {
            return null;
        }
        return filesDir.getAbsolutePath();
    }

    public static int getDefaultDisplayDpi(Context context) {
        if (rl0.g().b().h() > 0) {
            return rl0.g().b().h();
        }
        int i = context.getResources().getDisplayMetrics().densityDpi;
        int i2 = (int) context.getResources().getDisplayMetrics().xdpi;
        StringBuilder sb = new StringBuilder();
        sb.append(context.getFilesDir().getPath());
        sb.append("/ppi.txt");
        return new File(sb.toString()).exists() ? i2 : i;
    }

    public static int getDefaultDisplayHeight(Context context) {
        WindowManager windowManager = (WindowManager) context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static int getDefaultDisplayWidth(Context context) {
        WindowManager windowManager = (WindowManager) context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getDisplayDpi(Context context, int i) {
        DisplayManager displayManager;
        if (i == 0) {
            return getDefaultDisplayDpi(context);
        }
        if (i <= 0 || (displayManager = (DisplayManager) context.getSystemService("display")) == null || Build.VERSION.SDK_INT < 17) {
            return 0;
        }
        vl0 b = rl0.g().b();
        Display[] displays = displayManager.getDisplays(b != null ? b.b() : false ? null : "android.hardware.display.category.PRESENTATION");
        if (displays == null || displays.length < i) {
            return 0;
        }
        Display display = displays[i - 1];
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return displayMetrics.densityDpi;
    }

    public static int getDisplayHeight(Context context, int i) {
        int i2;
        DisplayManager displayManager;
        vl0 b = rl0.g().b();
        if (i == 0) {
            i2 = getDefaultDisplayHeight(context);
        } else {
            if (i > 0 && (displayManager = (DisplayManager) context.getSystemService("display")) != null && Build.VERSION.SDK_INT >= 17) {
                Display[] displays = displayManager.getDisplays(b != null ? b.b() : false ? null : "android.hardware.display.category.PRESENTATION");
                if (displays != null && displays.length >= i) {
                    Rect rect = new Rect();
                    displays[i - 1].getRectSize(rect);
                    i2 = rect.height();
                }
            }
            i2 = 0;
        }
        if (b != null) {
            b.logD(TAG, "getDisplayWidth screenId:{?},height:{?} ", Integer.valueOf(i), Integer.valueOf(i2));
        }
        return i2;
    }

    public static int getDisplayWidth(Context context, int i) {
        int i2;
        DisplayManager displayManager;
        vl0 b = rl0.g().b();
        if (i == 0) {
            i2 = getDefaultDisplayDpi(context);
        } else {
            if (i > 0 && (displayManager = (DisplayManager) context.getSystemService("display")) != null && Build.VERSION.SDK_INT >= 17) {
                Display[] displays = displayManager.getDisplays(b != null ? b.b() : false ? null : "android.hardware.display.category.PRESENTATION");
                if (displays != null && displays.length >= i) {
                    Rect rect = new Rect();
                    displays[i - 1].getRectSize(rect);
                    i2 = rect.width();
                }
            }
            i2 = 0;
        }
        if (b != null) {
            b.logD(TAG, "getDisplayWidth screenId:{?},width:{?} ", Integer.valueOf(i), Integer.valueOf(i2));
        }
        return i2;
    }

    public static String getFallbackFont() {
        if (new File("/system/fonts/DroidSansFallbackBBK.ttf").exists()) {
            return "/system/fonts/DroidSansFallbackBBK.ttf";
        }
        if (new File("/system/fonts/NotoSansHans-Regular.otf").exists()) {
            return "/system/fonts/NotoSansHans-Regular.otf";
        }
        if (new File("/system/fonts/NotoSansSC-Regular.otf").exists()) {
            return "/system/fonts/NotoSansSC-Regular.otf";
        }
        if (new File("/system/fonts/NotoSansCJK-Regular.ttc").exists()) {
            return "/system/fonts/NotoSansCJK-Regular.ttc";
        }
        if (new File("/system/fonts/DroidSansFallback.ttf").exists()) {
            return "/system/fonts/DroidSansFallback.ttf";
        }
        return null;
    }

    public static int getGLVersion(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService("activity");
        if (activityManager != null) {
            return activityManager.getDeviceConfigurationInfo().reqGlEsVersion;
        }
        return 0;
    }

    public static String getResPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + XmlLoader.NAVI_PATH;
    }

    public static long getStorageAvailableSize() {
        long blockSize;
        long availableBlocks;
        try {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath() + XmlLoader.NAVI_PATH);
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFs.getBlockSizeLong();
                availableBlocks = statFs.getAvailableBlocksLong();
            } else {
                blockSize = statFs.getBlockSize();
                availableBlocks = statFs.getAvailableBlocks();
            }
            return availableBlocks * blockSize;
        } catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int getSystemStatusBarHeight() {
        int identifier = rl0.g().a().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (identifier > 0) {
            return rl0.g().a().getResources().getDimensionPixelSize(identifier);
        }
        return -1;
    }

    public static int getUISurfaceShowHeight() {
        vl0 b = rl0.g().b();
        boolean e = b != null ? b.e() : true;
        Display defaultDisplay = ((WindowManager) rl0.g().a().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        int i = displayMetrics.heightPixels;
        if (b != null) {
            b.logD(TAG, "WindowManager metrics.heightPixels:{?} widthPixels:{?}", Integer.valueOf(i), Integer.valueOf(displayMetrics.widthPixels));
        }
        if (!e) {
            i -= getSystemStatusBarHeight();
        }
        if (b != null) {
            b.logD(TAG, "getUISurfaceShowHeight heightPixels:{?} ", Integer.valueOf(i));
        }
        Log.d(TAG, "log getUISurfaceShowHeight showHeight:" + i);
        return i;
    }

    public static void onPreDraw() {
    }
}
