package com.autonavi.extscreen;

import androidx.annotation.Keep;
import com.autonavi.extscreen.dto.PresentationConfig;
import defpackage.aa0;
import defpackage.jp;
import defpackage.qs;

@Keep
/* loaded from: classes.dex */
public class ExtScreenNative {
    public static final int MAP_SURFACE_TYPE = 0;
    public static final String TAG = "ExtScreenNative";
    public static final int UI_SURFACE_TYPE = 1;

    public static native boolean accquirePresentationConfig(PresentationConfig presentationConfig);

    public static void changeScreenMode(int i) {
        aa0.a(TAG, "changeScreenMode mode={?}", Integer.valueOf(i));
        jp.I().e(i);
    }

    public static void controlSurfaceVisibility(int i, int i2, boolean z) {
        aa0.a(TAG, "controlSurfaceVisivility windowId={?},surfaceType={?},show={?}", Integer.valueOf(i), Integer.valueOf(i2), Boolean.valueOf(z));
        qs.e().a(i, i2, z);
    }

    public static void createExternalScreen(PresentationConfig presentationConfig) {
        aa0.a(TAG, "createExternalScreen presentationConfig:{?}", presentationConfig.toString());
        qs.e().a(presentationConfig);
    }

    public static void destoryExternalScreen(int i) {
        aa0.a(TAG, "destoryExternalScreen id={?}", Integer.valueOf(i));
        qs.e().c(i);
    }

    public static native void notifyProjectionSizeChange(int i);

    public static native void notifyUIstyleChange(int i);
}
