package com.autonavi.indoor.constant;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.text.TextUtils;
import com.amap.location.common.a;
import com.amap.location.common.f.g;
import com.amap.location.common.model.AmapLoc;
import com.amap.location.sdk.fusion.LocationParams;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.NetworkHelper;
import com.autonavi.indoor.util.PackageHelper;
import com.autonavi.indoor.util.ProtocolHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: classes.dex */
public final class Configuration {
    public final Context context;
    public JSONObject jObject;
    public final String mAOSKey;
    public final int mDownloadPercentageBeforeLocating;
    public final DownloadSegment mDownloadSegment;
    public final String mKey;
    public final LocationMode mLocationMode;
    public LocationProvider mLocationProvider;
    public final int mNetworkType;
    public final PDRProvider mPDRProvider;
    public String mPackageName;
    public final int mReportInterval;
    public final String mSDKName;
    public final String mSDKVersion;
    public String mSHA1;
    public final SensorManager mSensorManager;
    public final String mServer;
    public final ServerType mServerType;
    public String mSign;
    public final String mSimulateFile;
    public final String mSqlitePath;
    public final Resources resources;

    /* loaded from: classes.dex */
    public static class Builder {
        public static final int DEFAULT_DOWNLOAD_PERCENTAGE = 80;
        public static final String DEFAULT_LBS_SERVER = "restapi.amap.com";
        public static final int DEFAULT_REPORT_INTEVAL = 1000;
        public static final String KEY_DEFAULT_BID = "default_bid";
        public static final String KEY_ONLINE_LOCATION_SERVER = "OnlineLocationServer";
        public static final String KEY_SIMULATEFILE = "SimulateFile";
        public final DownloadSegment DEFAULT_DOWNLOAD_SEGMENT;
        public final LocationMode DEFAULT_LOCATION_MODE;
        public Context context;
        public String mAOSChannel;
        public String mAOSKey;
        public String mAOSParam;
        public int mDownloadPercentageBeforeLocating;
        public DownloadSegment mDownloadSegment;
        public String mKey;
        public LocationMode mLocationMode;
        public LocationProvider mLocationProvider;
        public int mNetworkType;
        public PDRProvider mPDRProvider;
        public int mReportInterval;
        public String mSDKName;
        public String mSDKVersion;
        public String mServer;
        public ServerType mServerType;
        public String mSimulateFile;
        public String mSqlitePath;
        public static final LocationProvider DEFAULT_PROVIDER = LocationProvider.WIFI;
        public static final String DEFAULT_SQLITE_FILE = g.a((Context) null) + "/autonavi/indoor/fp.db";

        public Builder(Context context) {
            DownloadSegment downloadSegment = DownloadSegment.SMALL_SEGMENT;
            this.DEFAULT_DOWNLOAD_SEGMENT = downloadSegment;
            LocationMode locationMode = LocationMode.AUTO;
            this.DEFAULT_LOCATION_MODE = locationMode;
            this.mServer = DEFAULT_LBS_SERVER;
            this.mServerType = ServerType.SERVER_LBS;
            this.mLocationProvider = DEFAULT_PROVIDER;
            this.mReportInterval = 1000;
            this.mSqlitePath = DEFAULT_SQLITE_FILE;
            this.mDownloadPercentageBeforeLocating = 80;
            this.mDownloadSegment = downloadSegment;
            this.mLocationMode = locationMode;
            this.mNetworkType = 15;
            this.mAOSParam = "unset";
            this.mAOSKey = "";
            this.mAOSChannel = "aos_channel";
            this.mKey = "unset";
            this.mSDKName = "IndoorLocationSDK";
            this.mSDKVersion = "6.9";
            this.mPDRProvider = PDRProvider.DEFAULT;
            setContext(context);
        }

        private void initEmptyFieldsWithDefaultValues() {
        }

        public Configuration build() {
            initEmptyFieldsWithDefaultValues();
            return new Configuration(this);
        }

        public String getConfig(Properties properties, String str) {
            if (properties == null) {
                if (!L.isLogging) {
                    return null;
                }
                L.d("properties: you need call init first");
                return null;
            }
            return properties.getProperty(str);
        }

        public LocationProvider getLocationProvider() {
            return this.mLocationProvider;
        }

        public int getNetworkType() {
            return this.mNetworkType;
        }

        public Builder setAOSParam(String str, String str2) {
            this.mAOSParam = str;
            this.mAOSKey = str2;
            return this;
        }

        public Builder setContext(Context context) {
            final Context applicationContext = context.getApplicationContext();
            this.context = applicationContext;
            new Thread() { // from class: com.autonavi.indoor.constant.Configuration.Builder.1
                @Override // java.lang.Thread, java.lang.Runnable
                public void run() {
                    MapUtils.getImei(applicationContext);
                    MapUtils.getImsi(applicationContext);
                    a.f(applicationContext);
                    NetworkHelper.getNetworkType(applicationContext);
                }
            }.start();
            return this;
        }

        public Builder setDownloadPercentageBeforeLocating(int i) {
            this.mDownloadPercentageBeforeLocating = i;
            return this;
        }

        public Builder setLBSParam(String str) {
            this.mKey = str;
            return this;
        }

        public Builder setLocationMode(LocationMode locationMode) {
            this.mLocationMode = locationMode;
            return this;
        }

        public Builder setLocationProvider(LocationProvider locationProvider) {
            this.mLocationProvider = locationProvider;
            return this;
        }

        public Builder setNetworkType(int i) {
            this.mNetworkType = i;
            return this;
        }

        public Builder setPDRProvider(PDRProvider pDRProvider) {
            this.mPDRProvider = pDRProvider;
            return this;
        }

        public Builder setReportInterval(int i) {
            if (i > 0) {
                this.mReportInterval = i;
                return this;
            }
            throw new IllegalArgumentException("interval must be a positive number");
        }

        public Builder setSDKName(String str) {
            this.mSDKName = str;
            return this;
        }

        public Builder setSDKVersion(String str) {
            this.mSDKVersion = str;
            return this;
        }

        public Builder setServer(ServerType serverType, String str) {
            if (TextUtils.isEmpty(str)) {
                return this;
            }
            this.mServer = str;
            this.mServerType = serverType;
            return this;
        }

        public Builder setSqlitePath(String str) {
            this.mSqlitePath = str;
            return this;
        }
    }

    /* loaded from: classes.dex */
    public enum DownloadSegment {
        SMALL_SEGMENT,
        LARGE_SEGMENT
    }

    /* loaded from: classes.dex */
    public enum LocationMode {
        OFFLINE,
        AUTO
    }

    /* loaded from: classes.dex */
    public enum LocationProvider {
        WIFI,
        BLE,
        FUSION_WIFI_BLE
    }

    /* loaded from: classes.dex */
    public enum PDRProvider {
        DEFAULT,
        STEPANGLE
    }

    /* loaded from: classes.dex */
    public enum ServerType {
        SERVER_LBS,
        SERVER_AOS,
        SERVER_CUSTOM
    }

    public static Configuration createDefault(Context context) {
        return new Builder(context).build();
    }

    private String genAOSSign(String str, String str2, String str3) {
        String str4 = this.mAOSKey;
        if (TextUtils.isEmpty(str4)) {
            if ("amap7".equals(str)) {
                str4 = "1071a2a4e3gte2Uc32cY3a98Tf33H1c4Gc23f";
            } else if ("amap7a".equals(str)) {
                str4 = "xnaEwInMxaMQ2m0cw6Y1bDm7ns0YVxYS9v7JlC8I";
            }
        }
        return md5(str + str2 + str3 + "@" + str4);
    }

    public static String getMd5StandardString(String str) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
            messageDigest = null;
        }
        try {
            messageDigest.update(str.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e2) {
            if (L.isLogging) {
                L.d((Throwable) e2);
            }
        }
        return standardBytes2HexString(messageDigest.digest());
    }

    private String getTs() {
        String valueOf = String.valueOf(System.currentTimeMillis());
        int length = valueOf.length();
        return valueOf.substring(0, length - 2) + "1" + valueOf.substring(length - 1);
    }

    public static final String md5(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            messageDigest.update(str.getBytes());
            byte[] digest = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02X", Byte.valueOf(b)));
            }
            return sb.toString().toLowerCase();
        } catch (Exception unused) {
            return "";
        }
    }

    public static String scode(String str, String str2, String str3, String str4) throws Throwable {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        sb.append(":");
        sb.append(str2);
        sb.append(":");
        sb.append(str3.substring(0, str3.length() - 3));
        sb.append(":");
        sb.append("key=");
        sb.append(str4);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (L.isLogging) {
            L.d(sb.toString());
        }
        messageDigest.update(sb.toString().getBytes("UTF-8"));
        byte[] digest = messageDigest.digest();
        StringBuilder sb2 = new StringBuilder();
        for (byte b : digest) {
            String hexString = Integer.toHexString(b & 255);
            if (hexString.length() == 1) {
                hexString = '0' + hexString;
            }
            sb2.append(hexString);
        }
        return sb2.toString();
    }

    public static String standardBytes2HexString(byte[] bArr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bArr) {
            String hexString = Integer.toHexString(b & 255);
            if (hexString.length() == 1) {
                hexString = '0' + hexString;
            }
            sb.append(hexString);
        }
        return sb.toString();
    }

    public static String toEncodeQueryString(Map<?, ?> map) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                stringBuffer.append(entry.getKey() + "=");
                stringBuffer.append(URLEncoder.encode((String) entry.getValue(), "UTF-8") + "&");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        return stringBuffer.toString();
    }

    public static String toOldQueryString(Map<?, ?> map) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                stringBuffer.append(entry.getKey() + "=");
                stringBuffer.append(entry.getValue() + "&");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        return stringBuffer.toString();
    }

    public String getServerAdd() {
        String str;
        if (this.mServer.startsWith("https://")) {
            str = this.mServer;
        } else {
            str = "https://" + this.mServer;
        }
        ServerType serverType = this.mServerType;
        if (serverType == ServerType.SERVER_AOS) {
            return str + "/ws/transfer/auth/indoorlocation";
        }
        if (serverType == ServerType.SERVER_LBS) {
            return str + "/v3/indoor/indoorlocation";
        }
        return str + "/indoorlocation";
    }

    public String getUrl() {
        String str = getServerAdd() + "?";
        ServerType serverType = this.mServerType;
        if (serverType == ServerType.SERVER_AOS) {
            String[] strArr = {LocationParams.PARA_COMMON_DIP, LocationParams.PARA_COMMON_DIV, LocationParams.PARA_COMMON_DIBV, LocationParams.PARA_COMMON_DIC, LocationParams.PARA_COMMON_DIU, LocationParams.PARA_COMMON_DIU2, LocationParams.PARA_COMMON_DIU3, LocationParams.PARA_COMMON_TID, LocationParams.PARA_COMMON_ADIU, "stepid", "appstartid", LocationParams.PARA_COMMON_CIFA, LocationParams.PARA_COMMON_CHANNEL};
            StringBuilder sb = new StringBuilder();
            try {
                sb.append("ver=");
                sb.append(this.mSDKVersion);
                if (this.jObject != null) {
                    for (int i = 0; i < 13; i++) {
                        String str2 = strArr[i];
                        if (this.jObject.has(str2) && !TextUtils.isEmpty(this.jObject.getString(str2))) {
                            sb.append("&");
                            sb.append(str2);
                            sb.append("=");
                            sb.append(this.jObject.getString(str2));
                        } else {
                            sb.append("&");
                            sb.append(str2);
                            sb.append("=unkown");
                        }
                    }
                    String session = ProtocolHelper.getSession();
                    if (TextUtils.isEmpty(session)) {
                        sb.append("&session=unkown");
                    } else {
                        sb.append("&session=");
                        sb.append(session);
                    }
                    String spm = ProtocolHelper.getSpm();
                    if (TextUtils.isEmpty(spm)) {
                        sb.append("&spm=unkown");
                    } else {
                        sb.append("&spm=");
                        sb.append(spm);
                    }
                    String str3 = "0";
                    if (NetworkHelper.mNetworkType == 2) {
                        str3 = "1";
                    } else if (NetworkHelper.mNetworkType == 4) {
                        str3 = AmapLoc.RESULT_TYPE_FUSED;
                    } else if (NetworkHelper.mNetworkType == 8) {
                        str3 = AmapLoc.RESULT_TYPE_CELL_ONLY;
                    } else if (NetworkHelper.mNetworkType == 1) {
                        str3 = AmapLoc.RESULT_TYPE_CELL_WITH_NEIGHBORS;
                    } else if (L.isLogging) {
                        L.d("unknown network:" + NetworkHelper.mNetworkType);
                    }
                    sb.append("&output=bin&client_network_class=");
                    sb.append(str3);
                    sb.append("&sign=");
                    sb.append(this.mSign);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return MapUtils.amapEncodeUrl((str + ((CharSequence) sb)) + "&csid=" + UUID.randomUUID().toString());
        }
        if (serverType != ServerType.SERVER_LBS) {
            return str;
        }
        String ts = getTs();
        if (TextUtils.isEmpty(this.mSHA1)) {
            this.mSHA1 = PackageHelper.getSHA1(this.context);
        }
        if (TextUtils.isEmpty(this.mPackageName)) {
            this.mPackageName = this.context.getPackageName();
        }
        String str4 = null;
        try {
            str4 = scode(this.mSHA1, this.mPackageName, ts, this.mKey);
        } catch (Throwable th) {
            th.printStackTrace();
        }
        return str + "key=" + this.mKey + "&ts=" + ts + "&scode=" + str4;
    }

    public boolean isUsingBLE() {
        LocationProvider locationProvider = this.mLocationProvider;
        return locationProvider == LocationProvider.BLE || locationProvider == LocationProvider.FUSION_WIFI_BLE;
    }

    public boolean isUsingWifi() {
        LocationProvider locationProvider = this.mLocationProvider;
        return locationProvider == LocationProvider.WIFI || locationProvider == LocationProvider.FUSION_WIFI_BLE;
    }

    public void setAOSParam(String str) {
        try {
            setAOSParam(new JSONObject(str));
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public Configuration(Builder builder) {
        this.jObject = null;
        this.mSign = null;
        this.mSHA1 = null;
        this.mPackageName = null;
        this.resources = builder.context.getResources();
        this.context = builder.context;
        this.mServer = builder.mServer;
        this.mServerType = builder.mServerType;
        this.mSimulateFile = builder.mSimulateFile;
        this.mLocationProvider = builder.mLocationProvider;
        this.mLocationMode = builder.mLocationMode;
        this.mSensorManager = (SensorManager) builder.context.getSystemService("sensor");
        this.mReportInterval = builder.mReportInterval;
        this.mSqlitePath = builder.mSqlitePath;
        this.mDownloadPercentageBeforeLocating = builder.mDownloadPercentageBeforeLocating;
        this.mDownloadSegment = builder.mDownloadSegment;
        this.mNetworkType = builder.mNetworkType;
        if (!TextUtils.isEmpty(builder.mAOSParam) && !builder.mAOSParam.equals("unset")) {
            setAOSParam(builder.mAOSParam);
        }
        this.mAOSKey = builder.mAOSKey;
        this.mKey = builder.mKey;
        this.mSDKName = builder.mSDKName;
        this.mSDKVersion = builder.mSDKVersion;
        this.mPDRProvider = builder.mPDRProvider;
    }

    public void setAOSParam(JSONObject jSONObject) {
        this.jObject = jSONObject;
        try {
            String str = "amap7";
            if (jSONObject.has(LocationParams.PARA_COMMON_CHANNEL) && !TextUtils.isEmpty(jSONObject.getString(LocationParams.PARA_COMMON_CHANNEL))) {
                str = jSONObject.getString(LocationParams.PARA_COMMON_CHANNEL);
            }
            String str2 = "unkown";
            String string = (!jSONObject.has(LocationParams.PARA_COMMON_DIU) || TextUtils.isEmpty(jSONObject.getString(LocationParams.PARA_COMMON_DIU))) ? "unkown" : jSONObject.getString(LocationParams.PARA_COMMON_DIU);
            if (jSONObject.has(LocationParams.PARA_COMMON_DIV) && !TextUtils.isEmpty(jSONObject.getString(LocationParams.PARA_COMMON_DIV))) {
                str2 = jSONObject.getString(LocationParams.PARA_COMMON_DIV);
            }
            this.mSign = genAOSSign(str, string, str2);
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}
