package com.autonavi.indoor.location;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.provider.BLEHelper;
import com.autonavi.indoor.util.L;
import java.util.ArrayList;

/* loaded from: classes.dex */
public class ILocationManager {
    public Configuration mConfiguration;
    public volatile boolean mIsInited = false;
    public ArrayList<Handler> mOutterHandlers = new ArrayList<>();
    public String mBuildingID = "";
    public volatile boolean mIsLocating = false;
    public HandlerThread mLocationThread = null;

    public void checkInit() {
        if (isInited()) {
            return;
        }
        if (L.isLogging) {
            StringBuilder sb = new StringBuilder();
            sb.append("checkInit. mConfiguration is ");
            sb.append(this.mConfiguration == null ? "NULL" : "not null");
            sb.append(", mIsInited:");
            sb.append(this.mIsInited);
            L.d(sb.toString());
        }
        throw new IllegalStateException("OnlineLocator must be init with mConfiguration before using");
    }

    public boolean checkSensor(Configuration configuration, Handler handler) {
        if (!configuration.isUsingBLE()) {
            return true;
        }
        try {
            if (new BLEHelper(configuration.context).hasBluetooth()) {
                return true;
            }
            handler.sendEmptyMessage(MessageCode.MSG_BLE_NOT_SUPPORT);
            return false;
        } catch (SecurityException e) {
            if (!L.isLogging) {
                return true;
            }
            L.d((Throwable) e);
            return true;
        }
    }

    public void destroy() {
        throw new RuntimeException("Subclass should implement this method");
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public void init(String str, Configuration configuration, Handler handler) {
        throw new RuntimeException("Subclass should implement this method");
    }

    public boolean isInited() {
        return this.mConfiguration != null && this.mIsInited;
    }

    public boolean isLocating() {
        return this.mIsLocating;
    }

    public boolean isPdrEnable() {
        return true;
    }

    public boolean isSimulating(Configuration configuration) {
        return !TextUtils.isEmpty(configuration.mSimulateFile);
    }

    public void recordLocationData(double d, double d2, int i) {
    }

    public void removeUpdates(Handler handler) {
        throw new RuntimeException("Subclass should implement this method");
    }

    public void requestLocationUpdates(Handler handler) {
        throw new RuntimeException("Subclass should implement this method");
    }

    public void setPdr(int i, float f) {
        throw new RuntimeException("Subclass should implement this method");
    }
}
