package com.autonavi.indoor.onlinelocation;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.entity.LocationResult;
import com.autonavi.indoor.entity.PressData;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.location.ILocationManager;
import com.autonavi.indoor.pdr.MatStepData;
import com.autonavi.indoor.pdr.PedProvider;
import com.autonavi.indoor.provider.BLEProvider;
import com.autonavi.indoor.provider.WifiProvider;
import com.autonavi.indoor.simulator.FileDataProvider;
import com.autonavi.indoor.util.FileLogger;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.MessageHelper;
import com.autonavi.indoor.util.PackageHelper;
import com.autonavi.indoor.util.PermissionUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

/* loaded from: classes.dex */
public class OnlineLocator extends ILocationManager {
    public static volatile OnlineLocator h;
    public a i = null;
    public volatile boolean j = false;
    public int k = 0;
    public final FileLogger l = new FileLogger();
    public long m = 0;
    public int n = -1;
    public String o = "";
    public int a = 0;
    public long b = 0;
    public boolean c = false;
    public byte[] mLastRequestBuffer = null;
    public int p = -1;
    public int q = -1;
    public double r = -1.0d;
    public double s = -1.0d;
    public LocationResult d = null;
    public b e = null;
    public MatStepData f = new MatStepData();
    public long g = 0;
    public double t = 0.0d;

    /* loaded from: classes.dex */
    public static class a extends Handler {
        public final WeakReference<OnlineLocator> a;

        public a(Looper looper, OnlineLocator onlineLocator) {
            super(looper);
            this.a = new WeakReference<>(onlineLocator);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            OnlineLocator onlineLocator = this.a.get();
            if (onlineLocator == null || onlineLocator.j) {
                return;
            }
            if (!onlineLocator.mIsLocating) {
                if (L.isLogging) {
                    L.d("OnlineLocation is not running, can't process any message!please start locating");
                    return;
                }
                return;
            }
            try {
                if (message.what >= 714 && message.what <= 721) {
                    MessageHelper.publishMessage(onlineLocator.mOutterHandlers, message.what);
                }
                int i = message.what;
                if (i == 100) {
                    PressData pressData = (PressData) message.obj;
                    JNIWrapper.jniAddPress(pressData.mTime, pressData.mPress);
                    if (onlineLocator.l.isLogging) {
                        onlineLocator.l.d("pre:" + pressData.mTime + "," + pressData.mPress);
                        return;
                    }
                    return;
                }
                if (i == 111) {
                    ((MatStepData) message.obj).copy(onlineLocator.f);
                    MatStepData matStepData = onlineLocator.f;
                    if (L.isLogging) {
                        L.d("mat:" + (matStepData.timestamp_ / 1000) + ", mStep=" + matStepData.step_ + ",angle=" + matStepData.angle_ + ",angle_no_mag=" + matStepData.angle_no_mag_ + ", " + matStepData.move_direction_ + ", move_state_score_=" + matStepData.move_state_score_ + ", m1=" + matStepData.mat_data_[0] + ", q1=" + matStepData.q1_);
                    }
                    JNIWrapper.jniAddPress(matStepData.timestamp_, matStepData.pressure);
                    if (onlineLocator.l.isLogging) {
                        onlineLocator.l.d("pre:" + matStepData.timestamp_ + "," + matStepData.pressure);
                    }
                    if (onlineLocator.l.isLogging) {
                        onlineLocator.l.d("mat:" + matStepData.timestamp_ + "," + matStepData.step_ + "," + matStepData.angle_ + "," + matStepData.mat_data_[0] + "," + matStepData.mat_data_[1] + "," + matStepData.mat_data_[2] + "," + matStepData.q1_ + "," + matStepData.q2_ + "," + matStepData.q3_ + "," + matStepData.q4_ + "," + matStepData.rotate_rate_x_ + "," + matStepData.rotate_rate_y_ + "," + matStepData.rotate_rate_z_ + "," + matStepData.step_len_ + "," + matStepData.step_len_f_ + "," + matStepData.step_len_v_ + "," + matStepData.angle_no_mag_ + "," + matStepData.move_direction_ + "," + matStepData.move_state_score_);
                    }
                    JNIWrapper.jniAddMatStepData(matStepData.timestamp_, matStepData.step_, matStepData.angle_, matStepData.mat_data_[0], matStepData.mat_data_[1], matStepData.mat_data_[2], matStepData.q1_, matStepData.q2_, matStepData.q3_, matStepData.q4_, matStepData.rotate_rate_x_, matStepData.rotate_rate_y_, matStepData.rotate_rate_z_, matStepData.step_len_, matStepData.step_len_f_, matStepData.step_len_v_, matStepData.move_direction_, matStepData.angle_no_mag_, matStepData.move_state_score_);
                    onlineLocator.q = matStepData.step_;
                    onlineLocator.r = matStepData.showangle;
                    onlineLocator.s = matStepData.angle_no_mag_;
                    return;
                }
                if (i == 212) {
                    if (L.isLogging) {
                        L.d("MSG_NETWORK_ERROR Error!" + message.what);
                    }
                    MessageHelper.publishMessage(onlineLocator.mOutterHandlers, message.what);
                    return;
                }
                if (i == 214) {
                    onlineLocator.a(message);
                    return;
                }
                if (i != 501 && i != 506) {
                    if (i == 1218) {
                        if (onlineLocator.mIsLocating) {
                            if (!TextUtils.isEmpty(onlineLocator.getConfiguration().mSimulateFile)) {
                                onlineLocator.r = FileDataProvider.getInstance().mLastAngle;
                            } else if (!onlineLocator.isPdrEnable() && onlineLocator.getConfiguration().mPDRProvider == Configuration.PDRProvider.DEFAULT) {
                                onlineLocator.r = PedProvider.getInstance().getOrientation();
                            }
                            onlineLocator.d();
                            sendEmptyMessageDelayed(1218, 100L);
                            return;
                        }
                        return;
                    }
                    if (i != 503 && i != 504) {
                        switch (i) {
                            case 1200:
                                if (onlineLocator.mIsLocating) {
                                    if (L.isLogging) {
                                        L.d("TIMER(2S) PdrEnable=" + onlineLocator.isPdrEnable() + ", HasScan:" + onlineLocator.c);
                                    }
                                    if (onlineLocator.c) {
                                        if (onlineLocator.d != null && onlineLocator.q != -1 && onlineLocator.q == onlineLocator.p) {
                                            if (L.isLogging) {
                                                L.d("Don't request onlinelocation.for: CurrentStep=" + onlineLocator.q + ", LastStep=" + onlineLocator.p);
                                            }
                                        }
                                        JNIWrapper.c = 0;
                                        JNIWrapper.b = null;
                                        if (JNIWrapper.jniGetSendOnlineRequest(System.currentTimeMillis(), onlineLocator.mBuildingID, onlineLocator.isPdrEnable()) && JNIWrapper.c > 0 && JNIWrapper.b != null) {
                                            if (L.isLogging) {
                                                L.d("JniOnlineRequest.length:" + JNIWrapper.c + " request.data.len:" + JNIWrapper.b.length + ", parent.mlastReportResult=" + onlineLocator.d);
                                            }
                                            if (onlineLocator.e != null) {
                                                onlineLocator.e.a(onlineLocator.mBuildingID, JNIWrapper.b);
                                            }
                                            onlineLocator.p = onlineLocator.q;
                                        } else if (L.isLogging) {
                                            L.d("Don't request onlinelocation.for:request is null or length is 0");
                                        }
                                    }
                                    sendEmptyMessageDelayed(1200, 2000L);
                                    return;
                                }
                                return;
                            case 1201:
                                ScanData scanData = (ScanData) message.obj;
                                onlineLocator.a = scanData.scans_.size();
                                onlineLocator.b = System.currentTimeMillis();
                                onlineLocator.c = true;
                                if (!JNIWrapper.jniSetScan(scanData.time_, scanData) && L.isLogging) {
                                    L.d("ERROR on JNIWrapper.jniSetScan.");
                                }
                                if (scanData.size() > 0 && onlineLocator.l.isLogging) {
                                    onlineLocator.l.d(scanData);
                                }
                                if (onlineLocator.m == 0) {
                                    if (L.isLogging) {
                                        L.d("First Location not success, request it right now");
                                    }
                                    removeMessages(1200);
                                    onlineLocator.c();
                                    sendEmptyMessageDelayed(1200, 2000L);
                                    return;
                                }
                                return;
                            case 1202:
                                ScanData scanData2 = (ScanData) message.obj;
                                if (L.isLogging) {
                                    L.d("BleScaned:" + scanData2.scans_.size());
                                }
                                onlineLocator.a = scanData2.scans_.size();
                                onlineLocator.b = System.currentTimeMillis();
                                onlineLocator.c = true;
                                if (!JNIWrapper.jniSetScan(scanData2.time_, scanData2) && L.isLogging) {
                                    L.d("ERROR on JNIWrapper.jniSetScan.");
                                }
                                if (L.isLogging) {
                                    L.d("ble scan , time = " + scanData2.time_);
                                }
                                if (scanData2.size() <= 0 || !onlineLocator.l.isLogging) {
                                    return;
                                }
                                onlineLocator.l.d(scanData2);
                                return;
                            default:
                                return;
                        }
                    }
                }
                if (L.isLogging) {
                    L.d("WIFI/BLE Scan Error! Has no scan for msg=" + message.what);
                }
                onlineLocator.a = 0;
                onlineLocator.c = false;
                MessageHelper.publishMessage((ArrayList<Handler>) onlineLocator.mOutterHandlers, message.what, onlineLocator);
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    }

    public static OnlineLocator getInstance() {
        if (h == null) {
            synchronized (OnlineLocator.class) {
                if (h == null) {
                    h = new OnlineLocator();
                }
            }
        }
        return h;
    }

    public static String getSubVersion() {
        return "20170413";
    }

    public static String getVersion() {
        return "6.9";
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public synchronized void destroy() {
        if (!this.mIsInited && this.mConfiguration == null) {
            if (L.isLogging) {
                L.d("locationManager has been destoried");
            }
            return;
        }
        if (isLocating()) {
            if (L.isLogging) {
                L.d("isLocating");
            }
            return;
        }
        b();
        this.mOutterHandlers.clear();
        PedProvider.getInstance().setSensorHandler(null);
        if (this.mLocationThread != null) {
            this.mLocationThread.quit();
            this.mLocationThread = null;
        }
        try {
            if (this.e != null) {
                this.e.a();
                this.e = null;
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mConfiguration = null;
        if (L.isLogging) {
            L.d("onlinelocator destroyed");
        }
    }

    public byte[] getFeedbackBuffer() {
        return this.mLastRequestBuffer;
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public synchronized void init(String str, Configuration configuration, final Handler handler) {
        if (configuration != null && handler != null) {
            if (this.mConfiguration != null) {
                if (L.isLogging) {
                    L.d("Try to initialize OnlineLocation which had already been initialized before. To re-init LocationManager with new mConfiguration call OnlineLocation.destroy() at first.");
                }
                return;
            }
            if (!PermissionUtil.hasSelfPermission(configuration.context, PermissionUtil.permissions)) {
                if (L.isLogging) {
                    L.d("hasSelfPermission failed");
                }
                throw new SecurityException("Need permissions:" + Arrays.toString(PermissionUtil.permissions));
            }
            if (TextUtils.isEmpty(MapUtils.getImei())) {
                MapUtils.getImei(configuration.context);
            }
            if (TextUtils.isEmpty(MapUtils.getImsi())) {
                MapUtils.getImsi(configuration.context);
            }
            if (!checkSensor(configuration, handler)) {
                if (L.isLogging) {
                    L.d("WARNING:Senero check failed");
                }
                return;
            }
            if (TextUtils.isEmpty(str)) {
                str = "";
            }
            this.mBuildingID = str;
            this.mConfiguration = configuration;
            if (L.isLogging) {
                L.d("Initialize OnlineLocator with mConfiguration. Provider=" + getConfiguration().mLocationProvider);
            }
            if (getConfiguration().mPDRProvider == Configuration.PDRProvider.DEFAULT) {
                if (!PedProvider.getInstance().isInited()) {
                    int init = PedProvider.getInstance().init(this.mConfiguration.context);
                    if (init != 0) {
                        handler.sendEmptyMessage(init);
                    }
                } else if (L.isLogging) {
                    L.d("WARNING:PedProvider isInited");
                }
            } else if (L.isLogging) {
                L.d("getConfiguration().mPDRProvider=" + getConfiguration().mPDRProvider);
            }
            if (getConfiguration().isUsingWifi() && !WifiProvider.getInstance().isInited()) {
                int init2 = WifiProvider.getInstance().init(this.mConfiguration.context);
                if (init2 != 0) {
                    handler.sendEmptyMessage(init2);
                }
            } else if (WifiProvider.getInstance().isInited() && L.isLogging) {
                L.d("WARNING:WifiProvider has been Inited");
            }
            if (getConfiguration().isUsingWifi()) {
                WifiProvider.getInstance().setScanMode(0);
            }
            if (getConfiguration().isUsingBLE() && !BLEProvider.getInstance().isInited()) {
                int init3 = BLEProvider.getInstance().init(this.mConfiguration.context);
                if (init3 != 0) {
                    handler.sendEmptyMessage(init3);
                }
            } else if (getConfiguration().isUsingBLE() && L.isLogging) {
                L.d("WARNING:BLEProvider has been inited");
            }
            if (!TextUtils.isEmpty(getConfiguration().mSimulateFile)) {
                int init4 = FileDataProvider.getInstance().init(this.mConfiguration.context);
                if (init4 != 0) {
                    if (L.isLogging) {
                        L.d("WARNING:init Simulator failed");
                    }
                    handler.sendEmptyMessage(init4);
                }
                FileDataProvider.getInstance().setSimulatFile(this.mConfiguration.mSimulateFile);
            }
            HandlerThread handlerThread = new HandlerThread("OnlineLocationThread") { // from class: com.autonavi.indoor.onlinelocation.OnlineLocator.1
                @Override // android.os.HandlerThread
                public void onLooperPrepared() {
                    super.onLooperPrepared();
                    if (OnlineLocator.this.mLocationThread != null) {
                        Looper looper = OnlineLocator.this.mLocationThread.getLooper();
                        if (looper != null) {
                            OnlineLocator.this.i = new a(looper, OnlineLocator.this);
                            OnlineLocator.this.mIsInited = true;
                            OnlineLocator onlineLocator = OnlineLocator.this;
                            if (onlineLocator.e == null) {
                                onlineLocator.e = new b(OnlineLocator.this.mConfiguration, OnlineLocator.this.i);
                            }
                            handler.sendEmptyMessage(203);
                            if (PedProvider.getInstance().getSensorHandler() == null) {
                                PedProvider.getInstance().setSensorHandler(OnlineLocator.this.i);
                            }
                            if (L.isLogging) {
                                L.d("OnlineLocationThread prepared");
                                return;
                            }
                            return;
                        }
                        throw new RuntimeException("FATAL ERROR looper == null");
                    }
                    throw new RuntimeException("FATAL ERROR mLocationThread == null");
                }

                @Override // android.os.HandlerThread
                public boolean quit() {
                    OnlineLocator.this.mIsInited = false;
                    if (L.isLogging) {
                        L.d("OnlineLocationThread quit success");
                    }
                    return super.quit();
                }
            };
            this.mLocationThread = handlerThread;
            handlerThread.start();
            return;
        }
        throw new IllegalArgumentException("OnlineLocator mConfiguration can not be initialized with null");
    }

    public boolean isPaused() {
        return this.j;
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public boolean isPdrEnable() {
        return this.k == 2;
    }

    public void pause() {
        this.j = true;
        if (L.isLogging) {
            L.d("online pause");
        }
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public void recordLocationData(double d, double d2, int i) {
        checkInit();
        if (this.mIsLocating) {
            FileLogger fileLogger = this.l;
            if (fileLogger.isLogging) {
                fileLogger.d("pts:" + System.currentTimeMillis() + "," + d + "," + d2 + "," + i + ",1");
            }
        }
    }

    public void recordMessage(String str) {
        FileLogger fileLogger = this.l;
        if (fileLogger.isLogging) {
            fileLogger.d(str);
        }
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public void removeUpdates(Handler handler) {
        if (L.isLogging) {
            L.d("removeUpdates listener:" + handler + ", Handler count = " + this.mOutterHandlers.size());
        }
        if (!this.mOutterHandlers.contains(handler)) {
            if (L.isLogging) {
                L.d("removeUpdates listener doesn't exist.");
            }
        } else if (!isInited()) {
            if (L.isLogging) {
                L.d("onlinelocator has not been inited");
            }
        } else {
            synchronized (this) {
                this.mOutterHandlers.remove(handler);
                if (this.mOutterHandlers.isEmpty()) {
                    b();
                }
            }
        }
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public void requestLocationUpdates(Handler handler) {
        if (handler == null) {
            return;
        }
        if (!isInited()) {
            if (L.isLogging) {
                L.d("onlinelocator has not been inited");
                return;
            }
            return;
        }
        synchronized (this) {
            synchronized (this.mOutterHandlers) {
                if (!this.mOutterHandlers.contains(handler)) {
                    this.mOutterHandlers.add(handler);
                } else if (L.isLogging) {
                    L.d("Handler already exist");
                }
                if (this.mOutterHandlers.size() > 0 && !this.mIsLocating && !a() && L.isLogging) {
                    L.d("Failed to start OnlineLocation.");
                }
            }
        }
    }

    public void resume() {
        if (L.isLogging) {
            L.d("online resume");
        }
        if (this.j) {
            this.j = false;
            this.i.removeMessages(1200);
            this.i.sendEmptyMessageDelayed(1200, 2000L);
            if (isPdrEnable()) {
                return;
            }
            this.i.sendEmptyMessage(1218);
        }
    }

    @Override // com.autonavi.indoor.location.ILocationManager
    public void setPdr(int i, float f) {
        if (getConfiguration().mPDRProvider == Configuration.PDRProvider.DEFAULT) {
            if (L.isLogging) {
                L.d("Please configure PDRProvider first.");
            }
            return;
        }
        if (isLocating()) {
            MatStepData matStepData = new MatStepData(i, f, 0.0d, 0.0d, 0.0d, 1.0d, 0.0d, 0.0d, 0.0d, 0.0d, 0.0d, 0.0d, 0.7d, 0.0d, 0.0d, 0, 0.0d, 0.0d);
            matStepData.timestamp_ = System.currentTimeMillis();
            this.i.obtainMessage(111, matStepData).sendToTarget();
        } else if (L.isLogging) {
            L.d("isLocating()=" + isLocating());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void c() {
        JNIWrapper.c = 0;
        JNIWrapper.b = null;
        if (JNIWrapper.jniGetSendOnlineRequest(System.currentTimeMillis(), this.mBuildingID, isPdrEnable()) && JNIWrapper.b != null && JNIWrapper.c > 0) {
            if (L.isLogging) {
                L.d("JniOnlineRequest.length:" + JNIWrapper.c + " request.data.len:" + JNIWrapper.b.length);
            }
            b bVar = this.e;
            if (bVar != null) {
                bVar.a(this.mBuildingID, JNIWrapper.b);
            }
            this.mLastRequestBuffer = JNIWrapper.b;
            return;
        }
        if (L.isLogging) {
            L.d("jniGetSendOnlineRequest return invalid request buffer, pass");
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void d() {
        String str;
        int i;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.g < this.mConfiguration.mReportInterval) {
            return;
        }
        long j = this.m;
        if (j != 0 && currentTimeMillis - j > 10000 && this.q != this.n) {
            if (L.isLogging) {
                L.d("NetLocation out of date:" + this.m + ", " + (currentTimeMillis - this.m) + "lastStep=" + this.n + ", curStep=" + this.q);
            }
            this.d = null;
            return;
        }
        this.g = currentTimeMillis;
        JNIWrapper.jniGetLocateResult(currentTimeMillis);
        boolean z = false;
        if (L.isLogging) {
            str = String.format("AddStepAngle, step:%d angle:%.2f \nangle_nomag:%.2f error:%.2f", Integer.valueOf(this.q), Double.valueOf(this.r), Double.valueOf(this.s), Double.valueOf(this.t)) + "\nLastSuccessTime:" + this.m + "," + (currentTimeMillis - this.m) + "ms, lastPOS:" + this.o + ", LastStep:" + this.p;
            L.d(str);
            L.d("jniGetLocateResult: x=" + JNIWrapper.d + ", y=" + JNIWrapper.e + ", z=" + JNIWrapper.f);
        } else {
            str = null;
        }
        if (JNIWrapper.d >= -1000.0d && JNIWrapper.e >= -1000.0d && (i = JNIWrapper.f) >= -100 && i != 0) {
            LocationResult locationResult = new LocationResult();
            locationResult.x = JNIWrapper.d;
            locationResult.y = JNIWrapper.e;
            locationResult.z = JNIWrapper.f;
            locationResult.a = (float) this.r;
            locationResult.r = 2.0f;
            locationResult.bid = this.mBuildingID;
            if (L.isLogging) {
                L.d("going to publish result:" + JNIWrapper.d + ", " + JNIWrapper.e + ", " + this.r + ", " + locationResult.z + ", CurrentStep=" + this.q);
            }
            MessageHelper.publishLocationResult(this.mOutterHandlers, true, locationResult, str);
            this.d = locationResult;
            return;
        }
        int i2 = this.q;
        if (i2 != -1 && i2 == this.p) {
            z = true;
        }
        if (z && this.d != null) {
            if (L.isLogging) {
                L.d("going to publish result(using old result):" + this.d.x + ", " + this.d.y + ", " + this.d.z);
            }
            LocationResult locationResult2 = this.d;
            locationResult2.a = (float) this.r;
            MessageHelper.publishLocationResult(this.mOutterHandlers, true, locationResult2, str);
        }
        if (this.q != this.p) {
            if (L.isLogging) {
                L.d("clear lastReportResult. currentstep=" + this.q + ", lastStep" + this.p);
            }
            this.d = null;
        }
    }

    private void b() {
        checkInit();
        if (this.mIsLocating) {
            try {
                if (!TextUtils.isEmpty(getConfiguration().mSimulateFile)) {
                    FileDataProvider.getInstance().unregisterListener(this.i);
                }
                this.i.removeMessages(1200);
                this.i.removeMessages(1218);
                if (TextUtils.isEmpty(getConfiguration().mSimulateFile)) {
                    if (getConfiguration().isUsingWifi()) {
                        WifiProvider.getInstance().unregisterListener(this.i);
                    }
                    if (getConfiguration().isUsingBLE()) {
                        BLEProvider.getInstance().unregisterListener(this.i);
                    }
                    if (getConfiguration().mPDRProvider == Configuration.PDRProvider.DEFAULT) {
                        PedProvider.getInstance().unregisterListener(this.i);
                    }
                }
                this.mIsLocating = false;
                this.j = false;
                this.l.stop();
                if (L.isLogging) {
                    L.d("onlinelocator is stoped");
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    }

    private boolean a() {
        checkInit();
        if (this.mIsLocating) {
            if (L.isLogging) {
                L.d("locator is running, don't need to start again");
            }
            return true;
        }
        JNIWrapper.jniReset();
        String upperCase = MapUtils.encodeWifiMac(com.amap.location.common.a.f(this.mConfiguration.context)).toUpperCase();
        JNIWrapper.jniSetRequestHeader("IndoorLocation", "6.9", Build.MODEL, "Android" + Build.VERSION.SDK_INT, PackageHelper.getApplicationName(this.mConfiguration.context) + PackageHelper.getApplicationVersion(this.mConfiguration.context), "", MapUtils.getImei(), MapUtils.getImsi(), MapUtils.encodeMacLong(upperCase));
        if (L.isLogging) {
            L.d(Build.MODEL + ",Android " + Build.VERSION.RELEASE + "," + PackageHelper.getApplicationName(this.mConfiguration.context) + PackageHelper.getApplicationVersion(this.mConfiguration.context));
        }
        this.l.start(L.logalgoPath);
        FileLogger fileLogger = this.l;
        if (fileLogger.isLogging) {
            fileLogger.d("bID:" + this.mBuildingID);
        }
        this.a = 0;
        this.b = System.currentTimeMillis();
        this.m = 0L;
        this.n = -1;
        this.c = false;
        this.mLastRequestBuffer = null;
        try {
            if (!TextUtils.isEmpty(getConfiguration().mSimulateFile)) {
                FileDataProvider.getInstance().registerListener(this.i);
                FileDataProvider.getInstance().mEnablePdr = PedProvider.getInstance().getSensorType() != 0;
                this.k = PedProvider.getInstance().getSensorType();
            } else {
                if (getConfiguration().isUsingWifi()) {
                    WifiProvider.getInstance().registerListener(this.i);
                }
                if (getConfiguration().isUsingBLE()) {
                    BLEProvider.getInstance().registerListener(this.i);
                }
                if (getConfiguration().mPDRProvider == Configuration.PDRProvider.DEFAULT) {
                    int sensorType = PedProvider.getInstance().getSensorType();
                    this.k = sensorType;
                    if (sensorType == 0) {
                        if (L.isLogging) {
                            L.d("start JNI, 传感器缺失，算法中将禁掉PDR");
                        }
                        MessageHelper.publishMessage(this.mOutterHandlers, MessageCode.MSG_SENSOR_MISSING);
                    }
                    PedProvider.getInstance().registerListener(this.i);
                } else {
                    if (L.isLogging) {
                        L.d("getConfiguration().mPDRProvider=" + getConfiguration().mPDRProvider);
                    }
                    this.k = 2;
                }
            }
            this.mIsLocating = true;
            this.j = false;
            this.p = -1;
            this.q = -1;
            this.r = -1.0d;
            this.s = -1.0d;
            this.d = null;
            this.i.sendEmptyMessageDelayed(1200, 2000L);
            this.i.sendEmptyMessageDelayed(1218, 2000L);
            if (L.isLogging) {
                L.d("start");
            }
            return true;
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void a(Message message) {
        com.autonavi.indoor.onlinelocation.a aVar = (com.autonavi.indoor.onlinelocation.a) message.obj;
        if (aVar == null) {
            if (L.isLogging) {
                L.d("定位返回结果都是无效的，不能用来定位!");
                return;
            }
            return;
        }
        if (!Double.isNaN(aVar.a) && !Double.isNaN(aVar.b)) {
            this.m = System.currentTimeMillis();
            this.n = this.q;
            this.o = "LastSuccessPosition:" + aVar.a + "," + aVar.b;
            double d = aVar.k;
            this.t = d;
            JNIWrapper.jniAddOnlineResult(this.m, aVar.a, aVar.b, aVar.c, aVar.g, (double) aVar.e, aVar.i, aVar.j, aVar.h, d);
            if (L.isLogging) {
                L.d("NLPResponsed: " + aVar.l + ", x=" + aVar.a + ", y=" + aVar.b + ", z=" + aVar.c + ", step_length = " + aVar.g + ",zero_angle = " + aVar.h + ", angle_error=" + aVar.k + ", t = " + aVar.j);
            }
            FileLogger fileLogger = this.l;
            if (fileLogger.isLogging) {
                fileLogger.d("tp1:" + aVar.j + "," + aVar.a + "," + aVar.b + "," + aVar.c + ",0");
            }
            if (TextUtils.isEmpty(this.mBuildingID) && !TextUtils.isEmpty(aVar.l)) {
                MessageHelper.publishMessage(this.mOutterHandlers, MessageCode.MSG_ONLINE_BUILDING_LOCATED, aVar.l);
                this.mBuildingID = aVar.l;
                if (L.isLogging) {
                    L.d("MSG_ONLINE_BUILDING_LOCATED");
                    return;
                }
                return;
            }
            if (TextUtils.isEmpty(this.mBuildingID) || TextUtils.isEmpty(aVar.l) || this.mBuildingID.equals(aVar.l)) {
                return;
            }
            MessageHelper.publishMessage(this.mOutterHandlers, MessageCode.MSG_ONLINE_BUILDING_CHANGED, aVar.l);
            this.mBuildingID = aVar.l;
            if (L.isLogging) {
                L.d("MSG_ONLINE_BUILDING_CHANGED");
                return;
            }
            return;
        }
        if (L.isLogging) {
            L.d("online addRequest failed, server return NaN, nan");
        }
    }
}
