package com.autonavi.indoor.onlinelocation;

import android.os.Handler;
import android.os.Message;
import android.util.Base64;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.pdr.ErrorCode;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.ProtocolHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.json.JSONObject;

/* compiled from: NetworkRequestThread.java */
/* loaded from: classes.dex */
public class b extends Thread {
    public static a c = new a("SHUTDOWN", null);
    public Configuration b;
    public volatile boolean e;
    public volatile boolean f;
    public Handler g;
    public BlockingQueue<a> d = new ArrayBlockingQueue(1);
    public boolean a = false;

    /* compiled from: NetworkRequestThread.java */
    /* loaded from: classes.dex */
    public static class a {
        public String a;
        public byte[] b;

        public a(String str, byte[] bArr) {
            this.a = str;
            this.b = bArr;
        }
    }

    public b(Configuration configuration, Handler handler) {
        this.g = null;
        start();
        this.g = handler;
        this.b = configuration;
    }

    public void a(String str, byte[] bArr) {
        if (!this.e && !this.f) {
            a aVar = new a(str, bArr);
            while (!this.d.offer(aVar)) {
                a poll = this.d.poll();
                if (L.isLogging) {
                    L.d("queen is full, poll one" + poll.b);
                }
            }
            return;
        }
        if (L.isLogging) {
            L.d("BuildingLocateThread has been stoped.");
        }
    }

    @Override // java.lang.Thread, java.lang.Runnable
    public void run() {
        while (true) {
            try {
                if (this.e) {
                    if (L.isLogging) {
                        L.d("Thread is shuttingDown.");
                    }
                    this.d.clear();
                } else {
                    a take = this.d.take();
                    if (take == c) {
                        if (L.isLogging) {
                            L.d("consum poison pill");
                        }
                    } else {
                        a(take);
                    }
                }
            } catch (InterruptedException unused) {
            } catch (Throwable th) {
                this.f = true;
                throw th;
            }
        }
        if (L.isLogging) {
            L.d("end of run");
        }
        this.g = null;
        this.f = true;
    }

    public void a() throws InterruptedException {
        if (this.e) {
            if (L.isLogging) {
                L.d("Thread is shuttingDown...");
                return;
            }
            return;
        }
        this.e = true;
        this.a = false;
        if (L.isLogging) {
            L.d("shutdown");
        }
        while (!this.d.offer(c)) {
            a poll = this.d.poll();
            if (L.isLogging) {
                L.d("queen is full, clear:" + poll.b);
            }
        }
        if (L.isLogging) {
            L.d("stop BuildingLocateThread");
        }
    }

    public boolean a(Handler handler) {
        return (handler == null || handler.getLooper() == null || handler.getLooper().getThread() == null || !handler.getLooper().getThread().isAlive()) ? false : true;
    }

    public void a(a aVar) {
        int responseCode;
        try {
            String url = this.b.getUrl();
            byte[] bArr = aVar.b;
            byte[] amapEncode = MapUtils.amapEncode(bArr);
            if (amapEncode != null) {
                if (L.isLogging) {
                    L.d("Request encryptData is null");
                }
                bArr = amapEncode;
            }
            if (L.isLogging) {
                L.d("Request " + url + ", buffer.length=" + bArr.length);
            }
            if (L.isLogging) {
                L.d("Request body" + Base64.encodeToString(bArr, 0));
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection) new URL(url).openConnection();
            try {
                httpURLConnection.setReadTimeout(10000);
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                if (this.b.mServerType == Configuration.ServerType.SERVER_LBS) {
                    ProtocolHelper.setLBSHead(httpURLConnection, this.b, url);
                }
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write(bArr);
                outputStream.close();
                httpURLConnection.connect();
                responseCode = httpURLConnection.getResponseCode();
            } finally {
                try {
                } finally {
                }
            }
            if (responseCode != 200) {
                httpURLConnection.disconnect();
                a(MessageCode.MSG_SERVER_ERROR, "ResponseCode=" + responseCode);
                if (L.isLogging) {
                    L.d("服务器建立连接失败，返回值错误code：" + responseCode);
                }
                return;
            }
            httpURLConnection.getContentLength();
            String contentType = httpURLConnection.getContentType();
            if (L.isLogging) {
                L.d("ResponseMessage=" + httpURLConnection.getResponseMessage() + ", ContentType=" + contentType);
            }
            if (contentType.startsWith("application/json")) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while (true) {
                    String readLine = bufferedReader.readLine();
                    if (readLine == null) {
                        break;
                    }
                    sb.append(readLine + "\n");
                }
                bufferedReader.close();
                if (L.isLogging) {
                    L.d(sb.toString());
                }
                JSONObject jSONObject = new JSONObject(sb.toString());
                if (jSONObject.has("status")) {
                    String string = jSONObject.getString("status");
                    if (L.isLogging) {
                        L.d("json status:" + string);
                    }
                    String string2 = jSONObject.getString("info");
                    if (L.isLogging) {
                        L.d("json info:" + string2);
                    }
                    int i = MessageCode.MSG_LBS_ERROR;
                    if (string2.equals("OK")) {
                        if (L.isLogging) {
                            L.d("正常");
                        }
                    } else if (string2.equals("INVALID_USER_KEY")) {
                        i = MessageCode.MSG_LBS_INVALID_USER_KEY;
                        if (L.isLogging) {
                            L.d("用户key非法或过期");
                        }
                    } else if (string2.equals("SERVICE_NOT_AVAILBALE")) {
                        i = MessageCode.MSG_LBS_SERVICE_NOT_AVAILBALE;
                        if (L.isLogging) {
                            L.d("请求服务不存在");
                        }
                    } else if (string2.equals("SERVICE_RESPONSE_ERROR")) {
                        i = MessageCode.MSG_LBS_SERVICE_RESPONSE_ERROR;
                        if (L.isLogging) {
                            L.d("请求服务响应错误");
                        }
                    } else if (string2.equals("INSUFFICIENT_PRIVILEGES")) {
                        i = MessageCode.MSG_LBS_INSUFFICIENT_PRIVILEGES;
                        if (L.isLogging) {
                            L.d("无权限访问此服务");
                        }
                    } else if (string2.equals("OVER_QUOTA")) {
                        i = MessageCode.MSG_LBS_OVER_QUOTA;
                        if (L.isLogging) {
                            L.d("请求超出配额");
                        }
                    } else if (string2.equals("INVALID_PARAMS")) {
                        i = MessageCode.MSG_LBS_INVALID_PARAMS;
                        if (L.isLogging) {
                            L.d("请求参数非法");
                        }
                    } else if (string2.equals("UNKNOWN_ERROR")) {
                        i = MessageCode.MSG_LBS_UNKNOWN_ERROR;
                        if (L.isLogging) {
                            L.d("未知错误");
                        }
                    }
                    a(i);
                } else if (jSONObject.has("result")) {
                    String string3 = jSONObject.getString("result");
                    if (L.isLogging) {
                        L.d("json result:" + string3);
                    }
                    if (string3.equals(Config.FALSE)) {
                        a(MessageCode.MSG_SERVER_ERROR, jSONObject.getString("message"));
                    }
                }
                if (L.isLogging) {
                    L.d(httpURLConnection.getContent().toString());
                }
            } else {
                InputStream inputStream = httpURLConnection.getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR);
                byte[] bArr2 = new byte[512];
                while (true) {
                    int read = inputStream.read(bArr2);
                    if (read == -1) {
                        break;
                    } else {
                        byteArrayOutputStream.write(bArr2, 0, read);
                    }
                }
                inputStream.close();
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                if (L.isLogging) {
                    L.d(byteArray);
                }
                a(byteArray);
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d("打开连接异常(在线定位)：" + th);
            }
            a(212);
        }
    }

    public void a(int i, Object obj) {
        try {
            if (a(this.g)) {
                Message obtain = Message.obtain(this.g, i);
                obtain.obj = obj;
                this.g.sendMessage(obtain);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d("sendMessage to handler failed:" + e.toString());
            }
        }
    }

    public void a(int i) {
        try {
            if (a(this.g)) {
                this.g.sendEmptyMessage(i);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d("sendMessage to handler failed:" + e.toString());
            }
        }
    }

    private void a(byte[] bArr) {
        com.autonavi.indoor.onlinelocation.a aVar;
        try {
        } catch (Throwable th) {
            th = th;
            aVar = null;
        }
        if (MapUtils.isEmpty(bArr)) {
            if (L.isLogging) {
                L.d(bArr);
            }
            a(MessageCode.MSG_SERVER_ERROR, "response buffer is empty");
            return;
        }
        ByteBuffer wrap = ByteBuffer.wrap(bArr);
        short s = wrap.getShort();
        if (s != 22) {
            if (L.isLogging) {
                L.d("action_code:" + ((int) s));
            }
            a(MessageCode.MSG_SERVER_ERROR, "invalid action code");
            return;
        }
        int i = wrap.getInt();
        long j = wrap.getLong();
        int i2 = wrap.getInt();
        if (i2 != 0) {
            if (L.isLogging) {
                L.d("status_code:" + i2);
            }
            a(MessageCode.MSG_SERVER_ERROR, "status code error");
            return;
        }
        int i3 = wrap.getInt();
        byte b = wrap.get();
        byte b2 = wrap.get();
        if (L.isLogging) {
            L.d("decodeLocateResponse: action_code=" + ((int) s) + ",action_version=" + i + ", status_code=" + i2 + ",len=" + i3 + ",LocationType(0GPS 1Wifi 2BLE)=" + ((int) b) + ",Returncode=" + ((int) b2));
        }
        if (b2 < 0) {
            if (L.isLogging) {
                L.d("returncode:" + ((int) b2));
            }
            String str = "error return code:" + ((int) b2);
            if (str != null) {
                a(MessageCode.MSG_SERVER_ERROR, str);
                return;
            }
            return;
        }
        String string = MapUtils.getString(wrap);
        if (wrap.get() > 0) {
            double d = wrap.getDouble();
            if (d >= -180.0d && d <= 180.0d) {
                double d2 = wrap.getDouble();
                if (d2 >= -180.0d && d2 <= 180.0d) {
                    if (d == 0.0d && d2 == 0.0d) {
                        if (L.isLogging) {
                            L.d("invalid x=0,y=0");
                        }
                        a(MessageCode.MSG_SERVER_ERROR, "invalid x, y, both are zero.");
                        return;
                    }
                    com.autonavi.indoor.onlinelocation.a aVar2 = new com.autonavi.indoor.onlinelocation.a();
                    try {
                        aVar2.a = d;
                        aVar2.b = d2;
                        aVar2.c = wrap.get();
                        aVar2.d = wrap.get();
                        aVar2.g = wrap.getFloat();
                        aVar2.h = wrap.getFloat();
                        aVar2.i = wrap.getFloat();
                        aVar2.k = wrap.getFloat();
                        aVar2.j = j;
                        aVar2.l = string;
                        aVar = aVar2;
                    } catch (Throwable th2) {
                        th = th2;
                        aVar = aVar2;
                        try {
                            if (L.isLogging) {
                                L.d(th);
                            }
                            if (aVar == null) {
                                return;
                            }
                            a(MessageCode.MSG_NLP_RESPONSED, aVar);
                        } catch (Throwable th3) {
                            if (aVar != null) {
                                a(MessageCode.MSG_NLP_RESPONSED, aVar);
                            }
                            throw th3;
                        }
                    }
                }
                if (L.isLogging) {
                    L.d("invalid y:" + d2);
                }
                String str2 = "invalid y:" + d2;
                if (str2 != null) {
                    a(MessageCode.MSG_SERVER_ERROR, str2);
                    return;
                }
                return;
            }
            if (L.isLogging) {
                L.d("invalid x:" + d);
            }
            String str3 = "invalid x:" + d;
            if (str3 != null) {
                a(MessageCode.MSG_SERVER_ERROR, str3);
                return;
            }
            return;
        }
        aVar = null;
        if (aVar == null) {
            return;
        }
        a(MessageCode.MSG_NLP_RESPONSED, aVar);
    }
}
