package com.autonavi.indoor.pdr;

/* loaded from: classes.dex */
public class ErrorCode extends Error {
    public static final int SENSOR_ACC_TIMESTAMP_ERROR = 1024;
    public static final int SENSOR_ACC_UN_AVAILABLE = 1;
    public static final int SENSOR_ACC_UPDATE_ERROR = 32;
    public static final int SENSOR_GRAVITY_TIMESTAMP_ERROR = 2048;
    public static final int SENSOR_GRAVITY_UN_AVAILABLE = 2;
    public static final int SENSOR_GRAVITY_UPDATE_ERROR = 64;
    public static final int SENSOR_GYRO_TIMESTAMP_ERROR = 4096;
    public static final int SENSOR_GYRO_UN_AVAILABLE = 4;
    public static final int SENSOR_GYRO_UPDATE_ERROR = 128;
    public static final int SENSOR_MAGNETIC_TIMESTAMP_ERROR = 8192;
    public static final int SENSOR_MAGNETIC_UN_AVAILABLE = 8;
    public static final int SENSOR_MAGNETIC_UPDATE_ERROR = 256;
    public static final int SENSOR_PRESS_TIMESTAMP_ERROR = 16384;
    public static final int SENSOR_PRESS_UN_AVAILABLE = 16;
    public static final int SENSOR_PRESS_UPDATE_ERROR = 512;

    public ErrorCode(String str) {
        super(str);
    }

    public static String getErrorString(long j) {
        long j2 = 1 & j;
        String str = "";
        if (j2 != 0) {
            str = "加速度计不可用,";
        }
        long j3 = 2 & j;
        if (j3 != 0) {
            str = str + "重力计不可用,";
        }
        if (j2 != 0 && j3 != 0) {
            str = str + " 定位方向会不准确";
        }
        long j4 = 4 & j;
        if (j4 != 0) {
            str = str + "陀螺仪不可用,";
        }
        long j5 = 8 & j;
        if (j5 != 0) {
            str = str + "地磁计不可用,";
        }
        if (j4 != 0 && j5 != 0) {
            str = str + "定位结果可能会存在跳点现象";
        }
        if ((16 & j) != 0) {
            str = str + "气压计不可用，楼层判断可能不准确。";
        }
        long j6 = 32 & j;
        if (j6 != 0) {
            str = str + "加速度计更新错误，监测到了此传感器，但是一段时间内没有接收到回调数据.";
        }
        long j7 = 64 & j;
        if (j7 != 0) {
            str = str + "重力计更新错误监测到了此传感器，但是一段时间内没有接收到回调数据.";
        }
        if (j6 != 0 && j7 != 0) {
            str = str + " 定位方向会不准确";
        }
        long j8 = 128 & j;
        if (j8 != 0) {
            str = str + "陀螺仪更新错误监测到了此传感器，但是一段时间内没有接收到回调数据.";
        }
        long j9 = 256 & j;
        if (j9 != 0) {
            str = str + "地磁更新错误监测到了此传感器，但是一段时间内没有接收到回调数据.";
        }
        if (j8 != 0 && j9 != 0) {
            str = str + "定位结果可能会存在跳点现象";
        }
        if ((512 & j) != 0) {
            str = str + "气压计更新错误监测到了此传感器，但是一段时间内没有接收到回调数据.，楼层判断可能不准确。";
        }
        if ((1024 & j) != 0) {
            str = str + "时间戳错误，传感器陀螺仪或磁传感器的时间戳不在同一维度，将用系统时间代替，最后角度精度可能下降";
        }
        if ((2048 & j) != 0) {
            str = str + "时间戳错误陀螺仪或磁传感器的时间戳不在同一维度，将用系统时间代替，最后角度精度可能下降";
        }
        if ((4096 & j) != 0) {
            str = str + "时间戳错误";
        }
        if ((8192 & j) != 0) {
            str = str + "时间戳错误";
        }
        if ((j & 16384) == 0) {
            return str;
        }
        return str + "时间戳错误";
    }
}
