package com.autonavi.indoor.pdr;

import com.autonavi.indoor.util.L;

/* loaded from: classes.dex */
public class JNIWrapper {
    public static double mAngleNoMag;
    public static double mAngleYaw;
    public static double mDeltaX;
    public static double mDeltaY;
    public static double mDeltaZ;
    public static double mDx;
    public static double mDy;
    public static double mDz;
    public static double mFrequency;
    public static double mMagCaliResultX;
    public static double mMagCaliResultY;
    public static double mMagCaliResultZ;
    public static int mMoveDirection;
    public static double mMoveStateScore;
    public static double mQ1;
    public static double mQ2;
    public static double mQ3;
    public static double mQ4;
    public static double mStepLength;
    public static int mStepNum;
    public static double mV;
    public static double mX;
    public static double mY;
    public static double mZ;

    static {
        try {
            if (L.isLogging) {
                L.d("System.loadLibrary:indoorpdr6.9  isSilent=" + L.isSilent());
            }
            System.loadLibrary("indoorpdr6.9");
            jniSetDebug(false);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public static native boolean jniChangeCoordinate2Ground(float f, float f2, float f3, float f4, float f5, float f6, float f7);

    public static void jniChangeCoordinate2GroundCallback(double d, double d2, double d3) {
        mX = d;
        mY = d2;
        mZ = d3;
    }

    public static native int jniDestroy();

    public static void jniDirectionStateCallback(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        mQ1 = d;
        mQ2 = d2;
        mQ3 = d3;
        mQ4 = d4;
        mDx = d5;
        mDy = d6;
        mDz = d7;
        mDeltaX = d8;
        mDeltaY = d9;
        mDeltaZ = d10;
    }

    public static native String jniEncodeURL(String str);

    public static native boolean jniGetMag8Param10Cali(float f, float f2, float f3);

    public static native boolean jniGetStepData();

    public static native String jniLocGetDebugString();

    public static native boolean jniLocGetDirectionState();

    public static native float jniLocGetFilterSquareAngle();

    public static void jniMagCaliResultCallback(double d, double d2, double d3) {
        mMagCaliResultX = d;
        mMagCaliResultY = d2;
        mMagCaliResultZ = d3;
    }

    public static native int jniPDRStart(String str);

    public static native int jniPDRStop();

    public static native boolean jniSetDebug(boolean z);

    public static void jniStepDataCallback(int i, double d, double d2, double d3, int i2, double d4, double d5, double d6) {
        mStepNum = i;
        mFrequency = d;
        mV = d2;
        mStepLength = d3;
        mMoveDirection = i2;
        mAngleYaw = d4;
        mAngleNoMag = d5;
        mMoveStateScore = d6;
    }

    public static native int jniUpdateAcceleration(long j, float f, float f2, float f3, float f4, float f5, float f6);

    public static native int jniUpdateGravity(long j, float f, float f2, float f3);

    public static native int jniUpdateGyro(long j, float f, float f2, float f3);

    public static native int jniUpdateMagnetic(long j, float f, float f2, float f3);
}
