package com.autonavi.indoor.pdr;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Message;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.indoor.entity.PressData;
import com.autonavi.indoor.provider.IProvider;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MessageHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/* loaded from: classes.dex */
public class PedProvider extends IProvider implements SensorEventListener {
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final long SENSOR_TIMESTAMP_ERROR_TIME = 4000;
    public static final long SENSOR_UPDATE_ERROR_TIME = 1000;
    public static volatile PedProvider instance;
    public float mCurrentPressure;
    public long mLastStepUpdateSysTime;
    public boolean mEnablePDR = true;
    public float mOrientation = 0.0f;
    public float[] mat_datas_ = new float[3];
    public float[] gra_datas_ = new float[3];
    public boolean enable_mat_filter_ = false;
    public boolean mIsAccelerationAvailable = false;
    public boolean mIsGravityAvailable = false;
    public boolean mIsGyroAvailable = false;
    public boolean mIsMagneticAvailable = false;
    public boolean mIsPressureAvailable = false;
    public boolean mAccTimeStampUsed = true;
    public boolean mGravityTimeStampUsed = true;
    public boolean mGyroTimeStampUsed = false;
    public boolean mMagneticTimeStampUsed = false;
    public boolean mAccUpdateWork = false;
    public boolean mGravityUpdateWork = false;
    public boolean mGyroUpdateWork = false;
    public boolean mMagneticUpdateWork = false;
    public long mAccUpdateSysTime = -1;
    public long mGravityUpdateSysTime = -1;
    public long mGyroUpdateSysTime = -1;
    public long mMagneticUpdateSysTime = -1;
    public long mGravitySensorTimestamp = -1;
    public long mGyroSensorTimestamp = -1;
    public long mMagneticSensorTimestamp = -1;
    public final long INTERVAL_UI = 55;
    public final long INTERVAL_NORMAL = 195;
    public long mLastAccTime = -1;
    public long mLastGraTime = -1;
    public long mLastGyrTime = -1;
    public long mLastMagTime = -1;
    public long start_timeInMillis = 0;
    public boolean mIsPublishOther = false;
    public float[] rotationMatrix = new float[16];
    public MatStepData mLastMatStepRecord = null;
    public Handler mInnerHandler = null;
    public Handler mSensorHandler = null;
    public SensorManager mSensorManager = null;
    public final int mPedReportInterval = SecExceptionCode.SEC_ERROR_STA_STORE;

    /* loaded from: classes.dex */
    public static class InnerHandler extends Handler {
        public final WeakReference<PedProvider> mParent;

        public InnerHandler(PedProvider pedProvider) {
            this.mParent = new WeakReference<>(pedProvider);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            PedProvider pedProvider = this.mParent.get();
            if (pedProvider == null) {
                return;
            }
            try {
                if (message.what == 1200) {
                    MessageHelper.publishMessage((ArrayList<Handler>) pedProvider.mOutterHandlers, 100, new PressData(System.currentTimeMillis(), pedProvider.mCurrentPressure));
                    if (pedProvider.mInnerHandler != null) {
                        pedProvider.mInnerHandler.sendEmptyMessageDelayed(1200, 100L);
                    }
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    }

    private void checkError(long j) {
        this.mAccUpdateWork = j - this.mAccUpdateSysTime <= 1000;
        this.mGyroUpdateWork = j - this.mGyroUpdateSysTime <= 1000;
        this.mGravityUpdateWork = j - this.mGravityUpdateSysTime <= 1000;
        this.mMagneticUpdateWork = j - this.mMagneticUpdateSysTime <= 1000;
    }

    public static PedProvider getInstance() {
        if (instance == null) {
            synchronized (PedProvider.class) {
                if (instance == null) {
                    instance = new PedProvider();
                }
            }
        }
        return instance;
    }

    private void updatePressure(SensorEvent sensorEvent) {
        if (sensorEvent == null) {
            return;
        }
        this.mCurrentPressure = sensorEvent.values[0];
        if (this.mEnablePDR || this.mInnerHandler != null) {
            return;
        }
        InnerHandler innerHandler = new InnerHandler(this);
        this.mInnerHandler = innerHandler;
        innerHandler.sendEmptyMessage(1200);
    }

    private void updateStep(long j) {
        if (this.mEnablePDR && j - this.mLastStepUpdateSysTime >= 200) {
            this.mLastStepUpdateSysTime = j;
            JNIWrapper.jniGetStepData();
            float jniLocGetFilterSquareAngle = JNIWrapper.jniLocGetFilterSquareAngle();
            if (jniLocGetFilterSquareAngle == 3600.0f) {
                float[] fArr = new float[3];
                SensorManager.getRotationMatrix(this.rotationMatrix, null, this.gra_datas_, this.mat_datas_);
                SensorManager.getOrientation(this.rotationMatrix, fArr);
                double d = fArr[0] * 180.0f;
                Double.isNaN(d);
                jniLocGetFilterSquareAngle = (float) (d / 3.141592653589793d);
            }
            if (!this.mIsGyroAvailable) {
                jniLocGetFilterSquareAngle = this.mOrientation;
            }
            synchronized (this) {
                JNIWrapper.jniGetMag8Param10Cali(this.mat_datas_[0], this.mat_datas_[1], this.mat_datas_[2]);
                JNIWrapper.jniLocGetDirectionState();
                if (this.mIsPublishOther) {
                    MessageHelper.publishMessage(this.mOutterHandlers, 105, new JniMagCaliResult(this.mat_datas_[0], this.mat_datas_[1], this.mat_datas_[2]));
                }
                if (this.mLastMatStepRecord == null) {
                    MatStepData matStepData = new MatStepData(JNIWrapper.mStepNum, JNIWrapper.mAngleYaw, JNIWrapper.mMagCaliResultX, JNIWrapper.mMagCaliResultY, JNIWrapper.mMagCaliResultZ, JNIWrapper.mQ1, JNIWrapper.mQ2, JNIWrapper.mQ3, JNIWrapper.mQ4, JNIWrapper.mDeltaX, JNIWrapper.mDeltaY, JNIWrapper.mDeltaZ, JNIWrapper.mStepLength, JNIWrapper.mFrequency, JNIWrapper.mV, JNIWrapper.mMoveDirection, JNIWrapper.mAngleNoMag, JNIWrapper.mMoveStateScore);
                    this.mLastMatStepRecord = matStepData;
                    matStepData.timestamp_ = j;
                    matStepData.showangle = jniLocGetFilterSquareAngle;
                    matStepData.pressure = this.mCurrentPressure;
                } else if (this.mLastMatStepRecord.step_ == JNIWrapper.mStepNum) {
                    if (j - this.mLastMatStepRecord.timestamp_ < 2000) {
                        this.mLastMatStepRecord.AddMatData(JNIWrapper.mMagCaliResultX, JNIWrapper.mMagCaliResultY, JNIWrapper.mMagCaliResultZ, JNIWrapper.mQ1, JNIWrapper.mQ2, JNIWrapper.mQ3, JNIWrapper.mQ4, JNIWrapper.mDeltaX, JNIWrapper.mDeltaY, JNIWrapper.mDeltaZ);
                    } else {
                        this.mLastMatStepRecord.showangle = jniLocGetFilterSquareAngle;
                        this.mLastMatStepRecord.pressure = this.mCurrentPressure;
                        MessageHelper.publishMessage(this.mOutterHandlers, 111, this.mLastMatStepRecord);
                        this.mLastMatStepRecord.update(JNIWrapper.mStepNum, JNIWrapper.mAngleYaw, JNIWrapper.mMagCaliResultX, JNIWrapper.mMagCaliResultY, JNIWrapper.mMagCaliResultZ, JNIWrapper.mQ1, JNIWrapper.mQ2, JNIWrapper.mQ3, JNIWrapper.mQ4, JNIWrapper.mDeltaX, JNIWrapper.mDeltaY, JNIWrapper.mDeltaZ, JNIWrapper.mStepLength, JNIWrapper.mFrequency, JNIWrapper.mV, JNIWrapper.mMoveDirection, JNIWrapper.mAngleNoMag, JNIWrapper.mMoveStateScore);
                        this.mLastMatStepRecord.timestamp_ = j;
                    }
                } else if (this.mLastMatStepRecord.step_ != JNIWrapper.mStepNum) {
                    this.mLastMatStepRecord.showangle = jniLocGetFilterSquareAngle;
                    this.mLastMatStepRecord.pressure = this.mCurrentPressure;
                    MessageHelper.publishMessage(this.mOutterHandlers, 111, this.mLastMatStepRecord);
                    this.mLastMatStepRecord.update(JNIWrapper.mStepNum, JNIWrapper.mAngleYaw, JNIWrapper.mMagCaliResultX, JNIWrapper.mMagCaliResultY, JNIWrapper.mMagCaliResultZ, JNIWrapper.mQ1, JNIWrapper.mQ2, JNIWrapper.mQ3, JNIWrapper.mQ4, JNIWrapper.mDeltaX, JNIWrapper.mDeltaY, JNIWrapper.mDeltaZ, JNIWrapper.mStepLength, JNIWrapper.mFrequency, JNIWrapper.mV, JNIWrapper.mMoveDirection, JNIWrapper.mAngleNoMag, JNIWrapper.mMoveStateScore);
                    this.mLastMatStepRecord.timestamp_ = j;
                }
            }
        }
    }

    public void enablePdr(boolean z) {
        if (L.isLogging) {
            L.d("enablePdr:" + z);
        }
        this.mEnablePDR = z;
    }

    public String getDebugMessage() {
        return JNIWrapper.jniLocGetDebugString();
    }

    public long getErrorCode() {
        long j = !this.mIsAccelerationAvailable ? 1L : 0L;
        if (!this.mIsGravityAvailable) {
            j |= 2;
        }
        if (!this.mIsGyroAvailable) {
            j |= 4;
        }
        if (!this.mIsMagneticAvailable) {
            j |= 8;
        }
        if (!this.mIsPressureAvailable) {
            j |= 16;
        }
        if (System.currentTimeMillis() - this.start_timeInMillis <= 2000) {
            return j;
        }
        if (!this.mAccUpdateWork) {
            j |= 32;
        }
        if (!this.mGravityUpdateWork) {
            j |= 64;
        }
        if (!this.mGyroUpdateWork) {
            j |= 128;
        }
        if (!this.mMagneticUpdateWork) {
            j |= 256;
        }
        if (!this.mAccTimeStampUsed) {
            j |= 1024;
        }
        if (!this.mGravityTimeStampUsed) {
            j |= 2048;
        }
        if (!this.mGyroTimeStampUsed) {
            j |= 4096;
        }
        return !this.mMagneticTimeStampUsed ? j | 8192 : j;
    }

    public float getLastPressure() {
        return this.mCurrentPressure;
    }

    public float getOrientation() {
        return this.mOrientation;
    }

    public Handler getSensorHandler() {
        return this.mSensorHandler;
    }

    public int getSensorType() {
        checkConfiguration();
        int i = 0;
        if (!this.mEnablePDR) {
            return 0;
        }
        if (this.mSensorManager.getDefaultSensor(1) != null) {
            this.mIsAccelerationAvailable = true;
        }
        if (this.mSensorManager.getDefaultSensor(2) != null) {
            this.mIsMagneticAvailable = true;
        }
        if (this.mIsAccelerationAvailable && this.mIsMagneticAvailable) {
            if (this.mSensorManager.getDefaultSensor(4) != null) {
                this.enable_mat_filter_ = true;
                this.mIsGyroAvailable = true;
                i = 2;
            } else {
                i = 1;
            }
        }
        if (L.isLogging) {
            L.d("SensorTypep[0(None),2(All)]:" + i);
        }
        return i;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public synchronized int init(Context context) {
        if (context != null) {
            if (this.mContext == null) {
                if (L.isLogging) {
                    L.d("Initialize PedProvider with mContext");
                }
                this.mContext = context;
                this.mLastStepUpdateSysTime = System.currentTimeMillis();
                try {
                    this.mSensorManager = (SensorManager) context.getSystemService("sensor");
                } catch (Throwable th) {
                    if (L.isLogging) {
                        L.d("Can't getSystemService of SENSOR_SERVICE, PED not work!");
                    }
                    if (L.isLogging) {
                        L.d(th);
                    }
                    this.mSensorManager = null;
                    throw th;
                }
            } else if (L.isLogging) {
                L.d("Try to initialize PedProvider which had already been initialized before. To re-init PedProvider with new mConfiguration call PedProvider.destroy() at first.");
            }
        } else {
            throw new IllegalArgumentException("PedProvider context can not be initialized with null");
        }
        return 0;
    }

    public boolean isPdrEnabled() {
        return this.mEnablePDR;
    }

    public boolean isPressureAvailable() {
        return this.mIsPressureAvailable;
    }

    @Override // android.hardware.SensorEventListener
    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    @Override // android.hardware.SensorEventListener
    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.mIsListening) {
            long j = sensorEvent.timestamp / 1000000;
            long currentTimeMillis = System.currentTimeMillis();
            int type = sensorEvent.sensor.getType();
            if (type == 1) {
                this.mAccUpdateSysTime = currentTimeMillis;
                float[] fArr = sensorEvent.values;
                float f = fArr[0];
                float[] fArr2 = this.rotationMatrix;
                JNIWrapper.jniUpdateAcceleration(j, f - (fArr2[8] * 9.80665f), fArr[1] - (fArr2[9] * 9.80665f), fArr[2] - (fArr2[10] * 9.80665f), fArr[0], fArr[1], fArr[2]);
                updateStep(currentTimeMillis);
                checkError(currentTimeMillis);
                if (this.mGravityUpdateWork && this.mIsGravityAvailable) {
                    return;
                }
                boolean z = Math.abs(currentTimeMillis - j) <= SENSOR_TIMESTAMP_ERROR_TIME;
                this.mGravityTimeStampUsed = z;
                if (!this.mGyroTimeStampUsed || !this.mMagneticTimeStampUsed || !z) {
                    j = currentTimeMillis;
                }
                long j2 = this.mLastAccTime;
                if (j <= j2 || j - j2 >= 55) {
                    this.mLastAccTime = j;
                    float[] fArr3 = sensorEvent.values;
                    JNIWrapper.jniUpdateGravity(j, fArr3[0], fArr3[1], fArr3[2]);
                    float[] fArr4 = this.gra_datas_;
                    float[] fArr5 = sensorEvent.values;
                    fArr4[0] = fArr5[0];
                    fArr4[1] = fArr5[1];
                    fArr4[2] = fArr5[2];
                    return;
                }
                return;
            }
            if (type == 2) {
                this.mMagneticSensorTimestamp = j;
                this.mMagneticUpdateSysTime = currentTimeMillis;
                boolean z2 = Math.abs(j - this.mGyroSensorTimestamp) <= SENSOR_TIMESTAMP_ERROR_TIME;
                this.mMagneticTimeStampUsed = z2;
                if (!this.mGyroTimeStampUsed || !z2 || !this.mGravityTimeStampUsed) {
                    j = currentTimeMillis;
                }
                long j3 = this.mLastMagTime;
                if (j <= j3 || j - j3 >= 195) {
                    this.mLastMagTime = j;
                    checkError(currentTimeMillis);
                    if (this.mGyroUpdateWork && this.mIsGyroAvailable) {
                        float[] fArr6 = sensorEvent.values;
                        JNIWrapper.jniUpdateMagnetic(j, fArr6[0], fArr6[1], fArr6[2]);
                    }
                    float[] fArr7 = this.mat_datas_;
                    float[] fArr8 = sensorEvent.values;
                    fArr7[0] = fArr8[0];
                    fArr7[1] = fArr8[1];
                    fArr7[2] = fArr8[2];
                    return;
                }
                return;
            }
            if (type == 3) {
                this.mOrientation = sensorEvent.values[0];
                return;
            }
            if (type == 4) {
                this.mGyroSensorTimestamp = j;
                this.mGyroUpdateSysTime = currentTimeMillis;
                boolean z3 = Math.abs(this.mMagneticSensorTimestamp - j) <= SENSOR_TIMESTAMP_ERROR_TIME;
                this.mGyroTimeStampUsed = z3;
                if (!z3 || !this.mMagneticTimeStampUsed || !this.mGravityTimeStampUsed) {
                    j = currentTimeMillis;
                }
                long j4 = this.mLastGyrTime;
                if (j <= j4 || j - j4 >= 55) {
                    this.mLastGyrTime = j;
                    checkError(currentTimeMillis);
                    if (this.mMagneticUpdateWork && this.mIsMagneticAvailable) {
                        float[] fArr9 = sensorEvent.values;
                        JNIWrapper.jniUpdateGyro(j, fArr9[0], fArr9[1], fArr9[2]);
                        return;
                    }
                    return;
                }
                return;
            }
            if (type == 6) {
                updatePressure(sensorEvent);
                return;
            }
            if (type != 9) {
                return;
            }
            this.mGravitySensorTimestamp = j;
            this.mGravityUpdateSysTime = currentTimeMillis;
            boolean z4 = Math.abs(j - this.mGyroSensorTimestamp) <= SENSOR_TIMESTAMP_ERROR_TIME;
            this.mGravityTimeStampUsed = z4;
            if (!this.mGyroTimeStampUsed || !this.mMagneticTimeStampUsed || !z4) {
                j = currentTimeMillis;
            }
            long j5 = this.mLastGraTime;
            if (j <= j5 || j - j5 >= 195) {
                this.mLastGraTime = j;
                checkError(currentTimeMillis);
                float[] fArr10 = this.gra_datas_;
                float[] fArr11 = sensorEvent.values;
                fArr10[0] = fArr11[0];
                fArr10[1] = fArr11[1];
                fArr10[2] = fArr11[2];
                if (this.mGyroUpdateWork && this.mIsGyroAvailable && this.mMagneticUpdateWork && this.mIsMagneticAvailable) {
                    JNIWrapper.jniUpdateGravity(j, fArr11[0], fArr11[1], fArr11[2]);
                }
            }
        }
    }

    public void setPublishOther(boolean z) {
        this.mIsPublishOther = z;
    }

    public void setSensorHandler(Handler handler) {
        this.mSensorHandler = handler;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public int start() {
        if (this.mIsListening) {
            return 0;
        }
        if (this.mSensorManager == null) {
            if (L.isLogging) {
                L.d("Can't getSystemService of SENSOR_SERVICE, PED not work!");
            }
            return 0;
        }
        this.mLastMatStepRecord = null;
        JNIWrapper.jniPDRStart("");
        this.start_timeInMillis = System.currentTimeMillis();
        if (getSensorType() != 0) {
            Sensor defaultSensor = this.mSensorManager.getDefaultSensor(1);
            if (defaultSensor != null) {
                this.mIsAccelerationAvailable = true;
                this.mSensorManager.registerListener(this, defaultSensor, 2, this.mSensorHandler);
            }
            Sensor defaultSensor2 = this.mSensorManager.getDefaultSensor(2);
            if (defaultSensor2 != null) {
                this.mIsMagneticAvailable = true;
                this.mSensorManager.registerListener(this, defaultSensor2, 3, this.mSensorHandler);
            }
            Sensor defaultSensor3 = this.mSensorManager.getDefaultSensor(9);
            if (defaultSensor3 != null) {
                this.mIsGravityAvailable = true;
                this.mSensorManager.registerListener(this, defaultSensor3, 3, this.mSensorHandler);
            }
            Sensor defaultSensor4 = this.mSensorManager.getDefaultSensor(4);
            if (defaultSensor4 != null) {
                this.mIsGyroAvailable = true;
                this.mSensorManager.registerListener(this, defaultSensor4, 2, this.mSensorHandler);
            }
        } else if (L.isLogging) {
            L.d("getSensorType() == 0");
        }
        if (this.mSensorManager.getDefaultSensor(6) != null) {
            this.mIsPressureAvailable = true;
            SensorManager sensorManager = this.mSensorManager;
            sensorManager.registerListener(this, sensorManager.getDefaultSensor(6), 3, this.mSensorHandler);
        }
        if (getSensorType() == 0 || !this.mIsGyroAvailable) {
            this.mSensorManager.registerListener(this, this.mSensorManager.getDefaultSensor(3), 3, this.mSensorHandler);
        }
        this.mIsListening = true;
        return 0;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public boolean stop() {
        if (!this.mIsListening) {
            return true;
        }
        JNIWrapper.jniPDRStop();
        this.mSensorManager.unregisterListener(this);
        this.mIsListening = false;
        this.mSensorHandler = null;
        if (L.isLogging) {
            L.d("Stop Ped scan!");
        }
        return true;
    }
}
