package com.autonavi.indoor.provider;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.autonavi.indoor.util.L;

/* loaded from: classes.dex */
public class BLEHelper {
    public final Context context;

    public BLEHelper(Context context) {
        this.context = context;
    }

    public boolean checkPermissions() {
        Context context = this.context;
        if (context == null) {
            if (L.isLogging) {
                L.d("Can't get BLE because context is null");
            }
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission("android.permission.BLUETOOTH", this.context.getPackageName()) == 0 && packageManager.checkPermission("android.permission.BLUETOOTH_ADMIN", this.context.getPackageName()) == 0;
    }

    @TargetApi(18)
    public boolean enable() {
        Context context = this.context;
        if (context == null) {
            if (L.isLogging) {
                L.d("Can't get BLE because context is null");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        BluetoothAdapter adapter = ((BluetoothManager) context.getSystemService("bluetooth")).getAdapter();
        return adapter.getState() == 12 || adapter.enable();
    }

    @TargetApi(18)
    public BluetoothAdapter getBluetoothAdapter() {
        Context context = this.context;
        if (context == null) {
            if (L.isLogging) {
                L.d("Can't get BLE because context is null");
            }
            return null;
        }
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        return ((BluetoothManager) context.getSystemService("bluetooth")).getAdapter();
    }

    @TargetApi(18)
    public boolean hasBluetooth() {
        Context context = this.context;
        if (context == null) {
            if (L.isLogging) {
                L.d("Can't get BLE because context is null");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    @TargetApi(18)
    public boolean isBluetoothEnabled() {
        BluetoothAdapter adapter;
        if (this.context != null) {
            return Build.VERSION.SDK_INT >= 18 && checkPermissions() && (adapter = ((BluetoothManager) this.context.getSystemService("bluetooth")).getAdapter()) != null && adapter.isEnabled();
        }
        if (L.isLogging) {
            L.d("Can't get BLE because context is null");
        }
        return false;
    }
}
