package com.autonavi.indoor.provider;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import com.alibaba.wireless.security.SecExceptionCode;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.entity.Beacon;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.entity.ScanPair;
import com.autonavi.indoor.util.BLEUtils;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MacUtils;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.MathUtils;
import com.autonavi.indoor.util.MessageHelper;
import com.autonavi.indoor.util.Rsa;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@TargetApi(18)
/* loaded from: classes.dex */
public class BLEProvider extends IProvider {
    public static final int BLE_SCAN_NUM_RESTART_MIN_NUM = 8;
    public static final float BLE_SCAN_RESTART_RATE = 0.33f;
    public static final int MIN_BLE_SCAN_NUM_MAX = 10;
    public static final int MSG_BLE_ONLESCAN = 2200;
    public static volatile BLEProvider instance;
    public BluetoothAdapter.LeScanCallback leScanCallback;
    public BLEHelper mBLEHelper;
    public BluetoothAdapter mBluetoothAdapter;
    public long mStartScanTime;
    public HashMap<String, ArrayList<Integer>> cachedRSSI = new HashMap<>();
    public long mLastUpdateTime = 0;
    public final int mBleReportInteval = SecExceptionCode.SEC_ERROR_ORANGE;
    public final int mBleCheckInterval = SecExceptionCode.SEC_ERROR_PAGETRACK;
    public int mLastBLEState = 10;
    public long mLastLeScanCallbackTime = 0;
    public final int statisticCount = 49;
    public ArrayList<Integer> histScanCount = new ArrayList<>(50);
    public Map<String, Long> mHisScanData = new HashMap();
    public long mLastReReregistTime = -1;
    public List<Integer> mHisBleNum = new ArrayList();
    public Map<String, String> encodedMap = new HashMap();
    public final BroadcastReceiver mReceiver = new BroadcastReceiver() { // from class: com.autonavi.indoor.provider.BLEProvider.1
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (BLEProvider.this.mIsListening && !BLEProvider.this.mOutterHandlers.isEmpty() && action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int intExtra = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                if (intExtra == 10 || intExtra == 12) {
                    BLEProvider bLEProvider = BLEProvider.this;
                    if (intExtra == bLEProvider.mLastBLEState) {
                        return;
                    }
                    bLEProvider.mLastBLEState = intExtra;
                    if (intExtra == 10) {
                        if (L.isLogging) {
                            L.d("BLE closed, no ble LeScanCallback recived");
                        }
                        MessageHelper.publishMessage(BLEProvider.this.mOutterHandlers, 504);
                        if (MessageHelper.isValidHandler(BLEProvider.this.mInnerHandler)) {
                            BLEProvider.this.mInnerHandler.removeMessages(1200);
                            return;
                        }
                        return;
                    }
                    if (intExtra != 12) {
                        return;
                    }
                    if (L.isLogging) {
                        L.d("BLE opend, we should restart LeScanCallback");
                    }
                    BLEProvider.this.reRegisterReceiver();
                    if (MessageHelper.isValidHandler(BLEProvider.this.mInnerHandler)) {
                        BLEProvider.this.mInnerHandler.sendEmptyMessageDelayed(1200, 2000L);
                    }
                }
            }
        }
    };

    /* loaded from: classes.dex */
    public static class InnerHandler extends Handler {
        public final WeakReference<BLEProvider> mParent;

        public InnerHandler(BLEProvider bLEProvider) {
            this.mParent = new WeakReference<>(bLEProvider);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            BLEProvider bLEProvider = this.mParent.get();
            if (bLEProvider == null) {
                return;
            }
            int i = message.what;
            if (i != 1200) {
                if (i == 2200) {
                    bLEProvider.mHisScanData.put((String) message.obj, Long.valueOf(System.currentTimeMillis()));
                    return;
                }
                return;
            }
            bLEProvider.checkNeedReregistScan();
            if (bLEProvider.mLastLeScanCallbackTime != 0 && System.currentTimeMillis() - bLEProvider.mLastLeScanCallbackTime > 6001) {
                if (bLEProvider.mBluetoothAdapter != null && bLEProvider.mBluetoothAdapter.isEnabled()) {
                    if (L.isLogging) {
                        L.d("there is no ble scan in 9s. LastLeScanCallbackTime=" + bLEProvider.mLastLeScanCallbackTime + ", currentTimeMillis=" + System.currentTimeMillis());
                    }
                    MessageHelper.publishMessage(bLEProvider.mOutterHandlers, MessageCode.MSG_BLE_NO_SCAN);
                } else {
                    if (L.isLogging) {
                        L.d("BLE not enabled in 9s. LastLeScanCallbackTime=" + bLEProvider.mLastLeScanCallbackTime + ", currentTimeMillis=" + System.currentTimeMillis());
                    }
                    MessageHelper.publishMessage(bLEProvider.mOutterHandlers, 504);
                }
                bLEProvider.mLastLeScanCallbackTime = System.currentTimeMillis();
            }
            removeMessages(1200);
            if (bLEProvider.mIsListening) {
                sendEmptyMessageDelayed(1200, 2000L);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class MyLeScanCallback implements BluetoothAdapter.LeScanCallback {
        public final WeakReference<BLEProvider> mParent;

        public MyLeScanCallback(BLEProvider bLEProvider) {
            this.mParent = new WeakReference<>(bLEProvider);
        }

        @Override // android.bluetooth.BluetoothAdapter.LeScanCallback
        public void onLeScan(BluetoothDevice bluetoothDevice, int i, byte[] bArr) {
            BLEProvider bLEProvider = this.mParent.get();
            if (bLEProvider != null && bLEProvider.mIsListening) {
                bLEProvider.mLastLeScanCallbackTime = System.currentTimeMillis();
                String id = bLEProvider.getID(bluetoothDevice, i, bArr);
                if (id.length() > 1 && i < 0) {
                    Handler handler = bLEProvider.mInnerHandler;
                    if (MessageHelper.isValidHandler(handler)) {
                        handler.obtainMessage(2200, id).sendToTarget();
                        if (!bLEProvider.cachedRSSI.containsKey(id)) {
                            bLEProvider.cachedRSSI.put(id, new ArrayList());
                        }
                        ((ArrayList) bLEProvider.cachedRSSI.get(id)).add(Integer.valueOf(i));
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - bLEProvider.mLastUpdateTime < 3000) {
                            return;
                        }
                        ArrayList arrayList = new ArrayList();
                        for (Map.Entry entry : bLEProvider.cachedRSSI.entrySet()) {
                            arrayList.add(new ScanPair((String) entry.getKey(), MathUtils.avg((ArrayList) entry.getValue())));
                        }
                        ScanData scanData = new ScanData(System.currentTimeMillis(), 1, arrayList);
                        if (L.isLogging) {
                            L.d("pass BLE to host, scan size:" + scanData.scans_.size());
                        }
                        MessageHelper.publishMessage(bLEProvider.mOutterHandlers, 1202, scanData);
                        bLEProvider.cachedRSSI.clear();
                        bLEProvider.mLastUpdateTime = currentTimeMillis;
                        return;
                    }
                    return;
                }
                if (L.isLogging) {
                    L.d("Invalid mac id or rssi");
                }
            }
        }
    }

    private String CheckMTeamBeacon(byte[] bArr) {
        if (bArr != null && bArr.length > 24) {
            if (bArr[0] == 2 && bArr[1] == 1 && ((bArr[2] == 5 || bArr[2] == 6) && bArr[3] == 23)) {
                byte[] bArr2 = new byte[16];
                System.arraycopy(bArr, 9, bArr2, 0, 16);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 16; i++) {
                    stringBuffer.append(String.format("%02X", Byte.valueOf(bArr2[i])));
                }
                String stringBuffer2 = stringBuffer.toString();
                String str = this.encodedMap.get(stringBuffer2);
                if (str != null) {
                    return str;
                }
                byte[] decrypt = Rsa.decrypt(Rsa.byteReverse(bArr2), new BigInteger("8021267762677846189778330391499"), new BigInteger("49549924105414102803086139689747"));
                if (decrypt == null || decrypt.length < 8) {
                    return "";
                }
                StringBuffer stringBuffer3 = new StringBuffer();
                for (int i2 = 6; i2 >= 1; i2--) {
                    stringBuffer3.append(String.format("%02X", Byte.valueOf(decrypt[i2])));
                }
                String stringBuffer4 = stringBuffer3.toString();
                this.encodedMap.put(stringBuffer2, stringBuffer4);
                return stringBuffer4;
            }
            if (bArr[0] == 2 && bArr[1] == 1 && bArr[2] == 6 && bArr[3] == 22 && bArr[5] == -88 && bArr[6] == 1 && bArr[7] == 32) {
                try {
                    byte[] decryptAES = MapUtils.decryptAES(MapUtils.copyOf(bArr, 10, 26), new byte[]{-1, -15, 55, 33, 4, 21, 16, 20, -85, 9, 0, 2, -91, -43, -59, -75});
                    if (decryptAES != null) {
                        StringBuffer stringBuffer5 = new StringBuffer();
                        for (int i3 = 0; i3 < 8; i3++) {
                            stringBuffer5.append(String.format("%02X", Byte.valueOf(decryptAES[i3])));
                        }
                        return stringBuffer5.toString();
                    }
                } catch (Throwable th) {
                    if (L.isLogging) {
                        L.d(th);
                    }
                }
            }
            return "";
        }
        if (L.isLogging) {
            L.d(bArr);
        }
        return "";
    }

    /* JADX INFO: Access modifiers changed from: private */
    public String getID(BluetoothDevice bluetoothDevice, int i, byte[] bArr) {
        String CheckMTeamBeacon = CheckMTeamBeacon(bArr);
        if (CheckMTeamBeacon.length() == 16) {
            return CheckMTeamBeacon + "0000000000000000_0000_0000";
        }
        if (CheckMTeamBeacon.length() == 12) {
            return CheckMTeamBeacon + "00000000000000000000_0000_0000";
        }
        Beacon createFromScanData = BLEUtils.createFromScanData(bluetoothDevice, i, bArr);
        return createFromScanData != null ? MacUtils.encodeBleID(createFromScanData) : "";
    }

    public static BLEProvider getInstance() {
        if (instance == null) {
            synchronized (BLEProvider.class) {
                if (instance == null) {
                    instance = new BLEProvider();
                }
            }
        }
        return instance;
    }

    public void ClearBleScanNumber(int i) {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> it = this.mHisScanData.entrySet().iterator();
        while (it.hasNext()) {
            if (currentTimeMillis - it.next().getValue().longValue() >= i) {
                it.remove();
            }
        }
    }

    public int GetBleScanNumber(int i) {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> it = this.mHisScanData.entrySet().iterator();
        int i2 = 0;
        while (it.hasNext()) {
            if (currentTimeMillis - it.next().getValue().longValue() < i) {
                i2++;
            }
        }
        return i2;
    }

    public void checkNeedReregistScan() {
        int GetBleScanNumber = GetBleScanNumber(SecExceptionCode.SEC_ERROR_ORANGE);
        this.mHisBleNum.add(Integer.valueOf(GetBleScanNumber));
        if (this.mHisBleNum.size() > 20) {
            this.mHisBleNum.remove(0);
        }
        int i = 10;
        for (Integer num : this.mHisBleNum) {
            if (num.intValue() > i) {
                i = num.intValue();
            }
        }
        if (L.isLogging) {
            L.d("checkNeedReregistScan, average_ble_scan=" + GetBleScanNumber + ", max_num=" + i + ", mHisScanData=" + this.mHisScanData.size());
        }
        if (GetBleScanNumber < i * 0.33f && GetBleScanNumber < 8 && this.mHisScanData.size() > 0) {
            if (L.isLogging) {
                L.d("reRegisterReceiver");
            }
            reRegisterReceiver();
            this.mHisScanData.clear();
            this.mLastReReregistTime = System.currentTimeMillis();
        }
        ClearBleScanNumber(50000);
    }

    @Override // com.autonavi.indoor.provider.IProvider
    @TargetApi(18)
    public synchronized int init(Context context) {
        BluetoothAdapter adapter;
        if (context != null) {
            int i = 0;
            if (this.mBLEHelper == null) {
                this.mBLEHelper = new BLEHelper(context);
            }
            if (!this.mBLEHelper.hasBluetooth()) {
                if (L.isLogging) {
                    L.d("The phone don't support BLE.");
                }
                return 0;
            }
            if (this.leScanCallback == null) {
                this.leScanCallback = new MyLeScanCallback(this);
            }
            if (!this.mBLEHelper.checkPermissions()) {
                if (L.isLogging) {
                    L.d("The phone don't allowe use BLE.");
                }
                return 505;
            }
            if (this.mContext == null) {
                if (L.isLogging) {
                    L.d("Initialize BleProvider");
                }
                this.mContext = context;
                try {
                    adapter = ((BluetoothManager) context.getSystemService("bluetooth")).getAdapter();
                    this.mBluetoothAdapter = adapter;
                } catch (Throwable th) {
                    if (L.isLogging) {
                        L.d("Can't getSystemService of BLUETOOTH_SERVICE, BLE not work!");
                    }
                    if (L.isLogging) {
                        L.d(th);
                    }
                    this.mBluetoothAdapter = null;
                }
                if (adapter == null || !adapter.isEnabled()) {
                    if (L.isLogging) {
                        L.d("Failed to get BluetoothManager from SystemService");
                    }
                    i = 504;
                }
            } else if (L.isLogging) {
                L.d("Try to initialize PedProvider which had already been initialized before. To re-init PedProvider with new mConfiguration call PedProvider.destroy() at first.");
            }
            this.mLastUpdateTime = System.currentTimeMillis();
            return i;
        }
        throw new IllegalArgumentException("PedProvider context can not be initialized with null");
    }

    public boolean isEnabled() {
        if (this.mBLEHelper.hasBluetooth()) {
            return this.mBluetoothAdapter != null && this.mBLEHelper.isBluetoothEnabled();
        }
        if (L.isLogging) {
            L.d(" The phone don't support BLE!");
        }
        return false;
    }

    public void reRegisterReceiver() {
        BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
        if (bluetoothAdapter != null) {
            try {
                bluetoothAdapter.stopLeScan(this.leScanCallback);
                if (!this.mBluetoothAdapter.startLeScan(this.leScanCallback)) {
                    if (L.isLogging) {
                        L.d("restartLeScan failed!!");
                    } else if (L.isLogging) {
                        L.d("restartLeScan success");
                    }
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public void registerListener(Handler handler) {
        BLEHelper bLEHelper = this.mBLEHelper;
        if (bLEHelper != null && bLEHelper.hasBluetooth()) {
            super.registerListener(handler);
        } else if (L.isLogging) {
            L.d("The phone don't support BLE.");
        }
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public int start() {
        if (L.isLogging) {
            L.d(" start ble scan");
        }
        if (this.mIsListening) {
            return 0;
        }
        if (!this.mBLEHelper.hasBluetooth()) {
            if (L.isLogging) {
                L.d("The phone don't support BLE.");
            }
            return 504;
        }
        if (this.mBluetoothAdapter == null) {
            if (L.isLogging) {
                L.d("Can't getSystemService of BLUETOOTH_SERVICE, BLE not work!");
            }
            this.mLastBLEState = 10;
            return 504;
        }
        this.mLastBLEState = 12;
        this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        if (!this.mBLEHelper.isBluetoothEnabled()) {
            if (L.isLogging) {
                L.d("BLE not useable.");
            }
            this.mLastBLEState = 10;
        }
        this.mLastUpdateTime = System.currentTimeMillis();
        this.mLastLeScanCallbackTime = System.currentTimeMillis();
        this.mIsListening = true;
        InnerHandler innerHandler = new InnerHandler(this);
        this.mInnerHandler = innerHandler;
        innerHandler.sendEmptyMessageDelayed(1200, 2000L);
        this.mStartScanTime = System.currentTimeMillis();
        this.histScanCount.clear();
        this.mHisScanData.clear();
        this.mHisBleNum.clear();
        BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
        if (bluetoothAdapter != null) {
            try {
                boolean startLeScan = bluetoothAdapter.startLeScan(this.leScanCallback);
                if (L.isLogging) {
                    L.d("startLeScan status:" + startLeScan);
                }
            } catch (Exception e) {
                if (L.isLogging) {
                    L.d("startLeScan Exception:" + e.getMessage());
                }
            }
        }
        return 0;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public boolean stop() {
        if (!this.mIsListening) {
            return true;
        }
        this.mIsListening = false;
        this.mInnerHandler.removeMessages(1200);
        this.mInnerHandler = null;
        BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
        if (bluetoothAdapter != null) {
            try {
                bluetoothAdapter.stopLeScan(this.leScanCallback);
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
        if (L.isLogging) {
            L.d("---Stop Ble Scan----");
        }
        this.mContext.unregisterReceiver(this.mReceiver);
        return true;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public void unregisterListener(Handler handler) {
        BLEHelper bLEHelper = this.mBLEHelper;
        if (bLEHelper != null && bLEHelper.hasBluetooth()) {
            super.unregisterListener(handler);
        } else if (L.isLogging) {
            L.d("The phone don't support BLE.");
        }
    }
}
