package com.autonavi.indoor.provider;

import android.content.Context;
import android.os.Handler;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MessageHelper;
import java.util.ArrayList;

/* loaded from: classes.dex */
public class IProvider {
    public Context mContext;
    public Handler mInnerHandler = null;
    public volatile boolean mIsListening = false;
    public final ArrayList<Handler> mOutterHandlers = new ArrayList<>();

    public void checkConfiguration() {
        if (this.mContext == null) {
            throw new IllegalStateException("LocationProvider must be init with Context before using");
        }
    }

    public int init(Context context) {
        throw new RuntimeException("Subclass should implement this method");
    }

    public boolean isInited() {
        return this.mContext != null;
    }

    public void registerListener(Handler handler) {
        int start;
        if (handler == null) {
            return;
        }
        checkConfiguration();
        synchronized (this) {
            synchronized (this.mOutterHandlers) {
                if (!this.mOutterHandlers.contains(handler)) {
                    this.mOutterHandlers.add(handler);
                } else if (L.isLogging) {
                    L.d("Handler already exist");
                }
                if (this.mOutterHandlers.size() > 0 && !this.mIsListening && (start = start()) != 0) {
                    MessageHelper.publishMessage(this.mOutterHandlers, start);
                }
            }
        }
    }

    public int start() {
        throw new RuntimeException("Subclass should implement this method");
    }

    public boolean stop() {
        throw new RuntimeException("Subclass should implement this method");
    }

    public void unregisterListener(Handler handler) {
        checkConfiguration();
        synchronized (this) {
            synchronized (this.mOutterHandlers) {
                this.mOutterHandlers.remove(handler);
                if (this.mOutterHandlers.isEmpty()) {
                    stop();
                }
            }
        }
    }
}
