package com.autonavi.indoor.provider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import com.alibaba.wireless.security.SecExceptionCode;
import com.amap.location.g.d.a;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.entity.ScanPair;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MessageHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/* loaded from: classes.dex */
public class WifiProvider extends IProvider {
    public static final int SCAN_DELAY_FASTEST = 0;
    public static final int SCAN_DELAY_NORMAL = 1;
    public static volatile WifiProvider instance;
    public a mWifiManager;
    public int mNoScanTimes = 0;
    public long mLastReportTime = 0;
    public HashMap<Long, List<ScanResult>> mScanResults = new HashMap<>();
    public int mUpdateInteval = SecExceptionCode.SEC_ERROR_PAGETRACK;
    public int mWifiCheckInterval = SecExceptionCode.SEC_ERROR_ORANGE;
    public int mLastWifiState = 3;
    public volatile int mScanMode = 0;
    public long mLastStartTime = -1;
    public BroadcastReceiver mReceiver = new BroadcastReceiver() { // from class: com.autonavi.indoor.provider.WifiProvider.1
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            WifiProvider wifiProvider = WifiProvider.this;
            Handler handler = wifiProvider.mInnerHandler;
            if (wifiProvider.mIsListening && handler != null) {
                try {
                    List<ScanResult> b = WifiProvider.this.mWifiManager.b();
                    if (b != null && !b.isEmpty()) {
                        handler.obtainMessage(1201, b).sendToTarget();
                        if (WifiProvider.this.mScanMode == 0) {
                            handler.removeMessages(1203);
                            long currentTimeMillis = System.currentTimeMillis() - WifiProvider.this.mLastStartTime;
                            if (currentTimeMillis > 1000) {
                                WifiProvider.this.startScan("WifiManager.startScan by onReceive");
                            } else {
                                Message obtain = Message.obtain(handler, 1203);
                                long j = currentTimeMillis > 0 ? 1000 - currentTimeMillis : 1000L;
                                if (L.isLogging) {
                                    L.d("send message request restart:" + j);
                                }
                                handler.sendMessageDelayed(obtain, j);
                            }
                        }
                        if (L.isLogging) {
                            L.d("wifi onReceive:" + b.size());
                            return;
                        }
                        return;
                    }
                    if (L.isLogging) {
                        L.d("WifiManager.getScanResults is null");
                        return;
                    }
                    return;
                } catch (Throwable th) {
                    if (L.isLogging) {
                        L.d(th);
                        return;
                    }
                    return;
                }
            }
            if (L.isLogging) {
                L.d("wifi scan has been stoped");
            }
        }
    };
    public BroadcastReceiver mReceiver2 = new BroadcastReceiver() { // from class: com.autonavi.indoor.provider.WifiProvider.2
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            if (!WifiProvider.this.mIsListening) {
                if (L.isLogging) {
                    L.d("NOT listening");
                    return;
                }
                return;
            }
            if (WifiProvider.this.mOutterHandlers.isEmpty()) {
                if (L.isLogging) {
                    L.d("No Handler");
                    return;
                }
                return;
            }
            try {
                if ("android.net.wifi.WIFI_STATE_CHANGED".equals(intent.getAction())) {
                    int intExtra = intent.getIntExtra("wifi_state", 0);
                    if ((intExtra == 1 || intExtra == 3) && intExtra != WifiProvider.this.mLastWifiState) {
                        if (intExtra == 1) {
                            if (L.isLogging) {
                                L.d("WIFI_STATE_CHANGED_ACTION WIFI DISABLED, wifi scan not valide");
                            }
                            MessageHelper.publishMessage(WifiProvider.this.mOutterHandlers, 501);
                        } else if (intExtra == 3) {
                            if (L.isLogging) {
                                L.d("WIFI_STATE_CHANGED_ACTION WIFI ENABLED. we are using wifi scan, now restart it.");
                            }
                            WifiProvider.this.reRegisterReceiver();
                        }
                        WifiProvider.this.mLastWifiState = intExtra;
                    }
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    };

    /* loaded from: classes.dex */
    public static class InnerHandler extends Handler {
        public final WeakReference<WifiProvider> mParent;

        public InnerHandler(WifiProvider wifiProvider) {
            this.mParent = new WeakReference<>(wifiProvider);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            WifiProvider wifiProvider = this.mParent.get();
            if (wifiProvider == null) {
                return;
            }
            try {
                long currentTimeMillis = System.currentTimeMillis();
                if (message.what == 1201) {
                    List<ScanResult> list = (List) message.obj;
                    if (!list.isEmpty()) {
                        wifiProvider.mNoScanTimes = 0;
                        wifiProvider.mScanResults.put(Long.valueOf(currentTimeMillis), list);
                    }
                    if (currentTimeMillis - wifiProvider.mLastReportTime >= wifiProvider.mUpdateInteval) {
                        HashMap hashMap = new HashMap();
                        for (List<ScanResult> list2 : wifiProvider.mScanResults.values()) {
                            int size = list2.size();
                            for (int i = 0; i < size; i++) {
                                ScanResult scanResult = list2.get(i);
                                if (scanResult.level < 0 && scanResult.level >= -128) {
                                    if (!hashMap.containsKey(scanResult.BSSID)) {
                                        hashMap.put(scanResult.BSSID, new ArrayList());
                                    }
                                    ((ArrayList) hashMap.get(scanResult.BSSID)).add(new ScanPair(scanResult));
                                }
                                if (L.isLogging) {
                                    L.d("Invalide rssi:" + scanResult.level);
                                }
                            }
                        }
                        ArrayList arrayList = new ArrayList();
                        for (ArrayList arrayList2 : hashMap.values()) {
                            int size2 = arrayList2.size();
                            int i2 = 0;
                            for (int i3 = 0; i3 < size2; i3++) {
                                i2 += ((ScanPair) arrayList2.get(i3)).mRSSI;
                            }
                            ScanPair scanPair = (ScanPair) arrayList2.get(0);
                            scanPair.mRSSI = i2 / arrayList2.size();
                            arrayList.add(scanPair);
                        }
                        ScanData scanData = new ScanData(System.currentTimeMillis(), 0, arrayList);
                        wifiProvider.mScanResults.clear();
                        if (L.isLogging) {
                            L.d("send wifi to host, combined wifi size:" + scanData.scans_.size() + ", LastReportTime=" + wifiProvider.mLastReportTime);
                        }
                        MessageHelper.publishMessage(wifiProvider.mOutterHandlers, 1201, scanData);
                        wifiProvider.mLastReportTime = System.currentTimeMillis();
                        return;
                    }
                    if (L.isLogging) {
                        L.d("wifi recived.but dont sent to host for elasped:" + (currentTimeMillis - wifiProvider.mLastReportTime));
                        return;
                    }
                    return;
                }
                if (message.what == 1200) {
                    int i4 = wifiProvider.mNoScanTimes;
                    wifiProvider.mNoScanTimes = i4 + 1;
                    if (i4 > 3) {
                        wifiProvider.reRegisterReceiver();
                        if (!WifiProvider.isWifiEnabled(wifiProvider.mContext)) {
                            MessageHelper.publishMessage(wifiProvider.mOutterHandlers, 501);
                            if (L.isLogging) {
                                L.d("WIFI not Enabled in timer");
                            }
                        } else {
                            MessageHelper.publishMessage(wifiProvider.mOutterHandlers, 503);
                            if (L.isLogging) {
                                L.d("WIFI not recieved in " + wifiProvider.mNoScanTimes);
                            }
                        }
                        wifiProvider.mNoScanTimes = 0;
                    }
                    if (wifiProvider.mInnerHandler != null) {
                        wifiProvider.mInnerHandler.sendEmptyMessageDelayed(1200, wifiProvider.mWifiCheckInterval);
                    }
                    if (wifiProvider.mScanMode == 1) {
                        wifiProvider.startScan("WifiManager.startScan by MSG_TIMER for SCAN_DELAY_NORMAL");
                        return;
                    }
                    return;
                }
                if (message.what == 1203) {
                    wifiProvider.startScan("WifiManager.startScan by MSG_WIFI_RESTART");
                }
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
            }
        }
    }

    public static WifiProvider getInstance() {
        if (instance == null) {
            synchronized (WifiProvider.class) {
                if (instance == null) {
                    instance = new WifiProvider();
                }
            }
        }
        return instance;
    }

    public static boolean isWiFiEnabled(Context context) {
        return ((WifiManager) context.getSystemService("wifi")).getWifiState() == 3;
    }

    public static boolean isWifiEnabled(Context context) {
        return ((WifiManager) context.getSystemService("wifi")).isWifiEnabled();
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public synchronized int init(Context context) {
        int i;
        if (context != null) {
            i = 0;
            try {
                if (this.mContext == null) {
                    if (L.isLogging) {
                        L.d("Initialize WifiProvider");
                    }
                    if (!isWifiEnabled(context)) {
                        if (L.isLogging) {
                            L.d("WARNING: Initialize WifiProvider:MSG_WIFI_NOT_ENABLED");
                        }
                        i = 501;
                    }
                    this.mContext = context;
                    a a = a.a(context);
                    this.mWifiManager = a;
                    if (a == null && L.isLogging) {
                        L.d("Can't getSystemService of WIFI_SERVICE, WiFi not work!");
                    }
                } else if (L.isLogging) {
                    L.d("Try to initialize PedProvider which had already been initialized before. To re-init PedProvider with new mConfiguration call PedProvider.destroy() at first.");
                }
            } catch (SecurityException unused) {
                i = 502;
            }
        } else {
            throw new IllegalArgumentException("PedProvider mConfiguration can not be initialized with null");
        }
        return i;
    }

    public void reRegisterReceiver() {
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
        startScan("WifiManager.startScan by reRegisterReceiver ");
    }

    public void setScanMode(int i) {
        if (L.isLogging) {
            L.d("setScanMode:(FASTEST0,NORMAL1)" + this.mScanMode + ", newMode:" + i);
        }
        this.mScanMode = i;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public int start() {
        if (this.mIsListening) {
            return 0;
        }
        if (this.mWifiManager == null) {
            if (!L.isLogging) {
                return 504;
            }
            L.d("Can't getSystemService of WIFI_SERVICE, WiFi not work!");
            return 504;
        }
        this.mContext.registerReceiver(this.mReceiver2, new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED"));
        this.mLastWifiState = 3;
        if (!isWifiEnabled(this.mContext)) {
            this.mLastWifiState = 1;
            if (L.isLogging) {
                L.d("Wifi not enabled!!");
            }
        }
        try {
            this.mInnerHandler = new InnerHandler(this);
            this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
            startScan("WifiManager.startScan by start");
            this.mLastReportTime = 0L;
            this.mInnerHandler.sendEmptyMessageDelayed(1200, this.mWifiCheckInterval);
            if (L.isLogging) {
                L.d("WiFi Scan start finished...");
            }
            this.mIsListening = true;
            return 0;
        } catch (Throwable th) {
            if (!L.isLogging) {
                return 508;
            }
            L.d(th);
            return 508;
        }
    }

    public void startScan(String str) {
        boolean a = this.mWifiManager.a();
        if (L.isLogging) {
            StringBuilder sb = new StringBuilder();
            sb.append(str);
            sb.append(", startScan:");
            sb.append(a ? "success" : "failed");
            L.d(sb.toString());
        }
        this.mLastStartTime = System.currentTimeMillis();
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public boolean stop() {
        if (!this.mIsListening) {
            return true;
        }
        if (L.isLogging) {
            L.d("STOP wifi Scan");
        }
        this.mIsListening = false;
        try {
            this.mContext.unregisterReceiver(this.mReceiver2);
            this.mContext.unregisterReceiver(this.mReceiver);
            this.mInnerHandler.removeMessages(1200);
            this.mInnerHandler = null;
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        if (L.isLogging) {
            L.d("mWifiCheckTimer.cancel");
        }
        return true;
    }
}
