package com.autonavi.indoor.simulator;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.autonavi.amapauto.user.UserPhone;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.entity.ScanPair;
import com.autonavi.indoor.pdr.MatStepData;
import com.autonavi.indoor.provider.IProvider;
import com.autonavi.indoor.util.L;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/* loaded from: classes.dex */
public class FileDataProvider extends IProvider {
    public static volatile FileDataProvider f;
    public String d;
    public List<a> a = new ArrayList();
    public int b = 0;
    public long c = 0;
    public boolean mEnablePdr = false;
    public boolean g = false;
    public ArrayList<Handler> h = new ArrayList<>();
    public double mLastAngle = 0.0d;
    public double mLastPress = 0.0d;
    public MatStepData e = null;

    /* loaded from: classes.dex */
    public static class b extends Handler {
        public final WeakReference<FileDataProvider> a;

        public b(FileDataProvider fileDataProvider) {
            this.a = new WeakReference<>(fileDataProvider);
        }

        public void a(FileDataProvider fileDataProvider, int i, Object obj) {
            synchronized (this) {
                Iterator it = fileDataProvider.h.iterator();
                while (it.hasNext()) {
                    Handler handler = (Handler) it.next();
                    Message obtainMessage = handler.obtainMessage(i);
                    obtainMessage.obj = obj;
                    handler.sendMessage(obtainMessage);
                }
            }
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            int i;
            int i2;
            FileDataProvider fileDataProvider = this.a.get();
            if (fileDataProvider == null) {
                return;
            }
            try {
                if (message.what != 1200) {
                    return;
                }
                int i3 = !fileDataProvider.mEnablePdr ? 100 : 10;
                if (fileDataProvider.b >= fileDataProvider.a.size()) {
                    if (L.isLogging) {
                        L.d("Simulate file is end!");
                        return;
                    }
                    return;
                }
                a aVar = fileDataProvider.a.get(fileDataProvider.b);
                aVar.a = System.currentTimeMillis();
                if (aVar.g != null) {
                    aVar.g.timestamp_ = System.currentTimeMillis();
                }
                int i4 = 0;
                try {
                    if (aVar.b == 1) {
                        if (fileDataProvider.mEnablePdr) {
                            MatStepData matStepData = new MatStepData(aVar.c, aVar.d, 0.0d, 0.0d, 0.0d, 1.0d, 0.0d, 0.0d, 0.0d, 0.0d, 0.0d, 0.0d, aVar.d, 0.0d, 0.0d, 0, 0.0d, 0.0d);
                            matStepData.timestamp_ = aVar.a;
                            a(fileDataProvider, 111, matStepData);
                            i4 = i3 * 5;
                        }
                        fileDataProvider.mLastAngle = aVar.d;
                    } else if (aVar.b == 4 && aVar.g != null) {
                        if (fileDataProvider.mEnablePdr) {
                            try {
                                if (fileDataProvider.e == null) {
                                    i2 = i3;
                                    MatStepData matStepData2 = new MatStepData(aVar.g.step_, aVar.g.angle_, aVar.g.mat_data_[0], aVar.g.mat_data_[1], aVar.g.mat_data_[2], aVar.g.q1_, aVar.g.q2_, aVar.g.q3_, aVar.g.q4_, aVar.g.rotate_rate_x_, aVar.g.rotate_rate_y_, aVar.g.rotate_rate_z_, aVar.g.step_len_, aVar.g.step_len_f_, aVar.g.step_len_v_, aVar.g.move_direction_, aVar.g.angle_no_mag_, aVar.g.move_state_score_);
                                    fileDataProvider = fileDataProvider;
                                    fileDataProvider.e = matStepData2;
                                    matStepData2.timestamp_ = aVar.g.timestamp_;
                                } else {
                                    i2 = i3;
                                    if (fileDataProvider.e.step_ == aVar.g.step_) {
                                        if (aVar.g.timestamp_ - fileDataProvider.e.timestamp_ < 2000) {
                                            fileDataProvider.e.AddMatData(aVar.g.mat_data_[0], aVar.g.mat_data_[1], aVar.g.mat_data_[2], aVar.g.q1_, aVar.g.q2_, aVar.g.q3_, aVar.g.q4_, aVar.g.rotate_rate_x_, aVar.g.rotate_rate_y_, aVar.g.rotate_rate_z_);
                                            fileDataProvider = fileDataProvider;
                                        } else {
                                            fileDataProvider.e.showangle = aVar.g.angle_;
                                            fileDataProvider.e.pressure = fileDataProvider.mLastPress;
                                            a(fileDataProvider, 111, fileDataProvider.e);
                                            MatStepData matStepData3 = new MatStepData(aVar.g.step_, aVar.g.angle_, aVar.g.mat_data_[0], aVar.g.mat_data_[1], aVar.g.mat_data_[2], aVar.g.q1_, aVar.g.q2_, aVar.g.q3_, aVar.g.q4_, aVar.g.rotate_rate_x_, aVar.g.rotate_rate_y_, aVar.g.rotate_rate_z_, aVar.g.step_len_, aVar.g.step_len_f_, aVar.g.step_len_v_, aVar.g.move_direction_, aVar.g.angle_no_mag_, aVar.g.move_state_score_);
                                            fileDataProvider.e = matStepData3;
                                            matStepData3.timestamp_ = aVar.g.timestamp_;
                                        }
                                    } else if (fileDataProvider.e.step_ != aVar.g.step_) {
                                        fileDataProvider.e.showangle = aVar.g.angle_;
                                        fileDataProvider.e.pressure = fileDataProvider.mLastPress;
                                        a(fileDataProvider, 111, fileDataProvider.e);
                                        MatStepData matStepData4 = new MatStepData(aVar.g.step_, aVar.g.angle_, aVar.g.mat_data_[0], aVar.g.mat_data_[1], aVar.g.mat_data_[2], aVar.g.q1_, aVar.g.q2_, aVar.g.q3_, aVar.g.q4_, aVar.g.rotate_rate_x_, aVar.g.rotate_rate_y_, aVar.g.rotate_rate_z_, aVar.g.step_len_, aVar.g.step_len_f_, aVar.g.step_len_v_, aVar.g.move_direction_, aVar.g.angle_no_mag_, aVar.g.move_state_score_);
                                        fileDataProvider.e = matStepData4;
                                        matStepData4.timestamp_ = aVar.g.timestamp_;
                                    }
                                }
                                i4 = i2 * 5;
                            } catch (Throwable th) {
                                th = th;
                                if (L.isLogging) {
                                    L.d(th);
                                    return;
                                }
                                return;
                            }
                        }
                        fileDataProvider.mLastAngle = aVar.g.angle_;
                    } else {
                        int i5 = i3;
                        if (aVar.b == 2) {
                            i4 = i5 * 2;
                            fileDataProvider.mLastPress = aVar.e;
                        } else if (aVar.b == 3 && aVar.f.size() > 0 && aVar.f.get(0).mID.length() > 3) {
                            if (aVar.f.get(0).mID.charAt(2) == '_') {
                                i = 1201;
                            } else {
                                i = 1202;
                                i4 = 1;
                            }
                            if (L.isLogging) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("type:");
                                sb.append(i == 1201 ? "WIFI" : "BLE");
                                sb.append(", mScandataList:");
                                sb.append(aVar.f.size());
                                L.d(sb.toString());
                            }
                            a(fileDataProvider, i, new ScanData(aVar.a, i4, aVar.f));
                            i4 = i5 * 10;
                        }
                    }
                    if (fileDataProvider.mInnerHandler != null) {
                        fileDataProvider.mInnerHandler.sendEmptyMessageDelayed(1200, i4);
                    }
                    fileDataProvider.b++;
                } catch (Throwable th2) {
                    th = th2;
                }
            } catch (Throwable th3) {
                th = th3;
            }
        }
    }

    public static FileDataProvider getInstance() {
        if (f == null) {
            synchronized (FileDataProvider.class) {
                if (f == null) {
                    f = new FileDataProvider();
                }
            }
        }
        return f;
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public int init(Context context) {
        if (context != null) {
            if (this.mContext == null) {
                if (L.isLogging) {
                    L.d("Initialize FileDataProvider.");
                }
                this.mContext = context;
                return 0;
            }
            if (!L.isLogging) {
                return 0;
            }
            L.d("Try to initialize FileDataProvider which had already been initialized before. To re-init FileDataProvider with new mConfiguration call FileDataProvider.destroy() at first.");
            return 0;
        }
        throw new IllegalArgumentException("FileDataProvider mConfiguration can not be initialized with null");
    }

    public boolean loadData(String str) {
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileDataProvider fileDataProvider = this;
        int i = 0;
        try {
            fileDataProvider.a.clear();
            if (L.isLogging) {
                L.d("load Data : " + str);
            }
            InputStreamReader inputStreamReader2 = new InputStreamReader(new FileInputStream(str));
            BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
            if (!inputStreamReader2.ready() && L.isLogging) {
                L.d("打开Log文件失败");
            }
            while (true) {
                String readLine = bufferedReader2.readLine();
                if (readLine == null) {
                    break;
                }
                if (readLine.length() >= 3) {
                    readLine.substring(i, 3);
                    if (readLine.substring(i, 3).equals("odo")) {
                        String[] split = readLine.substring(4).split(",");
                        if (split.length == 3) {
                            fileDataProvider.a.add(new a(Long.parseLong(split[i]), Integer.parseInt(split[1]), Float.parseFloat(split[2])));
                        }
                    } else if (readLine.substring(i, 3).equals("pre")) {
                        String[] split2 = readLine.substring(4).split(",");
                        if (split2.length == 2) {
                            fileDataProvider.a.add(new a(Long.parseLong(split2[i]), Float.parseFloat(split2[1])));
                        }
                    } else if (readLine.substring(i, 3).equals("ble")) {
                        String[] split3 = readLine.substring(4).split(",");
                        if (split3.length == 2) {
                            String[] split4 = split3[1].split("\\$");
                            ArrayList arrayList = new ArrayList();
                            for (String str2 : split4) {
                                String[] split5 = str2.split(UserPhone.SPECIAL_LETTER);
                                if (split5.length == 2) {
                                    arrayList.add(new ScanPair(split5[i], Integer.parseInt(split5[1])));
                                }
                            }
                            fileDataProvider.a.add(new a(Long.parseLong(split3[i]), arrayList));
                        }
                    } else if (readLine.substring(i, 3).equals("mat")) {
                        String[] split6 = readLine.substring(4).split(",");
                        if (split6.length == 18) {
                            inputStreamReader = inputStreamReader2;
                            bufferedReader = bufferedReader2;
                            try {
                                fileDataProvider = this;
                                fileDataProvider.a.add(new a(Long.parseLong(split6[i]), Integer.parseInt(split6[1]), Float.parseFloat(split6[2]), Float.parseFloat(split6[3]), Float.parseFloat(split6[4]), Float.parseFloat(split6[5]), Float.parseFloat(split6[6]), Float.parseFloat(split6[7]), Float.parseFloat(split6[8]), Float.parseFloat(split6[9]), Float.parseFloat(split6[10]), Float.parseFloat(split6[11]), Float.parseFloat(split6[12]), Float.parseFloat(split6[13]), Float.parseFloat(split6[14]), Float.parseFloat(split6[15]), Integer.parseInt(split6[17]), Float.parseFloat(split6[16]), 1.0d));
                            } catch (IOException e) {
                                e = e;
                                if (!L.isLogging) {
                                    return false;
                                }
                                L.d((Throwable) e);
                                return false;
                            }
                        } else {
                            bufferedReader = bufferedReader2;
                            inputStreamReader = inputStreamReader2;
                            if (split6.length == 19) {
                                fileDataProvider = this;
                                fileDataProvider.a.add(new a(Long.parseLong(split6[0]), Integer.parseInt(split6[1]), Float.parseFloat(split6[2]), Float.parseFloat(split6[3]), Float.parseFloat(split6[4]), Float.parseFloat(split6[5]), Float.parseFloat(split6[6]), Float.parseFloat(split6[7]), Float.parseFloat(split6[8]), Float.parseFloat(split6[9]), Float.parseFloat(split6[10]), Float.parseFloat(split6[11]), Float.parseFloat(split6[12]), Float.parseFloat(split6[13]), Float.parseFloat(split6[14]), Float.parseFloat(split6[15]), Integer.parseInt(split6[17]), Float.parseFloat(split6[16]), Float.parseFloat(split6[18])));
                            }
                        }
                        inputStreamReader2 = inputStreamReader;
                        bufferedReader2 = bufferedReader;
                        i = 0;
                    }
                    bufferedReader = bufferedReader2;
                    inputStreamReader = inputStreamReader2;
                    inputStreamReader2 = inputStreamReader;
                    bufferedReader2 = bufferedReader;
                    i = 0;
                }
            }
            BufferedReader bufferedReader3 = bufferedReader2;
            InputStreamReader inputStreamReader3 = inputStreamReader2;
            fileDataProvider.b = i;
            if (fileDataProvider.a.size() > 0) {
                fileDataProvider.c = fileDataProvider.a.get(i).a;
            }
            if (L.isLogging) {
                L.d("load Data end: " + fileDataProvider.a.size());
            }
            bufferedReader3.close();
            inputStreamReader3.close();
            return true;
        } catch (IOException e2) {
            e = e2;
        }
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public void registerListener(Handler handler) {
        checkConfiguration();
        if (L.isLogging) {
            L.d("registerListener: " + handler);
        }
        synchronized (this) {
            if (handler != null) {
                if (this.h.indexOf(handler) == -1) {
                    this.h.add(handler);
                    if (this.h.size() > 0 && !this.g) {
                        start();
                    }
                }
            }
            if (L.isLogging) {
                L.d("Handler already exist");
            }
            if (this.h.size() > 0) {
                start();
            }
        }
    }

    public void setSimulatFile(String str) {
        this.d = str;
        if (L.isLogging) {
            L.d("setSimulatFile:" + this.d);
        }
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public int start() {
        if (L.isLogging) {
            L.d("start FileDataProvider:" + this.d);
        }
        this.b = 0;
        if (loadData(this.d)) {
            b bVar = new b(this);
            this.mInnerHandler = bVar;
            bVar.sendEmptyMessageDelayed(1200, 2000L);
            this.g = true;
            this.e = null;
            return 0;
        }
        throw new IllegalArgumentException("FileDataProvider Load simulate file error.");
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public boolean stop() {
        if (!this.g) {
            return true;
        }
        try {
            if (L.isLogging) {
                L.d(" STOP FileDataProvider Scan");
            }
            this.mInnerHandler.removeMessages(1200);
            this.a.clear();
            this.b = 0;
            this.g = false;
            this.mInnerHandler = null;
            return true;
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
            return false;
        }
    }

    @Override // com.autonavi.indoor.provider.IProvider
    public void unregisterListener(Handler handler) {
        checkConfiguration();
        synchronized (this) {
            this.h.remove(handler);
            if (this.h.isEmpty()) {
                stop();
            }
        }
    }

    /* loaded from: classes.dex */
    public static class a {
        public long a;
        public int b;
        public int c;
        public double d;
        public double e;
        public List<ScanPair> f;
        public MatStepData g;

        public a(long j, int i, double d) {
            this.g = null;
            this.a = j;
            this.c = i;
            this.d = d;
            this.b = 1;
        }

        public a(long j, double d) {
            this.g = null;
            this.a = j;
            this.e = d;
            this.b = 2;
        }

        public a(long j, List<ScanPair> list) {
            this.g = null;
            this.a = j;
            this.f = list;
            this.b = 3;
        }

        public a(long j, int i, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, int i2, double d15, double d16) {
            this.g = null;
            this.b = 4;
            MatStepData matStepData = new MatStepData();
            this.g = matStepData;
            matStepData.timestamp_ = j;
            matStepData.step_ = i;
            matStepData.angle_ = d;
            matStepData.mat_num_ = 1;
            matStepData.rotate_rate_x_ = d9;
            matStepData.rotate_rate_y_ = d10;
            matStepData.rotate_rate_z_ = d11;
            double[] dArr = matStepData.mat_data_;
            dArr[0] = d2;
            dArr[1] = d3;
            dArr[2] = d4;
            matStepData.step_len_ = d12;
            matStepData.step_len_f_ = d13;
            matStepData.step_len_v_ = d14;
            matStepData.move_direction_ = i2;
            matStepData.q1_ = d5;
            matStepData.q2_ = d6;
            matStepData.q3_ = d7;
            matStepData.q4_ = d8;
            matStepData.angle_no_mag_ = d15;
            matStepData.move_state_score_ = d16;
        }
    }
}
