package com.autonavi.indoor.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.amap.location.common.a;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import java.util.List;

/* loaded from: classes.dex */
public class DeviceUtils {
    public static final String NETSTATE = "android.permission.ACCESS_NETWORK_STATE";
    public static final String PHONESTATE = "android.permission.READ_PHONE_STATE";
    public static final String WIFISTATE = "android.permission.ACCESS_WIFI_STATE";
    public static String mDeviceId;
    public static String mMacAddress;
    public static String mReslution;
    public static String mSubscriberId;
    public static String networkOperatorName;

    public static List<ScanResult> doChooseSort(List<ScanResult> list) {
        int size = list.size();
        for (int i = 0; i < size - 1; i++) {
            for (int i2 = 1; i2 < size - i; i2++) {
                int i3 = i2 - 1;
                if (list.get(i3).level > list.get(i2).level) {
                    ScanResult scanResult = list.get(i3);
                    list.set(i3, list.get(i2));
                    list.set(i2, scanResult);
                }
            }
        }
        return list;
    }

    public static int getActiveNetWorkType(Context context) {
        ConnectivityManager connectivityManager;
        NetworkInfo activeNetworkInfo;
        if (context == null || context.checkCallingOrSelfPermission(NETSTATE) != 0 || (connectivityManager = (ConnectivityManager) context.getSystemService("connectivity")) == null || (activeNetworkInfo = connectivityManager.getActiveNetworkInfo()) == null) {
            return -1;
        }
        return activeNetworkInfo.getType();
    }

    public static String getCellInfo(Context context) {
        StringBuilder sb = new StringBuilder();
        try {
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (context.checkCallingOrSelfPermission(PHONESTATE) != 0) {
            return sb.toString();
        }
        CellLocation cellLocation = ((TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE)).getCellLocation();
        if (cellLocation instanceof GsmCellLocation) {
            GsmCellLocation gsmCellLocation = (GsmCellLocation) cellLocation;
            int cid = gsmCellLocation.getCid();
            sb.append(gsmCellLocation.getLac());
            sb.append("||");
            sb.append(cid);
            sb.append("&bttype=gsm");
        } else if (cellLocation instanceof CdmaCellLocation) {
            CdmaCellLocation cdmaCellLocation = (CdmaCellLocation) cellLocation;
            int systemId = cdmaCellLocation.getSystemId();
            int networkId = cdmaCellLocation.getNetworkId();
            int baseStationId = cdmaCellLocation.getBaseStationId();
            sb.append(systemId);
            sb.append("||");
            sb.append(networkId);
            sb.append("||");
            sb.append(baseStationId);
            sb.append("&bttype=cdma");
        }
        return sb.toString();
    }

    public static String getConnectWifi(Context context) {
        if (context == null) {
            return null;
        }
        try {
            if (context.checkCallingOrSelfPermission(WIFISTATE) != 0) {
                return null;
            }
            WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
            if (wifiManager.isWifiEnabled()) {
                return wifiManager.getConnectionInfo().getBSSID();
            }
            return null;
        } catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    public static String getCoreMNC(Context context) {
        try {
            return getMNC(context);
        } catch (Throwable th) {
            th.printStackTrace();
            return "";
        }
    }

    public static String getDeviceID(Context context) {
        try {
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (mDeviceId != null && !"".equals(mDeviceId)) {
            return mDeviceId;
        }
        mDeviceId = a.a(context);
        return mDeviceId;
    }

    public static String getDeviceMac(Context context) {
        try {
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (mMacAddress != null && !"".equals(mMacAddress)) {
            return mMacAddress;
        }
        mMacAddress = a.f(context);
        return mMacAddress;
    }

    public static String getMNC(Context context) {
        try {
            if (context.checkCallingOrSelfPermission(PHONESTATE) != 0) {
                return "";
            }
            String networkOperator = ((TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE)).getNetworkOperator();
            return (!TextUtils.isEmpty(networkOperator) || networkOperator.length() >= 3) ? networkOperator.substring(3) : "";
        } catch (Throwable th) {
            th.printStackTrace();
            return "";
        }
    }

    public static int getNetWorkType(Context context) {
        if (context.checkCallingOrSelfPermission(PHONESTATE) != 0) {
            return -1;
        }
        return ((TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE)).getNetworkType();
    }

    public static String getNetworkOperatorName(Context context) {
        if (context.checkCallingOrSelfPermission(PHONESTATE) != 0) {
            return networkOperatorName;
        }
        String simOperatorName = ((TelephonyManager) context.getSystemService(StandardProtocolKey.PHONE)).getSimOperatorName();
        networkOperatorName = simOperatorName;
        return simOperatorName;
    }

    public static String getReslution(Context context) {
        StringBuilder sb;
        try {
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (mReslution != null && !"".equals(mReslution)) {
            return mReslution;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager) context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        int i = displayMetrics.widthPixels;
        int i2 = displayMetrics.heightPixels;
        if (i2 > i) {
            sb = new StringBuilder();
            sb.append(i);
            sb.append("*");
            sb.append(i2);
        } else {
            sb = new StringBuilder();
            sb.append(i2);
            sb.append("*");
            sb.append(i);
        }
        mReslution = sb.toString();
        return mReslution;
    }

    public static String getSubscriberId(Context context) {
        String str = mSubscriberId;
        if (str != null && !"".equals(str)) {
            return mSubscriberId;
        }
        String d = a.d(context);
        mSubscriberId = d;
        if (d == null) {
            mSubscriberId = "";
        }
        return mSubscriberId;
    }

    public static String getWifiMacs(Context context) {
        StringBuilder sb = new StringBuilder();
        if (context != null) {
            try {
            } catch (Throwable th) {
                th.printStackTrace();
            }
            if (context.checkCallingOrSelfPermission(WIFISTATE) == 0) {
                WifiManager wifiManager = (WifiManager) context.getSystemService("wifi");
                if (wifiManager.isWifiEnabled()) {
                    List<ScanResult> scanResults = wifiManager.getScanResults();
                    if (scanResults != null && scanResults.size() != 0) {
                        List<ScanResult> doChooseSort = doChooseSort(scanResults);
                        boolean z = true;
                        for (int i = 0; i < doChooseSort.size() && i < 10; i++) {
                            ScanResult scanResult = doChooseSort.get(i);
                            if (z) {
                                z = false;
                            } else {
                                sb.append(";");
                            }
                            sb.append(scanResult.BSSID);
                        }
                    }
                    return sb.toString();
                }
                return sb.toString();
            }
        }
        return sb.toString();
    }
}
