package com.autonavi.indoor.util;

/* loaded from: classes.dex */
public class DigitalTrans {
    public static String algorismToHEXString(int i, int i2) {
        String hexString = Integer.toHexString(i);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return patchHexString(hexString.toUpperCase(), i2);
    }

    public static String asciiStringToString(String str) {
        int length = str.length() / 2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int i2 = i * 2;
            stringBuffer.append(String.valueOf((char) hexStringToAlgorism(str.substring(i2, i2 + 2))));
        }
        return stringBuffer.toString();
    }

    public static int binaryToAlgorism(String str) {
        int i = 0;
        for (int length = str.length(); length > 0; length--) {
            int charAt = str.charAt(length - 1) - '0';
            double d = i;
            double pow = Math.pow(2.0d, r0 - length);
            double d2 = charAt;
            Double.isNaN(d2);
            Double.isNaN(d);
            i = (int) (d + (pow * d2));
        }
        return i;
    }

    public static final String byte2hex(byte[] bArr) {
        if (bArr != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (byte b : bArr) {
                String hexString = Integer.toHexString(b & 255);
                if (hexString.length() == 1) {
                    stringBuffer.append("0" + hexString);
                } else {
                    stringBuffer.append(hexString);
                }
            }
            return stringBuffer.toString().toUpperCase();
        }
        throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
    }

    public static String bytetoString(byte[] bArr) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte b : bArr) {
            stringBuffer.append((char) b);
        }
        return stringBuffer.toString();
    }

    public static final byte[] hex2byte(String str) throws IllegalArgumentException {
        if (str.length() % 2 == 0) {
            char[] charArray = str.toCharArray();
            byte[] bArr = new byte[str.length() / 2];
            int length = str.length();
            int i = 0;
            int i2 = 0;
            while (i < length) {
                StringBuilder sb = new StringBuilder();
                sb.append("");
                int i3 = i + 1;
                sb.append(charArray[i]);
                sb.append(charArray[i3]);
                bArr[i2] = Integer.valueOf(Integer.parseInt(sb.toString(), 16) & 255).byteValue();
                i = i3 + 1;
                i2++;
            }
            return bArr;
        }
        throw new IllegalArgumentException();
    }

    public static int hexStringToAlgorism(String str) {
        String upperCase = str.toUpperCase();
        int i = 0;
        for (int length = upperCase.length(); length > 0; length--) {
            char charAt = upperCase.charAt(length - 1);
            int i2 = (charAt < '0' || charAt > '9') ? charAt - '7' : charAt - '0';
            double d = i;
            double pow = Math.pow(16.0d, r0 - length);
            double d2 = i2;
            Double.isNaN(d2);
            Double.isNaN(d);
            i = (int) (d + (pow * d2));
        }
        return i;
    }

    public static String hexStringToBinary(String str) {
        String upperCase = str.toUpperCase();
        int length = upperCase.length();
        String str2 = "";
        for (int i = 0; i < length; i++) {
            char charAt = upperCase.charAt(i);
            switch (charAt) {
                case '0':
                    str2 = str2 + "0000";
                    break;
                case '1':
                    str2 = str2 + "0001";
                    break;
                case '2':
                    str2 = str2 + "0010";
                    break;
                case '3':
                    str2 = str2 + "0011";
                    break;
                case '4':
                    str2 = str2 + "0100";
                    break;
                case '5':
                    str2 = str2 + "0101";
                    break;
                case '6':
                    str2 = str2 + "0110";
                    break;
                case '7':
                    str2 = str2 + "0111";
                    break;
                case '8':
                    str2 = str2 + "1000";
                    break;
                case '9':
                    str2 = str2 + "1001";
                    break;
                default:
                    switch (charAt) {
                        case 'A':
                            str2 = str2 + "1010";
                            break;
                        case 'B':
                            str2 = str2 + "1011";
                            break;
                        case 'C':
                            str2 = str2 + "1100";
                            break;
                        case 'D':
                            str2 = str2 + "1101";
                            break;
                        case 'E':
                            str2 = str2 + "1110";
                            break;
                        case 'F':
                            str2 = str2 + "1111";
                            break;
                    }
            }
        }
        return str2;
    }

    public static byte[] hexStringToByte(String str) {
        int length = str.length() / 2;
        byte[] bArr = new byte[length];
        String hexStringToBinary = hexStringToBinary(str);
        int i = 0;
        while (i < length) {
            int i2 = i * 8;
            int i3 = i + 1;
            bArr[i] = (byte) binaryToAlgorism(hexStringToBinary.substring(i2 + 1, i3 * 8));
            if (hexStringToBinary.charAt(i2) == '1') {
                bArr[i] = (byte) (0 - bArr[i]);
            }
            i = i3;
        }
        return bArr;
    }

    public static String hexStringToString(String str, int i) {
        int length = str.length() / i;
        StringBuffer stringBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < length) {
            int i3 = i2 * i;
            i2++;
            stringBuffer.append((char) hexStringToAlgorism(str.substring(i3, i2 * i)));
        }
        return stringBuffer.toString();
    }

    public static int parseToInt(String str, int i, int i2) {
        try {
            return Integer.parseInt(str, i2);
        } catch (NumberFormatException unused) {
            return i;
        }
    }

    public static String patchHexString(String str, int i) {
        String str2 = "";
        for (int i2 = 0; i2 < i - str.length(); i2++) {
            str2 = "0" + str2;
        }
        return (str2 + str).substring(0, i);
    }

    public static String stringToAsciiString(String str) {
        int length = str.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; i++) {
            stringBuffer.append(Integer.toHexString(str.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static int parseToInt(String str, int i) {
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException unused) {
            return i;
        }
    }

    public static String algorismToHEXString(int i) {
        String hexString = Integer.toHexString(i);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return hexString.toUpperCase();
    }
}
