package com.autonavi.indoor.util;

import android.content.Context;
import android.os.Environment;
import android.provider.Settings;
import com.amap.location.common.f.g;
import com.autonavi.amapauto.protocol.constant.StandardProtocolKey;
import com.autonavi.eaglet.surfacemng.cfg.ConfigLoader;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/* loaded from: classes.dex */
public class EncryptHelper {
    public static final String AESMODE = "AES/CBC/PKCS5Padding";
    public static final String RSAMODE = "RSA/ECB/PKCS1Padding";
    public static final String UM_SETTINGS_STORAGE_NEW = "mqBRboGZkQPcAkyk";
    public static final String UTID_FILE = "/.UTSystemConfig/Global/Alvin2.xml";
    public static boolean isUtdidFlag;
    public static String mUtidid;
    public static final char[] base64EncodeChars = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final byte[] base64DecodeChars = new byte[128];

    /* loaded from: classes.dex */
    public static class UTDXMLHandler extends DefaultHandler {
        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void characters(char[] cArr, int i, int i2) throws SAXException {
            if (EncryptHelper.isUtdidFlag) {
                String unused = EncryptHelper.mUtidid = new String(cArr, i, i2);
            }
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void endElement(String str, String str2, String str3) throws SAXException {
            boolean unused = EncryptHelper.isUtdidFlag = false;
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void startElement(String str, String str2, String str3, Attributes attributes) throws SAXException {
            if (str2.equals(ConfigLoader.TAG_NEW_CONFIG) && "UTDID".equals(attributes.getValue(StandardProtocolKey.NAME))) {
                boolean unused = EncryptHelper.isUtdidFlag = true;
            }
        }
    }

    static {
        for (int i = 0; i < 128; i++) {
            base64DecodeChars[i] = -1;
        }
        for (int i2 = 65; i2 <= 90; i2++) {
            base64DecodeChars[i2] = (byte) (i2 - 65);
        }
        for (int i3 = 97; i3 <= 122; i3++) {
            base64DecodeChars[i3] = (byte) ((i3 - 97) + 26);
        }
        for (int i4 = 48; i4 <= 57; i4++) {
            base64DecodeChars[i4] = (byte) ((i4 - 48) + 52);
        }
        byte[] bArr = base64DecodeChars;
        bArr[43] = 62;
        bArr[47] = 63;
        mUtidid = "";
        isUtdidFlag = false;
    }

    /* JADX WARN: Code restructure failed: missing block: B:28:0x005a, code lost:            if (r5 != (-1)) goto L34;     */
    /* JADX WARN: Code restructure failed: missing block: B:29:0x005d, code lost:            r2.write(((r4 & 15) << 4) | ((r5 & 60) >>> 2));     */
    /* JADX WARN: Code restructure failed: missing block: B:30:0x0069, code lost:            r4 = r0 + 1;        r0 = r8[r0];     */
    /* JADX WARN: Code restructure failed: missing block: B:31:0x006d, code lost:            if (r0 != 61) goto L39;     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x0074, code lost:            r0 = com.autonavi.indoor.util.EncryptHelper.base64DecodeChars[r0];     */
    /* JADX WARN: Code restructure failed: missing block: B:33:0x0078, code lost:            if (r4 >= r1) goto L62;     */
    /* JADX WARN: Code restructure failed: missing block: B:34:0x007a, code lost:            if (r0 == (-1)) goto L43;     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x007d, code lost:            r0 = r4;     */
    /* JADX WARN: Code restructure failed: missing block: B:37:0x007f, code lost:            if (r0 != (-1)) goto L46;     */
    /* JADX WARN: Code restructure failed: missing block: B:38:0x0082, code lost:            r2.write(r0 | ((r5 & 3) << 6));        r0 = r4;     */
    /* JADX WARN: Code restructure failed: missing block: B:45:0x0073, code lost:            return r2.toByteArray();     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static byte[] decodeBase64(java.lang.String r8) {
        /*
            r0 = 0
            if (r8 != 0) goto L6
            byte[] r8 = new byte[r0]
            return r8
        L6:
            byte[] r8 = r8.getBytes()
            int r1 = r8.length
            java.io.ByteArrayOutputStream r2 = new java.io.ByteArrayOutputStream
            r2.<init>(r1)
        L10:
            if (r0 >= r1) goto L8c
        L12:
            byte[] r3 = com.autonavi.indoor.util.EncryptHelper.base64DecodeChars
            int r4 = r0 + 1
            r0 = r8[r0]
            r0 = r3[r0]
            r3 = -1
            if (r4 >= r1) goto L22
            if (r0 == r3) goto L20
            goto L22
        L20:
            r0 = r4
            goto L12
        L22:
            if (r0 != r3) goto L26
            goto L8c
        L26:
            byte[] r5 = com.autonavi.indoor.util.EncryptHelper.base64DecodeChars
            int r6 = r4 + 1
            r4 = r8[r4]
            r4 = r5[r4]
            if (r6 >= r1) goto L35
            if (r4 == r3) goto L33
            goto L35
        L33:
            r4 = r6
            goto L26
        L35:
            if (r4 != r3) goto L38
            goto L8c
        L38:
            int r0 = r0 << 2
            r5 = r4 & 48
            int r5 = r5 >>> 4
            r0 = r0 | r5
            r2.write(r0)
        L42:
            int r0 = r6 + 1
            r5 = r8[r6]
            r6 = 61
            if (r5 != r6) goto L4f
            byte[] r8 = r2.toByteArray()
            return r8
        L4f:
            byte[] r7 = com.autonavi.indoor.util.EncryptHelper.base64DecodeChars
            r5 = r7[r5]
            if (r0 >= r1) goto L5a
            if (r5 == r3) goto L58
            goto L5a
        L58:
            r6 = r0
            goto L42
        L5a:
            if (r5 != r3) goto L5d
            goto L8c
        L5d:
            r4 = r4 & 15
            int r4 = r4 << 4
            r7 = r5 & 60
            int r7 = r7 >>> 2
            r4 = r4 | r7
            r2.write(r4)
        L69:
            int r4 = r0 + 1
            r0 = r8[r0]
            if (r0 != r6) goto L74
            byte[] r8 = r2.toByteArray()
            return r8
        L74:
            byte[] r7 = com.autonavi.indoor.util.EncryptHelper.base64DecodeChars
            r0 = r7[r0]
            if (r4 >= r1) goto L7f
            if (r0 == r3) goto L7d
            goto L7f
        L7d:
            r0 = r4
            goto L69
        L7f:
            if (r0 != r3) goto L82
            goto L8c
        L82:
            r3 = r5 & 3
            int r3 = r3 << 6
            r0 = r0 | r3
            r2.write(r0)
            r0 = r4
            goto L10
        L8c:
            byte[] r8 = r2.toByteArray()
            return r8
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.indoor.util.EncryptHelper.decodeBase64(java.lang.String):byte[]");
    }

    /* JADX WARN: Removed duplicated region for block: B:16:0x004d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static java.security.PublicKey getPublicKey(android.content.Context r3) throws java.security.cert.CertificateException, java.security.spec.InvalidKeySpecException, java.security.NoSuchAlgorithmException, java.lang.NullPointerException, java.io.IOException {
        /*
            r3 = 674(0x2a2, float:9.44E-43)
            byte[] r3 = new byte[r3]
            r3 = {x005a: FILL_ARRAY_DATA , data: [48, -126, 2, -98, 48, -126, 2, 7, -96, 3, 2, 1, 2, 2, 9, 0, -99, 15, 119, 58, 44, -19, -105, -40, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 67, 78, 49, 19, 48, 17, 6, 3, 85, 4, 8, 12, 10, 83, 111, 109, 101, 45, 83, 116, 97, 116, 101, 49, 16, 48, 14, 6, 3, 85, 4, 7, 12, 7, 66, 101, 105, 106, 105, 110, 103, 49, 17, 48, 15, 6, 3, 85, 4, 10, 12, 8, 65, 117, 116, 111, 110, 97, 118, 105, 49, 31, 48, 29, 6, 3, 85, 4, 3, 12, 22, 99, 111, 109, 46, 97, 117, 116, 111, 110, 97, 118, 105, 46, 97, 112, 105, 115, 101, 114, 118, 101, 114, 48, 30, 23, 13, 49, 51, 48, 56, 49, 53, 48, 55, 53, 54, 53, 53, 90, 23, 13, 50, 51, 48, 56, 49, 51, 48, 55, 53, 54, 53, 53, 90, 48, 104, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 67, 78, 49, 19, 48, 17, 6, 3, 85, 4, 8, 12, 10, 83, 111, 109, 101, 45, 83, 116, 97, 116, 101, 49, 16, 48, 14, 6, 3, 85, 4, 7, 12, 7, 66, 101, 105, 106, 105, 110, 103, 49, 17, 48, 15, 6, 3, 85, 4, 10, 12, 8, 65, 117, 116, 111, 110, 97, 118, 105, 49, 31, 48, 29, 6, 3, 85, 4, 3, 12, 22, 99, 111, 109, 46, 97, 117, 116, 111, 110, 97, 118, 105, 46, 97, 112, 105, 115, 101, 114, 118, 101, 114, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -15, -27, -128, -56, 118, -59, 62, -127, 79, 125, -36, 121, 0, 63, -125, -30, 118, 5, -85, -121, 91, 39, 90, 123, 72, -126, -83, -41, -45, -77, -42, -120, -81, 23, -2, -121, -29, 123, -7, 22, -114, -20, -25, 74, 67, -43, 65, 124, -7, 11, -72, 38, -123, 16, -58, 80, 32, 58, -33, 14, 11, 36, 60, 13, -121, 100, 105, -32, 123, -31, 114, -101, -41, 12, 100, 33, -120, 63, 126, -123, 48, 55, 80, -116, 28, -10, 125, 59, -41, -95, -126, 118, -70, 43, -127, 9, 93, -100, 81, -19, -114, -41, 85, -103, -37, -116, 118, 72, 86, 125, -43, -92, -11, 63, 69, -38, -10, -65, 126, -53, -115, 60, 62, -86, -80, 1, 39, 19, 2, 3, 1, 0, 1, -93, 80, 48, 78, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -29, 63, 48, -79, -113, -13, 26, 85, 22, -27, 93, -5, 122, -103, -109, 14, -18, 6, -13, -109, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -29, 63, 48, -79, -113, -13, 26, 85, 22, -27, 93, -5, 122, -103, -109, 14, -18, 6, -13, -109, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -32, -74, 55, -125, -58, -128, 15, -62, 100, -60, 3, -86, 81, 112, -61, -56, -69, -126, 8, 99, -100, -38, -108, -56, -122, 125, 19, -64, -61, 90, 85, -47, -8, -123, -103, 105, 77, -32, -65, -62, -28, 67, -28, -78, 116, -49, 120, -2, 33, 13, 47, 46, -5, -112, 3, -101, -125, -115, 92, -124, 58, 80, 107, -67, 82, 6, -63, 39, -90, -1, 85, -58, 82, -115, 119, 13, -4, -32, 0, -98, 100, -41, 94, -75, 75, -103, 126, -80, 85, 40, -27, 60, 105, 28, -27, -21, -15, -98, 103, -88, -109, 35, -119, -27, -26, -122, 113, 63, 35, -33, 70, 23, 33, -23, 66, 108, 56, 112, 46, -85, -123, -123, 33, 118, 27, 96, -7, -103} // fill-array
            r0 = 0
            java.io.ByteArrayInputStream r1 = new java.io.ByteArrayInputStream     // Catch: java.lang.Throwable -> L26
            r1.<init>(r3)     // Catch: java.lang.Throwable -> L26
            java.lang.String r3 = "X.509"
            java.security.cert.CertificateFactory r3 = java.security.cert.CertificateFactory.getInstance(r3)     // Catch: java.lang.Throwable -> L23
            java.lang.String r2 = "RSA"
            java.security.KeyFactory r2 = java.security.KeyFactory.getInstance(r2)     // Catch: java.lang.Throwable -> L23
            java.security.cert.Certificate r3 = r3.generateCertificate(r1)     // Catch: java.lang.Throwable -> L21
            r1.close()
            goto L32
        L21:
            r3 = move-exception
            goto L29
        L23:
            r3 = move-exception
            r2 = r0
            goto L29
        L26:
            r3 = move-exception
            r1 = r0
            r2 = r1
        L29:
            r3.printStackTrace()     // Catch: java.lang.Throwable -> L53
            if (r1 == 0) goto L31
            r1.close()
        L31:
            r3 = r0
        L32:
            if (r3 == 0) goto L49
            if (r2 != 0) goto L37
            goto L49
        L37:
            java.security.spec.X509EncodedKeySpec r0 = new java.security.spec.X509EncodedKeySpec
            java.security.PublicKey r3 = r3.getPublicKey()
            byte[] r3 = r3.getEncoded()
            r0.<init>(r3)
            java.security.PublicKey r3 = r2.generatePublic(r0)
            return r3
        L49:
            boolean r3 = com.autonavi.indoor.util.L.isLogging
            if (r3 == 0) goto L52
            java.lang.String r3 = "PublicKey has null"
            com.autonavi.indoor.util.L.d(r3)
        L52:
            return r0
        L53:
            r3 = move-exception
            if (r1 == 0) goto L59
            r1.close()
        L59:
            throw r3
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.indoor.util.EncryptHelper.getPublicKey(android.content.Context):java.security.PublicKey");
    }

    public static String getUTDID(Context context) {
        try {
        } catch (Throwable th) {
            th.printStackTrace();
        }
        if (mUtidid != null && !"".equals(mUtidid)) {
            return mUtidid;
        }
        if (context.checkCallingOrSelfPermission("android.permission.WRITE_SETTINGS") == 0) {
            mUtidid = Settings.System.getString(context.getContentResolver(), UM_SETTINGS_STORAGE_NEW);
        }
        if (mUtidid != null && !"".equals(mUtidid)) {
            return mUtidid;
        }
        try {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                File file = new File(g.a(context) + UTID_FILE);
                if (file.exists()) {
                    SAXParserFactory.newInstance().newSAXParser().parse(file, new UTDXMLHandler());
                }
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        return mUtidid;
    }

    public static byte[] privateAesEncrypt(byte[] bArr, byte[] bArr2) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String[] split = new StringBuffer("16,16,18,77,15,911,121,77,121,911,38,77,911,99,86,67,611,96,48,77,84,911,38,67,021,301,86,67,611,98,48,77,511,77,48,97,511,58,48,97,511,84,501,87,511,96,48,77,221,911,38,77,121,37,86,67,25,301,86,67,021,96,86,67,021,701,86,67,35,56,86,67,611,37,221,87").reverse().toString().split(",");
        byte[] bArr3 = new byte[split.length];
        for (int i = 0; i < split.length; i++) {
            bArr3[i] = Byte.parseByte(split[i]);
        }
        String[] split2 = new StringBuffer(new String(decodeBase64(new String(bArr3)))).reverse().toString().split(",");
        byte[] bArr4 = new byte[split2.length];
        for (int i2 = 0; i2 < split2.length; i2++) {
            bArr4[i2] = Byte.parseByte(split2[i2]);
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(bArr4);
        SecretKeySpec secretKeySpec = new SecretKeySpec(bArr, "AES");
        Cipher cipher = Cipher.getInstance(AESMODE);
        try {
            cipher.init(1, secretKeySpec, ivParameterSpec);
        } catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        return cipher.doFinal(bArr2);
    }

    public static String privateEncodeBase64(byte[] bArr) {
        StringBuffer stringBuffer = new StringBuffer();
        int length = bArr.length;
        int i = 0;
        while (true) {
            if (i >= length) {
                break;
            }
            int i2 = i + 1;
            int i3 = bArr[i] & 255;
            if (i2 == length) {
                stringBuffer.append(base64EncodeChars[i3 >>> 2]);
                stringBuffer.append(base64EncodeChars[(i3 & 3) << 4]);
                stringBuffer.append("==");
                break;
            }
            int i4 = i2 + 1;
            int i5 = bArr[i2] & 255;
            if (i4 == length) {
                stringBuffer.append(base64EncodeChars[i3 >>> 2]);
                stringBuffer.append(base64EncodeChars[((i3 & 3) << 4) | ((i5 & 240) >>> 4)]);
                stringBuffer.append(base64EncodeChars[(i5 & 15) << 2]);
                stringBuffer.append("=");
                break;
            }
            int i6 = i4 + 1;
            int i7 = bArr[i4] & 255;
            stringBuffer.append(base64EncodeChars[i3 >>> 2]);
            stringBuffer.append(base64EncodeChars[((i3 & 3) << 4) | ((i5 & 240) >>> 4)]);
            stringBuffer.append(base64EncodeChars[((i5 & 15) << 2) | ((i7 & 192) >>> 6)]);
            stringBuffer.append(base64EncodeChars[i7 & 63]);
            i = i6;
        }
        return stringBuffer.toString();
    }

    public static String privateRsaAesData(Context context, byte[] bArr) throws InvalidKeyException, IOException, InvalidKeySpecException, NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, CertificateException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        byte[] encoded = keyGenerator.generateKey().getEncoded();
        PublicKey publicKey = getPublicKey(context);
        if (publicKey == null) {
            if (!L.isLogging) {
                return null;
            }
            L.d("key is empty");
            return null;
        }
        byte[] rsaEncrypt = rsaEncrypt(encoded, publicKey);
        byte[] privateAesEncrypt = privateAesEncrypt(encoded, bArr);
        byte[] bArr2 = new byte[rsaEncrypt.length + privateAesEncrypt.length];
        System.arraycopy(rsaEncrypt, 0, bArr2, 0, rsaEncrypt.length);
        System.arraycopy(privateAesEncrypt, 0, bArr2, rsaEncrypt.length, privateAesEncrypt.length);
        byte[] bArr3 = new byte[0];
        try {
            bArr3 = Utils.gzip(bArr2);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        return bArr3 != null ? privateEncodeBase64(bArr3) : "";
    }

    public static byte[] rsaEncrypt(byte[] bArr, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSAMODE);
        cipher.init(1, key);
        return cipher.doFinal(bArr);
    }
}
