package com.autonavi.indoor.util;

import android.text.TextUtils;
import com.autonavi.amapauto.user.UserPhone;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.entity.ScanPair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/* loaded from: classes.dex */
public class FileLogger {
    public FileOutputStream a;
    public File b = null;
    public boolean isLogging = false;

    public void d(ScanData scanData) {
        if (L.sDebug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ble:" + scanData.time_ + ",");
            for (ScanPair scanPair : scanData.scans_) {
                stringBuffer.append(scanPair.mID + UserPhone.SPECIAL_LETTER + scanPair.mRSSI + "$");
            }
            d(stringBuffer.toString());
        }
    }

    public boolean start(String str) {
        if (!L.sDebug) {
            return false;
        }
        if (!new File(str).isDirectory()) {
            if (L.isLogging) {
                L.d("File Log not enabled because of input dir is not exist" + str);
            }
            return false;
        }
        this.b = new File(str, new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA).format(new Date()) + "java.txt");
        if (L.isLogging) {
            L.d("Log:" + this.b.getName());
        }
        try {
            this.a = new FileOutputStream(this.b, true);
            this.isLogging = true;
            return true;
        } catch (FileNotFoundException e) {
            if (L.isLogging) {
                L.d("Failed to start fileLog" + e.toString());
            }
            return false;
        }
    }

    public void stop() {
        if (this.isLogging) {
            try {
                this.a.close();
                this.b = null;
                this.isLogging = false;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void d(String str) {
        if (!this.isLogging || TextUtils.isEmpty(str)) {
            return;
        }
        try {
            this.a.write((str + "\n").getBytes());
            this.a.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
