package com.autonavi.indoor.util;

import android.content.Context;
import android.os.Process;
import com.amap.location.common.e.a;
import com.amap.location.common.f.g;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/* loaded from: classes.dex */
public class L {
    public static boolean isLogging;
    public static FileOutputStream mFileOutputStream;
    public static File mLogFile;
    public static boolean mSave2File;
    public static boolean sDebug;
    public static final String logcatPath = g.a((Context) null) + "/autonavi/indoor/logcat";
    public static final String logalgoPath = g.a((Context) null) + "/autonavi/indoor/logalgo";

    static {
        onCreate();
    }

    public static void createFile() {
        try {
            File file = new File(logcatPath);
            if (!file.exists()) {
                mSave2File = false;
                return;
            }
            File file2 = new File(file, new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA).format(new Date()) + ".txt");
            mLogFile = file2;
            if (!file2.exists() && !mLogFile.createNewFile()) {
                a.a("Locating", "failed to create logfile");
                mSave2File = false;
            } else {
                mFileOutputStream = new FileOutputStream(mLogFile, true);
            }
        } catch (Throwable th) {
            mLogFile = null;
            mSave2File = false;
            a.a("Locating", "L.createFile:" + th.toString());
        }
    }

    public static void d(String str, String str2) {
        a.a(str, str2);
        if (mSave2File) {
            if (mLogFile == null) {
                createFile();
            }
            if (mFileOutputStream == null) {
                return;
            }
            try {
                mFileOutputStream.write((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA).format(new Date()) + "\tpid=" + Process.myPid() + " tid=" + Thread.currentThread().getId() + "(" + Thread.currentThread().getName() + ")\t" + str2 + "\n").getBytes());
                mFileOutputStream.flush();
            } catch (Throwable th) {
                a.a(str, "L:" + th.toString());
            }
        }
    }

    public static void destroy() {
        try {
            mFileOutputStream.close();
            mFileOutputStream = null;
            mLogFile = null;
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static boolean isSilent() {
        return !isLogging;
    }

    public static void logStackTrace(String str) {
        if (isSilent()) {
            return;
        }
        d(str, 2);
        d("Caller " + str, 3);
    }

    public static void onCreate() {
        try {
            new Thread() { // from class: com.autonavi.indoor.util.L.1
                @Override // java.lang.Thread, java.lang.Runnable
                public void run() {
                    L.isLogging = new File(L.logcatPath).exists() && L.sDebug;
                    L.mSave2File = new File(L.logcatPath).isDirectory() && L.sDebug;
                    a.a("Locating", "Log instrument onCreate success.isLogging:" + L.isLogging + ", mSave2File:" + L.mSave2File);
                }
            }.start();
        } catch (Throwable th) {
            a.a(th);
        }
    }

    public static void logStackTrace() {
        if (isSilent()) {
            return;
        }
        new Error().printStackTrace();
    }

    public static void d(String str) {
        d(str, 2);
    }

    public static void d(Object obj) {
        d(obj + "", 2);
    }

    public static void d(String str, int i) {
        String substring;
        if (isSilent()) {
            return;
        }
        StackTraceElement[] stackTrace = new Error().getStackTrace();
        if (stackTrace.length == 0) {
            a.a("Locating", "getStackTrace() is empty!");
            return;
        }
        if (i >= stackTrace.length) {
            a.a("Locating", "getStackTrace() is not enough. n:" + i + ", length:" + stackTrace.length);
            return;
        }
        String stackTraceElement = stackTrace[i].toString();
        try {
            String substring2 = stackTraceElement.substring(0, stackTraceElement.lastIndexOf("("));
            int lastIndexOf = substring2.lastIndexOf("$");
            if (lastIndexOf < 0) {
                String substring3 = substring2.substring(0, substring2.lastIndexOf(""));
                substring = stackTraceElement.replace(substring3.substring(0, substring3.lastIndexOf("")), "");
            } else {
                substring = stackTraceElement.substring(lastIndexOf);
            }
            d("Locating", str + "\t[" + substring + "]");
        } catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void d(byte[] bArr) {
        if (isSilent()) {
            return;
        }
        if (bArr != null && bArr.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bArr) {
                sb.append(String.format("%02X", Integer.valueOf(b & 255)));
            }
            d("[" + bArr.length + "]:" + ((Object) sb), 2);
            return;
        }
        d("buf is null", 2);
    }

    public static void d(String str, byte[] bArr) {
        if (isSilent()) {
            return;
        }
        if (bArr != null && bArr.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bArr) {
                sb.append(String.format("%02X", Integer.valueOf(b & 255)));
            }
            d(str + "[" + bArr.length + "]:" + ((Object) sb), 2);
            return;
        }
        d("buf is null", 2);
    }

    public static void d(Throwable th) {
        if (isSilent()) {
            return;
        }
        d(th.getMessage(), 2);
        StringWriter stringWriter = new StringWriter();
        th.printStackTrace(new PrintWriter(stringWriter));
        d(stringWriter.toString(), 2);
    }
}
