package com.autonavi.indoor.util;

import com.autonavi.indoor.entity.Beacon;
import java.nio.ByteBuffer;

/* loaded from: classes.dex */
public class MacUtils {
    public static String encodeBleID(Beacon beacon) {
        return beacon.getUUID().replace("-", "") + "_" + DigitalTrans.algorismToHEXString(beacon.getMajor(), 4) + "_" + DigitalTrans.algorismToHEXString(beacon.getMinor(), 4);
    }

    public static byte[] encodeMac(String str) {
        return encodeMac2SixByte(encodeMacLong(str));
    }

    public static byte[] encodeMac2SixByte(long j) {
        byte[] bArr = new byte[6];
        for (int i = 5; i >= 0; i--) {
            bArr[i] = (byte) j;
            j >>= 8;
        }
        return bArr;
    }

    public static long encodeMacLong(String str) {
        String replace = str.replace(":", "").replace("_", "").replace(" ", "").replace("", "");
        if (replace != null && replace.length() == 12) {
            return Long.parseLong(replace, 16);
        }
        if (!L.isLogging) {
            return 0L;
        }
        L.d("mac=" + replace);
        return 0L;
    }

    public static String encodeWifiMac(long j) {
        return macString(j);
    }

    public static String macString(long j) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; i++) {
            sb.append(String.format("%02x:", Long.valueOf((j >> (40 - (i * 8))) & 255)));
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static void writeMac2Buffer(String str, ByteBuffer byteBuffer) {
        byte[] bytes = str.getBytes();
        byteBuffer.put((byte) bytes.length);
        byteBuffer.put(bytes);
    }

    public static void writeMac2SixByteBuffer(String str, ByteBuffer byteBuffer) {
        if (str != null && str.length() != 0) {
            byteBuffer.put(encodeMac2SixByte(encodeMacLong(str)));
        } else {
            MapUtils.putDummyData(byteBuffer, 6);
        }
    }

    public static String encodeWifiMac(String str) {
        return str.replace(':', '_');
    }

    public static long encodeMacLong(byte[] bArr) {
        long j = 0;
        if (bArr != null && bArr.length >= 6) {
            for (int i = 0; i < 6; i++) {
                j = (j << 8) + (bArr[i] & 255);
            }
        }
        return j;
    }

    public static String macString(byte[] bArr) {
        if (bArr == null || bArr.length < 6) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; i++) {
            sb.append(String.format("%02x:", Byte.valueOf(bArr[i])));
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}
