package com.autonavi.indoor.util;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.amap.location.common.e.a;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/* loaded from: classes.dex */
public class MapUtils {
    public static boolean isWifiConnected = false;
    public static String mBluetoothAddress = "";
    public static String mImei = "";
    public static String mImsi = "";
    public static String mWifiAddress = "";
    public static AosEncryptor sAosEncryptor;

    /* loaded from: classes.dex */
    public interface AosEncryptor {
        String amapEncode(String str);

        byte[] amapEncode(byte[] bArr);
    }

    public static String amapEncode(String str) {
        AosEncryptor aosEncryptor = sAosEncryptor;
        if (aosEncryptor != null) {
            return aosEncryptor.amapEncode(str);
        }
        a.c("MapUtils", "indoor aos encryptor-str is null");
        return null;
    }

    public static byte[] amapEncodeBody(byte[] bArr) {
        return bArr;
    }

    public static String amapEncodeUrl(String str) {
        try {
            String[] split = str.split("\\?", 2);
            if (split.length != 2) {
                return str;
            }
            String amapEncode = amapEncode(split[1]);
            if (TextUtils.isEmpty(amapEncode)) {
                return str;
            }
            return split[0] + "?in=" + URLEncoder.encode(amapEncode, "UTF-8") + "&ent=2&is_bin=1";
        } catch (Throwable th) {
            if (!L.isLogging) {
                return str;
            }
            L.d(th);
            return str;
        }
    }

    public static byte[] copyOf(byte[] bArr, int i) {
        return copyOf(bArr, 0, i);
    }

    public static byte[] decryptAES(byte[] bArr, byte[] bArr2) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(bArr2, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(bArr);
        } catch (Throwable th) {
            if (!L.isLogging) {
                return null;
            }
            L.d(th);
            return null;
        }
    }

    public static double distance(double d, double d2, double d3, double d4) {
        double cos = Math.cos((((d2 + d4) / 2.0d) * 3.141592653589793d) / 180.0d);
        double d5 = 1.2350480292838154E10d / ((1.003364139422145d * (1.0d - (cos * cos))) + ((0.9966471400661353d * cos) * cos));
        double d6 = cos * (d - d3) * 1.0025d;
        double d7 = d2 - d4;
        return Math.sqrt(d5 * ((d6 * d6) + (d7 * d7)));
    }

    public static byte[] encodeMac(String str) {
        return encodeMac2SixByte(encodeMacLong(str));
    }

    public static byte[] encodeMac2SixByte(long j) {
        byte[] bArr = new byte[6];
        for (int i = 5; i >= 0; i--) {
            bArr[i] = (byte) j;
            j >>= 8;
        }
        return bArr;
    }

    public static long encodeMacLong(String str) {
        String replace = str.replace(":", "").replace("_", "").replace(" ", "").replace("", "");
        if (replace != null && replace.length() == 12) {
            return Long.parseLong(replace, 16);
        }
        if (L.isLogging) {
            L.d("mac=" + replace);
        }
        L.logStackTrace();
        return 0L;
    }

    public static String encodeWifiMac(long j) {
        return macString(j);
    }

    public static String getBluetoothAddress() {
        String str;
        str = "";
        try {
            BluetoothAdapter defaultAdapter = BluetoothAdapter.getDefaultAdapter();
            str = defaultAdapter != null ? defaultAdapter.getAddress() : "";
            mBluetoothAddress = str;
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        return str;
    }

    public static String getImei(Context context) {
        if (context == null) {
            if (L.isLogging) {
                L.d("context is null");
            }
            return "";
        }
        try {
            String a = com.amap.location.common.a.a(context);
            if (TextUtils.isEmpty(a)) {
                String f = com.amap.location.common.a.f(context);
                if (!TextUtils.isEmpty(f)) {
                    a = f.replaceAll(":", "");
                } else {
                    a = UUID.randomUUID().toString().replaceAll("-", "");
                }
            }
            mImei = a;
        } catch (Throwable unused) {
            if (TextUtils.isEmpty(mImei)) {
                try {
                    mImei = UUID.randomUUID().toString().replaceAll("-", "");
                } catch (Throwable unused2) {
                }
            }
        }
        return mImei;
    }

    public static String getImsi(Context context) {
        try {
            String d = com.amap.location.common.a.d(context);
            if (TextUtils.isEmpty(d)) {
                String f = com.amap.location.common.a.f(context);
                if (!TextUtils.isEmpty(f)) {
                    d = f.replaceAll(":", "");
                } else {
                    d = UUID.randomUUID().toString().replaceAll("-", "");
                }
            }
            mImsi = d;
        } catch (Throwable unused) {
            if (TextUtils.isEmpty(mImsi)) {
                try {
                    mImsi = UUID.randomUUID().toString().replaceAll("-", "");
                } catch (Throwable unused2) {
                }
            }
        }
        return mImsi;
    }

    public static String getString(ByteBuffer byteBuffer) {
        int i = byteBuffer.get();
        if (i == 0) {
            return "";
        }
        byte[] bArr = new byte[i];
        byteBuffer.get(bArr);
        return new String(bArr);
    }

    public static boolean hasPressure(Context context) {
        return ((SensorManager) context.getSystemService("sensor")).getDefaultSensor(6) != null;
    }

    public static String hexString(byte[] bArr) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte b : bArr) {
            stringBuffer.append(String.format("%02x", Byte.valueOf(b)));
        }
        return stringBuffer.toString();
    }

    public static Object invokeStaticMethod(String str, String str2, Object[] objArr, Class<?>[] clsArr) throws Exception {
        Method declaredMethod = Class.forName(str).getDeclaredMethod(str2, clsArr);
        if (!declaredMethod.isAccessible()) {
            declaredMethod.setAccessible(true);
        }
        return declaredMethod.invoke(null, objArr);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isMobileNetConnected(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getNetworkInfo(0);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isNetworkConnected(Context context) {
        return isMobileNetConnected(context) || isWifiConnected(context);
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager) context.getSystemService("connectivity")).getNetworkInfo(1);
        if (networkInfo != null && networkInfo.isConnected()) {
            isWifiConnected = true;
        } else {
            isWifiConnected = false;
        }
        return isWifiConnected;
    }

    public static int length(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static String macString(long j) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; i++) {
            sb.append(String.format("%02x:", Long.valueOf((j >> (40 - (i * 8))) & 255)));
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static void put(ByteBuffer byteBuffer, String str) {
        if (TextUtils.isEmpty(str)) {
            byteBuffer.put((byte) 0);
            return;
        }
        byte[] bytes = str.getBytes();
        byteBuffer.put((byte) bytes.length);
        byteBuffer.put(bytes);
    }

    public static void putDummyData(ByteBuffer byteBuffer, int i) {
        byteBuffer.put(new byte[i]);
    }

    public static void setAosEncryptorImpl(AosEncryptor aosEncryptor) {
        if (aosEncryptor != null) {
            sAosEncryptor = aosEncryptor;
        }
    }

    public static void writeMac2Buffer(String str, ByteBuffer byteBuffer) {
        byte[] bytes = str.getBytes();
        byteBuffer.put((byte) bytes.length);
        byteBuffer.put(bytes);
    }

    public static void writeMac2SixByteBuffer(String str, ByteBuffer byteBuffer) {
        if (str != null && str.length() != 0) {
            byteBuffer.put(encodeMac2SixByte(encodeMacLong(str)));
        } else {
            putDummyData(byteBuffer, 6);
        }
    }

    public static byte[] copyOf(byte[] bArr, int i, int i2) {
        byte[] bArr2 = new byte[i2 - i];
        System.arraycopy(bArr, i, bArr2, 0, Math.min(i2, bArr.length) - i);
        return bArr2;
    }

    public static String encodeWifiMac(String str) {
        return str.replace(':', '_');
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static int length(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static boolean notEmpty(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean isEmpty(HashMap<?, ?> hashMap) {
        return hashMap == null || hashMap.size() == 0;
    }

    public static int length(HashMap<?, ?> hashMap) {
        if (hashMap == null) {
            return 0;
        }
        return hashMap.size();
    }

    public static boolean notEmpty(byte[] bArr) {
        return bArr != null && bArr.length > 0;
    }

    public static byte[] amapEncode(byte[] bArr) {
        AosEncryptor aosEncryptor = sAosEncryptor;
        if (aosEncryptor != null) {
            return aosEncryptor.amapEncode(bArr);
        }
        a.c("MapUtils", "indoor aos encryptor-byte is null");
        return null;
    }

    public static boolean isEmpty(byte[] bArr) {
        return bArr == null || bArr.length == 0;
    }

    public static int length(byte[] bArr) {
        if (bArr == null) {
            return 0;
        }
        return bArr.length;
    }

    public static String getString(ByteBuffer byteBuffer, int i) {
        if (i == 0) {
            return "";
        }
        byte[] bArr = new byte[i];
        byteBuffer.get(bArr);
        return new String(bArr);
    }

    public static String macString(byte[] bArr) {
        if (bArr == null || bArr.length < 6) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; i++) {
            sb.append(String.format("%02x:", Byte.valueOf(bArr[i])));
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static long encodeMacLong(byte[] bArr) {
        long j = 0;
        if (bArr != null && bArr.length >= 6) {
            for (int i = 0; i < 6; i++) {
                j = (j << 8) + (bArr[i] & 255);
            }
        }
        return j;
    }

    public static boolean isWifiConnected() {
        return isWifiConnected;
    }

    public static String getImei() {
        return mImei;
    }

    public static String getImsi() {
        return mImsi;
    }
}
