package com.autonavi.indoor.util;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.entity.LocationResult;
import java.util.ArrayList;

/* loaded from: classes.dex */
public class MessageHelper {
    public static String getMessageString(Message message) {
        return message.getData().getString("String" + message.what);
    }

    public static boolean isValidHandler(Handler handler) {
        return (handler == null || handler.getLooper() == null || handler.getLooper().getThread() == null || !handler.getLooper().getThread().isAlive()) ? false : true;
    }

    public static void publishLocationResult(ArrayList<Handler> arrayList, boolean z, LocationResult locationResult, String str) {
        if (locationResult == null) {
            return;
        }
        int i = z ? 208 : MessageCode.MSG_REPORT_LOCATION;
        synchronized (arrayList) {
            int size = arrayList.size();
            for (int i2 = 0; i2 < size; i2++) {
                Handler handler = arrayList.get(i2);
                if (isValidHandler(handler)) {
                    handler.removeMessages(i);
                    Message obtainMessage = handler.obtainMessage(i);
                    obtainMessage.obj = locationResult;
                    if (!TextUtils.isEmpty(str)) {
                        setMessageString(obtainMessage, str);
                    }
                    handler.sendMessage(obtainMessage);
                }
            }
        }
    }

    public static void publishMessage(ArrayList<Handler> arrayList, int i) {
        synchronized (arrayList) {
            int size = arrayList.size();
            for (int i2 = 0; i2 < size; i2++) {
                Handler handler = arrayList.get(i2);
                handler.sendMessage(Message.obtain(handler, i));
            }
        }
    }

    public static void setMessageString(Message message, String str) {
        message.getData().putString("String" + message.what, str);
    }

    public static void publishMessage(ArrayList<Handler> arrayList, int i, Bundle bundle) {
        synchronized (arrayList) {
            int size = arrayList.size();
            for (int i2 = 0; i2 < size; i2++) {
                Handler handler = arrayList.get(i2);
                Message obtain = Message.obtain(handler, i);
                obtain.setData(bundle);
                handler.sendMessage(obtain);
            }
        }
    }

    public static void publishMessage(ArrayList<Handler> arrayList, int i, Object obj) {
        synchronized (arrayList) {
            int size = arrayList.size();
            for (int i2 = 0; i2 < size; i2++) {
                Handler handler = arrayList.get(i2);
                if (isValidHandler(handler)) {
                    Message obtain = Message.obtain(handler, i);
                    obtain.obj = obj;
                    handler.sendMessage(obtain);
                }
            }
        }
    }
}
