package com.autonavi.indoor.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.security.MessageDigest;

/* loaded from: classes.dex */
public class PackageHelper {
    public static String mApplicationName = "";
    public static String mPackageName = null;
    public static String mVersion = "";

    public static String getApplicationName(Context context) {
        try {
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        if (!"".equals(mApplicationName)) {
            return mApplicationName;
        }
        PackageManager packageManager = context.getPackageManager();
        mApplicationName = (String) packageManager.getApplicationLabel(packageManager.getApplicationInfo(context.getPackageName(), 0));
        return mApplicationName;
    }

    public static String getApplicationVersion(Context context) {
        try {
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        if (!"".equals(mVersion)) {
            return mVersion;
        }
        mVersion = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        return mVersion;
    }

    public static String getPackageName(Context context) {
        try {
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        if (mPackageName != null && !"".equals(mPackageName)) {
            return mPackageName;
        }
        mPackageName = context.getApplicationContext().getPackageName();
        return mPackageName;
    }

    public static String getSHA1(Context context) {
        String str = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            if (packageInfo.signatures.length == 0) {
                return "";
            }
            Signature signature = packageInfo.signatures[0];
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(signature.toByteArray());
            for (byte b : messageDigest.digest()) {
                if (str.length() > 0) {
                    str = str + ":";
                }
                str = str + ("00" + Integer.toString(b & 255, 16)).substring(r2.length() - 2);
            }
            if (L.isLogging) {
                L.d("MY KEY HASH:" + str);
            }
            return str.toUpperCase();
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
            return str;
        }
    }
}
