package com.autonavi.indoor.util;

import android.content.Context;
import android.os.Build;

/* loaded from: classes.dex */
public abstract class PermissionUtil {
    public static String[] permissions = {"android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};

    public static boolean hasSelfPermission(Context context, String str) {
        return Build.VERSION.SDK_INT < 23 || context.checkSelfPermission(str) == 0;
    }

    public static boolean hasSelfPermission(Context context, String[] strArr) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String str : strArr) {
            if (context.checkSelfPermission(str) != 0) {
                return false;
            }
        }
        return true;
    }
}
