package com.autonavi.indoor.util;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.autonavi.indoor.constant.Configuration;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.UUID;

/* loaded from: classes.dex */
public class ProtocolHelper {
    public static Method getSession;
    public static Method getSpm;

    public static String getInitXInfo(Context context) {
        StringBuilder sb = new StringBuilder();
        try {
            String deviceID = DeviceUtils.getDeviceID(context);
            sb.append("diu=");
            sb.append(deviceID);
            sb.append("&pkg=");
            sb.append(PackageHelper.getPackageName(context));
            sb.append("&model=");
            sb.append(Build.MODEL);
            sb.append("&manufacture=");
            sb.append(Build.MANUFACTURER);
            sb.append("&device=");
            sb.append(Build.DEVICE);
            sb.append("&appname=");
            sb.append(PackageHelper.getApplicationName(context));
            sb.append("&appversion=");
            sb.append(PackageHelper.getApplicationVersion(context));
            sb.append("&sysversion=");
            sb.append(Build.VERSION.SDK_INT);
            String subscriberId = DeviceUtils.getSubscriberId(context);
            sb.append("&sim=");
            sb.append(subscriberId);
            sb.append("&resolution=" + DeviceUtils.getReslution(context));
            sb.append("&mac=");
            sb.append(DeviceUtils.getDeviceMac(context));
            sb.append("&wifis=");
            sb.append(DeviceUtils.getWifiMacs(context));
            sb.append("&ant=");
            sb.append(DeviceUtils.getActiveNetWorkType(context));
            sb.append("&nt=");
            sb.append(DeviceUtils.getNetWorkType(context));
            String networkOperatorName = DeviceUtils.getNetworkOperatorName(context);
            sb.append("&np=");
            sb.append(networkOperatorName);
            sb.append("&mnc=");
            sb.append(DeviceUtils.getMNC(context));
            String connectWifi = DeviceUtils.getConnectWifi(context);
            if (!TextUtils.isEmpty(connectWifi)) {
                sb.append("&wifi=");
                sb.append(connectWifi);
            }
            String utdid = EncryptHelper.getUTDID(context);
            if (utdid == null) {
                utdid = "";
            }
            sb.append("&bts=");
            sb.append(DeviceUtils.getCellInfo(context));
            sb.append("&tid=");
            sb.append(utdid);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        if (L.isLogging) {
            L.d("xInfoStr:" + sb.toString());
        }
        return sb.toString();
    }

    public static String getSession() {
        Object obj = null;
        try {
            if (getSession == null) {
                getSession = Class.forName("com.autonavi.minimap.net.NetworkParam").getDeclaredMethod("getSession", new Class[0]);
            }
            obj = getSession.invoke(null, new Object[0]);
        } catch (ClassNotFoundException unused) {
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        return obj == null ? "" : String.valueOf(obj);
    }

    public static String getSpm() {
        Object obj = null;
        try {
            if (getSpm == null) {
                getSpm = Class.forName("com.autonavi.minimap.net.NetworkParam").getDeclaredMethod("getSpm", new Class[0]);
            }
            obj = getSpm.invoke(null, new Object[0]);
        } catch (ClassNotFoundException unused) {
        } catch (Exception e) {
            if (L.isLogging) {
                L.d((Throwable) e);
            }
        }
        return obj == null ? "" : String.valueOf(obj);
    }

    public static void setLBSHead(HttpURLConnection httpURLConnection, Configuration configuration, String str) {
        byte[] bytes;
        if (configuration.mServerType != Configuration.ServerType.SERVER_LBS) {
            return;
        }
        try {
            for (String str2 : str.split("\\?")[1].split("&")) {
                if (L.isLogging) {
                    L.d(str2);
                }
                String[] split = str2.split("=");
                if (split[0].equals("key") || split[0].equals("scode") || split[0].equals("ts")) {
                    httpURLConnection.setRequestProperty(split[0], split[1]);
                }
            }
            httpURLConnection.setRequestProperty("logversion", "2.0");
            httpURLConnection.setRequestProperty("platinfo", String.format("platform=Android&sdkversion=%s&product=%s", configuration.mSDKVersion, configuration.mSDKName));
            httpURLConnection.setRequestProperty("User-Agent", "AMAP_SDK_Android_indoormap_" + configuration.mSDKVersion);
            String initXInfo = getInitXInfo(configuration.context);
            try {
                bytes = initXInfo.getBytes("utf-8");
            } catch (UnsupportedEncodingException unused) {
                bytes = initXInfo.getBytes();
            }
            String str3 = null;
            try {
                str3 = EncryptHelper.privateRsaAesData(configuration.context, bytes);
            } catch (Exception e) {
                if (L.isLogging) {
                    L.d((Throwable) e);
                }
            }
            httpURLConnection.setRequestProperty("X-INFO", str3);
            httpURLConnection.setRequestProperty("csid", UUID.randomUUID().toString());
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public static String sortParams(String str) {
        if (str == null) {
            return null;
        }
        try {
            String[] split = str.split("&");
            Arrays.sort(split);
            StringBuffer stringBuffer = new StringBuffer();
            for (String str2 : split) {
                stringBuffer.append(str2);
                stringBuffer.append("&");
            }
            String stringBuffer2 = stringBuffer.toString();
            if (stringBuffer2.length() > 1) {
                return (String) stringBuffer2.subSequence(0, stringBuffer2.length() - 1);
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
        return str;
    }
}
