package com.autonavi.indooroutdoordetectorsdk;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Base64;
import com.amap.location.common.a;
import com.autonavi.amapauto.user.UserPhone;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.entity.ScanPair;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indoor.util.PackageHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class BuildingLocateThread extends Thread {
    public static final short ACTIONGCODE_ONLINE_V5 = 17;
    public static Request SHUTDOWN_REQ = new Request("SHUTDOWN", null);
    public final Context context;
    public boolean isPdrEnable;
    public Handler mHandler;
    public volatile boolean shuttingDown;
    public volatile boolean terminated;
    public BlockingQueue<Request> requestToPost = new ArrayBlockingQueue(1);
    public boolean hasBeenStarted = false;

    /* loaded from: classes.dex */
    public static class Request {
        public ScanData scanData;
        public String url;

        public Request(String str, ScanData scanData) {
            this.url = str;
            this.scanData = scanData;
        }
    }

    public BuildingLocateThread(Handler handler, boolean z, Context context) {
        this.mHandler = null;
        this.isPdrEnable = true;
        start();
        this.mHandler = handler;
        this.isPdrEnable = z;
        this.context = context;
    }

    public static byte[] compressBody(byte[] bArr) {
        try {
            ByteBuffer wrap = ByteBuffer.wrap(bArr);
            byte[] bArr2 = new byte[bArr.length - 6];
            short s = wrap.getShort();
            int i = wrap.getInt();
            wrap.get(bArr2);
            byte[] jniCompress = JNIWrapper.jniCompress(bArr2);
            bArr = new byte[jniCompress.length + 6];
            ByteBuffer wrap2 = ByteBuffer.wrap(bArr);
            wrap2.putShort(s);
            wrap2.putInt(i + 2);
            wrap2.put(jniCompress);
            return bArr;
        } catch (Throwable unused) {
            return bArr;
        }
    }

    public void consumRequest(Request request) {
        int responseCode;
        long currentTimeMillis = System.currentTimeMillis();
        byte[] encodeLocateRequest = encodeLocateRequest(request.scanData);
        if (encodeLocateRequest == null) {
            return;
        }
        byte[] compressBody = compressBody(encodeLocateRequest);
        String str = request.url;
        byte[] amapEncode = MapUtils.amapEncode(compressBody);
        if (amapEncode != null) {
            if (L.isLogging) {
                L.d("Request encryptData is null");
            }
            compressBody = amapEncode;
        }
        if (L.isLogging) {
            L.d("Request " + str + ", buffer.length=" + compressBody.length);
        }
        int i = 0;
        if (L.isLogging) {
            L.d("Request body" + Base64.encodeToString(compressBody, 0));
        }
        if (this.shuttingDown) {
            return;
        }
        try {
            if (L.isLogging) {
                L.d("consumRequest " + currentTimeMillis + " Request " + str + ", buffer.length=" + compressBody.length);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection) new URL(str).openConnection();
            try {
                if (L.isLogging) {
                    L.d("发送网络请求...");
                }
                httpURLConnection.setReadTimeout(10000);
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write(compressBody);
                outputStream.close();
                httpURLConnection.connect();
                responseCode = httpURLConnection.getResponseCode();
            } finally {
                try {
                } finally {
                }
            }
            if (responseCode != 200) {
                httpURLConnection.disconnect();
                sendEmptyMessage2parent(MessageCode.MSG_SERVER_ERROR);
                if (L.isLogging) {
                    L.d("服务器建立连接失败，返回值错误code：" + responseCode);
                }
                Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
                if (L.isLogging) {
                    L.d(headerFields.toString() + ", " + headerFields.size());
                }
                for (String str2 : headerFields.keySet()) {
                    List<String> list = headerFields.get(str2);
                    if (L.isLogging) {
                        L.d(list.toString() + ", " + list.size());
                    }
                    for (String str3 : list) {
                        if (L.isLogging) {
                            L.d(str2 + ": " + str3);
                        }
                    }
                }
                return;
            }
            String contentType = httpURLConnection.getContentType();
            int contentLength = httpURLConnection.getContentLength();
            if (contentLength <= 0) {
                contentLength = 2097152;
                if (L.isLogging) {
                    L.d(httpURLConnection.getResponseMessage());
                }
            }
            byte[] bArr = new byte[contentLength];
            InputStream inputStream = httpURLConnection.getInputStream();
            while (i < contentLength) {
                int read = inputStream.read(bArr, i, contentLength - i);
                if (read <= 0) {
                    break;
                } else {
                    i += read;
                }
            }
            byte[] copyOf = MapUtils.copyOf(bArr, i);
            inputStream.close();
            if (L.isLogging) {
                L.d("Response " + str + ", buffer[1]=" + ((int) compressBody[1]) + ", code=" + responseCode + ", length=" + copyOf.length + ", len=" + contentLength + ", contentLength=" + httpURLConnection.getContentLength() + ", " + httpURLConnection.getResponseMessage() + ", " + contentType);
            }
            if (contentType.startsWith("application/json")) {
                String str4 = new String(copyOf);
                if (L.isLogging) {
                    L.d("ServerError:" + str4);
                }
                JSONObject jSONObject = new JSONObject(str4);
                if (jSONObject.has("status")) {
                    String string = jSONObject.getString("status");
                    if (L.isLogging) {
                        L.d("json status:" + string);
                    }
                    String string2 = jSONObject.getString("info");
                    if (L.isLogging) {
                        L.d("json info:" + string2);
                    }
                    int i2 = MessageCode.MSG_LBS_ERROR;
                    if (string2.equals("OK")) {
                        if (L.isLogging) {
                            L.d("正常");
                        }
                    } else if (string2.equals("INVALID_USER_KEY")) {
                        i2 = MessageCode.MSG_LBS_INVALID_USER_KEY;
                        if (L.isLogging) {
                            L.d("用户key非法或过期");
                        }
                    } else if (string2.equals("SERVICE_NOT_AVAILBALE")) {
                        i2 = MessageCode.MSG_LBS_SERVICE_NOT_AVAILBALE;
                        if (L.isLogging) {
                            L.d("请求服务不存在");
                        }
                    } else if (string2.equals("SERVICE_RESPONSE_ERROR")) {
                        i2 = MessageCode.MSG_LBS_SERVICE_RESPONSE_ERROR;
                        if (L.isLogging) {
                            L.d("请求服务响应错误");
                        }
                    } else if (string2.equals("INSUFFICIENT_PRIVILEGES")) {
                        i2 = MessageCode.MSG_LBS_INSUFFICIENT_PRIVILEGES;
                        if (L.isLogging) {
                            L.d("无权限访问此服务");
                        }
                    } else if (string2.equals("OVER_QUOTA")) {
                        i2 = MessageCode.MSG_LBS_OVER_QUOTA;
                        if (L.isLogging) {
                            L.d("请求超出配额");
                        }
                    } else if (string2.equals("INVALID_PARAMS")) {
                        i2 = MessageCode.MSG_LBS_INVALID_PARAMS;
                        if (L.isLogging) {
                            L.d("请求参数非法");
                        }
                    } else if (string2.equals("UNKNOWN_ERROR")) {
                        i2 = MessageCode.MSG_LBS_UNKNOWN_ERROR;
                        if (L.isLogging) {
                            L.d("未知错误");
                        }
                    }
                    sendEmptyMessage2parent(i2);
                } else if (jSONObject.has("result")) {
                    String string3 = jSONObject.getString("result");
                    if (L.isLogging) {
                        L.d("json result:" + string3);
                    }
                    if (string3.equals(Config.FALSE)) {
                        sendMessage2parent(MessageCode.MSG_SERVER_ERROR, jSONObject.getString("message"));
                    }
                }
                if (L.isLogging) {
                    L.d(httpURLConnection.getContent().toString());
                }
            } else {
                BuildingLocationResult decodeLocateResponse = decodeLocateResponse(copyOf);
                if (decodeLocateResponse != null) {
                    if (L.isLogging) {
                        L.d(decodeLocateResponse);
                    }
                    sendMessage2parent(208, decodeLocateResponse);
                } else {
                    if (L.isLogging) {
                        L.d(copyOf);
                    }
                    sendMessage2parent(MessageCode.MSG_SERVER_ERROR, "DecodeLocateResponse failed");
                }
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d("打开连接异常：" + th);
            }
            sendEmptyMessage2parent(212);
        }
    }

    public BuildingLocationResult decodeLocateResponse(byte[] bArr) {
        try {
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        if (MapUtils.isEmpty(bArr)) {
            if (L.isLogging) {
                L.d(bArr);
            }
            return null;
        }
        ByteBuffer wrap = ByteBuffer.wrap(bArr);
        short s = wrap.getShort();
        if (s != 17) {
            if (L.isLogging) {
                L.d("action_code:" + ((int) s));
            }
            return null;
        }
        int i = wrap.getInt();
        wrap.getLong();
        int i2 = wrap.getInt();
        if (i2 != 0) {
            if (L.isLogging) {
                L.d("status_code:" + i2);
            }
            return null;
        }
        int i3 = wrap.getInt();
        byte b = wrap.get();
        byte b2 = wrap.get();
        if (L.isLogging) {
            L.d("BuilingLocate result action_code=" + ((int) s) + ",action_version=" + i + ", status_code=" + i2 + ",len=" + i3 + ",LocationType(0GPS 1Wifi 2蓝牙 3混合)=" + ((int) b) + ",Result=" + ((int) b2));
        }
        if (b2 < 0) {
            if (L.isLogging) {
                L.d("returncode:" + ((int) b2));
            }
            return null;
        }
        String string = MapUtils.getString(wrap);
        byte b3 = wrap.get();
        ByteBuffer allocate = ByteBuffer.allocate(128);
        for (int i4 = 0; i4 < b3; i4++) {
            BuildingLocationResult buildingLocationResult = new BuildingLocationResult();
            double d = wrap.getDouble();
            buildingLocationResult.x = d;
            if (d >= -180.0d && d <= 180.0d) {
                double d2 = wrap.getDouble();
                buildingLocationResult.y = d2;
                if (d2 >= -180.0d && d2 <= 180.0d) {
                    allocate.position(0);
                    allocate.putDouble(buildingLocationResult.x);
                    allocate.putDouble(buildingLocationResult.y);
                    allocate.position(0);
                    long j = allocate.getLong();
                    int i5 = allocate.getInt();
                    if (j == 0 && i5 == 0) {
                        if (L.isLogging) {
                            L.d("x:" + j + ", y:" + i5);
                        }
                    } else {
                        buildingLocationResult.z = wrap.get();
                        wrap.getFloat();
                        wrap.getFloat();
                        wrap.getFloat();
                        buildingLocationResult.bid = string;
                        buildingLocationResult.d = b;
                        return buildingLocationResult;
                    }
                }
                if (L.isLogging) {
                    L.d("y:" + buildingLocationResult.y);
                }
            } else if (L.isLogging) {
                L.d("x:" + buildingLocationResult.x);
            }
            return null;
        }
        return null;
    }

    public byte[] encodeLocateRequest(ScanData scanData) {
        String str = "";
        int i = scanData.type_ == 0 ? 1 : 2;
        if (L.isLogging) {
            L.d("locationType:" + i);
        }
        long j = scanData.time_;
        ByteBuffer allocate = ByteBuffer.allocate(10);
        allocate.putShort((short) 17);
        allocate.putInt(1);
        ByteBuffer allocate2 = ByteBuffer.allocate(10240);
        try {
            MapUtils.put(allocate2, "");
            allocate2.put((byte) i);
            MapUtils.put(allocate2, "IOD");
            MapUtils.put(allocate2, "6.9");
            MapUtils.put(allocate2, Build.MODEL);
            MapUtils.put(allocate2, "Android" + Build.VERSION.SDK_INT);
            MapUtils.put(allocate2, PackageHelper.getApplicationName(this.context) + PackageHelper.getApplicationVersion(this.context));
            MapUtils.put(allocate2, "");
            MapUtils.put(allocate2, MapUtils.getImei());
            MapUtils.put(allocate2, MapUtils.getImsi());
            String upperCase = MapUtils.encodeWifiMac(a.f(this.context)).toUpperCase();
            MapUtils.writeMac2SixByteBuffer(upperCase, allocate2);
            MapUtils.writeMac2SixByteBuffer(upperCase, allocate2);
            allocate2.put((byte) 0);
            MapUtils.put(allocate2, "SSID");
            allocate2.put((byte) (this.isPdrEnable ? 1 : 0));
            allocate2.putLong(j);
            allocate2.put((byte) 1);
            if (L.isLogging) {
                L.d(Build.MODEL + ",Android" + Build.VERSION.RELEASE + "," + PackageHelper.getApplicationName(this.context) + PackageHelper.getApplicationVersion(this.context));
            }
            if (scanData.type_ == 0) {
                short size = (short) scanData.scans_.size();
                allocate2.putShort((short) (scanData.time_ - j));
                allocate2.putShort(size);
                for (int i2 = 0; i2 < scanData.scans_.size(); i2++) {
                    ScanPair scanPair = scanData.scans_.get(i2);
                    allocate2.put(GeoFenceHelper.getMacBytes(scanPair.mID));
                    allocate2.put((byte) scanPair.mRSSI);
                    allocate2.put((byte) 0);
                }
                allocate2.putShort((short) 0);
            }
            if (scanData.type_ == 1) {
                allocate2.putShort((short) (scanData.time_ - j));
                allocate2.putShort((short) 0);
                allocate2.putShort((short) scanData.scans_.size());
                for (int i3 = 0; i3 < scanData.scans_.size(); i3++) {
                    ScanPair scanPair2 = scanData.scans_.get(i3);
                    MapUtils.putDummyData(allocate2, 6);
                    String[] split = scanPair2.mID.split("_");
                    if (split.length == 3 && split[0].length() == 32 && split[1].length() == 4 && split[2].length() == 4) {
                        allocate2.put(split[0].getBytes());
                        allocate2.put(split[1].getBytes());
                        allocate2.put(split[2].getBytes());
                        str = str + scanPair2.mID + UserPhone.SPECIAL_LETTER + scanPair2.mRSSI + "$";
                        allocate2.put((byte) scanPair2.mRSSI);
                        allocate2.putInt(0);
                        allocate2.putInt(0);
                    }
                    MapUtils.putDummyData(allocate2, 40);
                    if (L.isLogging) {
                        L.d("ERROR mac!!" + scanPair2.mID);
                    }
                    str = str + scanPair2.mID + UserPhone.SPECIAL_LETTER + scanPair2.mRSSI + "$";
                    allocate2.put((byte) scanPair2.mRSSI);
                    allocate2.putInt(0);
                    allocate2.putInt(0);
                }
            }
            allocate2.putInt(0);
            allocate2.putInt(0);
            allocate2.putInt(0);
            allocate2.put(GeoFenceHelper.getCheckData(allocate2));
            allocate.putInt((allocate2.position() - 2) + 1);
            try {
                ByteBuffer allocate3 = ByteBuffer.allocate(allocate2.position() + 10);
                allocate3.put(allocate.array());
                byte[] array = allocate3.array();
                System.arraycopy(allocate2.array(), 0, array, 10, allocate2.position());
                return array;
            } catch (Throwable th) {
                if (L.isLogging) {
                    L.d(th);
                }
                return null;
            }
        } catch (Throwable th2) {
            if (L.isLogging) {
                L.d(th2);
            }
            return null;
        }
    }

    public boolean isValidHandler(Handler handler) {
        return (handler == null || handler.getLooper() == null || handler.getLooper().getThread() == null || !handler.getLooper().getThread().isAlive()) ? false : true;
    }

    public void locate(String str, ScanData scanData) {
        if (!this.shuttingDown && !this.terminated) {
            Request request = new Request(str, scanData);
            while (!this.requestToPost.offer(request)) {
                if (L.isLogging) {
                    L.d("queen is full, poll one");
                }
                this.requestToPost.poll();
            }
            if (L.isLogging) {
                L.d("add a request:" + this.requestToPost.size());
                return;
            }
            return;
        }
        if (L.isLogging) {
            L.d("BuildingLocateThread has been stoped.");
        }
    }

    @Override // java.lang.Thread, java.lang.Runnable
    public void run() {
        while (true) {
            try {
                if (this.shuttingDown) {
                    if (L.isLogging) {
                        L.d("Thread is shuttingDown.");
                    }
                    this.requestToPost.clear();
                } else {
                    Request take = this.requestToPost.take();
                    if (take == SHUTDOWN_REQ) {
                        if (L.isLogging) {
                            L.d("consum poison pill");
                        }
                    } else {
                        consumRequest(take);
                    }
                }
            } catch (InterruptedException unused) {
            } catch (Throwable th) {
                this.terminated = true;
                throw th;
            }
        }
        if (L.isLogging) {
            L.d("end of run");
        }
        this.mHandler = null;
        this.terminated = true;
    }

    public void sendEmptyMessage2parent(int i) {
        try {
            if (isValidHandler(this.mHandler)) {
                this.mHandler.sendEmptyMessage(i);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d("sendMessage to handler failed:" + e.toString());
            }
        }
    }

    public void sendMessage2parent(int i, Object obj) {
        try {
            if (isValidHandler(this.mHandler)) {
                Message obtain = Message.obtain(this.mHandler, i);
                obtain.obj = obj;
                this.mHandler.sendMessage(obtain);
            }
        } catch (Exception e) {
            if (L.isLogging) {
                L.d("sendMessage to handler failed:" + e.toString());
            }
        }
    }

    public void shutDown() throws InterruptedException {
        if (this.shuttingDown) {
            if (L.isLogging) {
                L.d("Thread is shuttingDown...");
                return;
            }
            return;
        }
        this.shuttingDown = true;
        this.hasBeenStarted = false;
        while (!this.requestToPost.offer(SHUTDOWN_REQ)) {
            if (L.isLogging) {
                L.d("queen is full, poll one");
            }
            this.requestToPost.poll();
        }
        if (L.isLogging) {
            L.d("stop BuildingLocateThread");
        }
    }
}
