package com.autonavi.indooroutdoordetectorsdk;

import android.os.Handler;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.entity.ScanData;
import com.autonavi.indoor.provider.BLEProvider;
import com.autonavi.indoor.provider.WifiProvider;
import com.autonavi.indoor.util.L;

/* loaded from: classes.dex */
public class BuildingLocator {
    public Configuration mConfiguration = null;
    public BLEProvider mBleProvider = null;
    public WifiProvider mWifiProvider = null;
    public Handler mHandler = null;
    public boolean mWifiFailed = false;
    public int mRequestCount = 0;
    public long mLastRequestTime = 0;
    public BuildingLocateThread mBuildingLocateThread = null;

    public int detect(ScanData scanData) {
        if (scanData.size() <= 0) {
            return 0;
        }
        int i = this.mRequestCount;
        if (i <= 5) {
            this.mRequestCount = i + 1;
        } else if (System.currentTimeMillis() - this.mLastRequestTime < 10000) {
            return 0;
        }
        this.mLastRequestTime = System.currentTimeMillis();
        String url = this.mConfiguration.getUrl();
        BuildingLocateThread buildingLocateThread = this.mBuildingLocateThread;
        if (buildingLocateThread != null) {
            buildingLocateThread.locate(url, scanData);
        }
        return 0;
    }

    public void initDetect(Configuration configuration) {
        this.mConfiguration = configuration;
    }

    /* JADX WARN: Code restructure failed: missing block: B:69:0x0121, code lost:            if (r6.mConfiguration.mPDRProvider == com.autonavi.indoor.constant.Configuration.PDRProvider.STEPANGLE) goto L65;     */
    /* JADX WARN: Removed duplicated region for block: B:51:0x0138  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public boolean startDetect() {
        /*
            Method dump skipped, instructions count: 336
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.autonavi.indooroutdoordetectorsdk.BuildingLocator.startDetect():boolean");
    }

    public void stopDetect() {
        if (L.isLogging) {
            L.d("stop indoorlocation");
        }
        try {
            if (this.mWifiProvider != null) {
                GeoFenceHelper.logFile("WifiStop");
                JNIWrapper.jniSetFlag(System.currentTimeMillis(), "WifiStop");
                this.mWifiProvider.unregisterListener(this.mHandler);
                this.mWifiProvider = null;
                if (L.isLogging) {
                    L.d("Stop WifiProvider");
                }
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        try {
            if (this.mBleProvider != null) {
                GeoFenceHelper.logFile("BleStop");
                JNIWrapper.jniSetFlag(System.currentTimeMillis(), "BleStop");
                this.mBleProvider.unregisterListener(this.mHandler);
                this.mBleProvider = null;
                if (L.isLogging) {
                    L.d("Stop BleProvider");
                }
            }
        } catch (Throwable th2) {
            if (L.isLogging) {
                L.d(th2);
            }
        }
        try {
            if (this.mBuildingLocateThread != null) {
                this.mBuildingLocateThread.shutDown();
                this.mBuildingLocateThread = null;
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        String str;
        StringBuilder sb = new StringBuilder("粗定位：");
        if (this.mBleProvider != null && this.mWifiProvider != null) {
            str = "蓝牙和WIFI";
        } else if (this.mWifiProvider != null) {
            str = "WIFI";
        } else {
            str = this.mBleProvider != null ? "蓝牙" : "未启动";
        }
        sb.append("Sensor:" + str);
        return sb.toString();
    }
}
