package com.autonavi.indooroutdoordetectorsdk;

import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import com.autonavi.indoor.constant.Configuration;
import com.autonavi.indoor.pdr.ErrorCode;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import com.autonavi.indooroutdoordetectorsdk.GeoFenceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

/* loaded from: classes.dex */
public class GeoFenceDetector {
    public Configuration mConfiguration;
    public GeoFenceHelper.TimeStatus mDownloadStatus = new GeoFenceHelper.TimeStatus();
    public int mDetectTimes = 0;
    public int mGlobalSearchTimes = 0;
    public String mFilename = "";
    public File mFile = null;
    public long mUpdateTime = 0;
    public int mVersion = 0;
    public ArrayList<Building> mBuildings = new ArrayList<>();
    public GeoFenceHelper.TimeStatus mNearest = new GeoFenceHelper.TimeStatus();
    public double mDistance = 0.0d;
    public ArrayList<Building> mNearBuildings = new ArrayList<>();
    public GeoFenceHelper.Coord mNearCoord = null;
    public int N1 = 10;
    public int N2 = 30;

    /* loaded from: classes.dex */
    public static class Building {
        public boolean isContained;
        public boolean isNearby;
        public boolean isReachable = false;
        public int support = 0;
        public String buildingId = "";
        public GeoFenceHelper.Coord center = new GeoFenceHelper.Coord();
        public ArrayList<GeoFenceHelper.Coord> points = new ArrayList<>();
        public RectF envelope = new RectF(1000.0f, 1000.0f, -1000.0f, -1000.0f);
        public double distance = 0.0d;

        public static boolean isPointInRing(GeoFenceHelper.Coord coord, ArrayList<GeoFenceHelper.Coord> arrayList) {
            int size = arrayList.size();
            int i = 0;
            for (int i2 = 1; i2 < size; i2++) {
                GeoFenceHelper.Coord coord2 = arrayList.get(i2);
                GeoFenceHelper.Coord coord3 = arrayList.get(i2 - 1);
                float f = coord2.longitude;
                float f2 = coord.longitude;
                double d = f - f2;
                float f3 = coord2.latitude;
                float f4 = coord.latitude;
                double d2 = f3 - f4;
                double d3 = coord3.longitude - f2;
                double d4 = coord3.latitude - f4;
                if ((d2 > 0.0d && d4 <= 0.0d) || (d4 > 0.0d && d2 <= 0.0d)) {
                    double signOfDet2x2 = signOfDet2x2(d, d2, d3, d4);
                    Double.isNaN(d4);
                    Double.isNaN(d2);
                    Double.isNaN(signOfDet2x2);
                    if (0.0d < signOfDet2x2 / (d4 - d2)) {
                        i++;
                    }
                }
            }
            return i % 2 == 1;
        }

        /* JADX WARN: Code restructure failed: missing block: B:14:0x002b, code lost:            if (r2 <= r6) goto L33;     */
        /* JADX WARN: Removed duplicated region for block: B:18:0x0061  */
        /* JADX WARN: Removed duplicated region for block: B:25:0x008a  */
        /* JADX WARN: Removed duplicated region for block: B:88:0x0088 A[SYNTHETIC] */
        /* JADX WARN: Removed duplicated region for block: B:92:0x006b  */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
            To view partially-correct code enable 'Show inconsistent code' option in preferences
        */
        public static int signOfDet2x2(double r20, double r22, double r24, double r26) {
            /*
                Method dump skipped, instructions count: 294
                To view this dump change 'Code comments level' option to 'DEBUG'
            */
            throw new UnsupportedOperationException("Method not decompiled: com.autonavi.indooroutdoordetectorsdk.GeoFenceDetector.Building.signOfDet2x2(double, double, double, double):int");
        }

        public boolean contains(GeoFenceHelper.Coord coord) {
            if (this.envelope.contains(coord.longitude, coord.latitude)) {
                return isPointInRing(coord, this.points);
            }
            return false;
        }

        public boolean detect(GeoFenceHelper.Coord coord) {
            double distance = this.center.distance(coord);
            this.distance = distance;
            this.isNearby = distance < 2000.0d;
            this.isReachable = this.distance < 10000.0d;
            boolean z = this.isNearby;
            this.isContained = z;
            if (z) {
                this.isContained = contains(coord);
            }
            return this.isContained;
        }

        public String toString() {
            return "Building: " + this.buildingId + ", support=" + this.support + ", center=(" + this.center.longitude + "," + this.center.latitude + "), count=" + this.points.size() + ", distance=" + this.distance + ", Near:" + this.isNearby + ", isContained：" + this.isContained;
        }
    }

    public void decodeBuildings(byte[] bArr) {
        try {
            ByteBuffer wrap = ByteBuffer.wrap(bArr);
            this.mUpdateTime = wrap.getLong();
            this.mVersion = wrap.getInt();
            this.N1 = wrap.get();
            this.N2 = wrap.get();
            wrap.getShort();
            wrap.getInt();
            if (L.isLogging) {
                L.d("decodeBuildings: N1=" + this.N1 + ", N2=" + this.N2 + ", bufsize=" + bArr.length);
            }
            int i = wrap.getInt();
            int i2 = wrap.getInt();
            synchronized (this.mBuildings) {
                if (i2 >= 0) {
                    this.mBuildings.clear();
                }
                if (L.isLogging) {
                    L.d("\tmVersion=" + this.mVersion + ", dataVersion=" + i + ", count=" + i2);
                }
                for (int i3 = 0; i3 < i2; i3++) {
                    Building building = new Building();
                    building.support = wrap.get();
                    byte[] bArr2 = new byte[16];
                    wrap.get(bArr2);
                    building.buildingId = new String(bArr2, 0, 10);
                    building.center.longitude = wrap.getFloat();
                    building.center.latitude = wrap.getFloat();
                    int i4 = wrap.getInt();
                    for (int i5 = 0; i5 < i4; i5++) {
                        GeoFenceHelper.Coord coord = new GeoFenceHelper.Coord();
                        double d = wrap.getShort();
                        Double.isNaN(d);
                        double d2 = d * 1.0E-6d;
                        double d3 = building.center.longitude;
                        Double.isNaN(d3);
                        coord.longitude = (float) (d2 + d3);
                        double d4 = wrap.getShort();
                        Double.isNaN(d4);
                        double d5 = d4 * 1.0E-6d;
                        double d6 = building.center.latitude;
                        Double.isNaN(d6);
                        coord.latitude = (float) (d5 + d6);
                        building.points.add(coord);
                        building.envelope.union(coord.longitude, coord.latitude);
                    }
                    this.mBuildings.add(building);
                }
            }
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public Building detect(float f, float f2) {
        GeoFenceHelper.TimeStatus timeStatus = this.mDownloadStatus;
        if (!timeStatus.status && timeStatus.isTimeout(20000L)) {
            downBuildings();
        }
        synchronized (this.mBuildings) {
            ArrayList<Building> arrayList = null;
            if (MapUtils.isEmpty(this.mBuildings)) {
                return null;
            }
            this.mDetectTimes++;
            GeoFenceHelper.Coord coord = new GeoFenceHelper.Coord(f, f2);
            if (this.mNearCoord != null && this.mNearCoord.distance(coord) > 1000.0d) {
                this.mNearCoord = null;
            }
            Building building = (Building) this.mNearest.object;
            ArrayList<Building> arrayList2 = this.mNearBuildings;
            if (this.mNearCoord == null) {
                if (L.isLogging) {
                    L.d("global search");
                }
                arrayList = new ArrayList<>();
                arrayList2 = this.mBuildings;
                this.mGlobalSearchTimes++;
                this.mNearCoord = coord;
                this.mNearBuildings.clear();
            }
            Iterator<Building> it = arrayList2.iterator();
            while (it.hasNext()) {
                Building next = it.next();
                next.detect(coord);
                if (building == null || next.distance < building.distance) {
                    building = next;
                }
                if (next.isNearby && arrayList2 != this.mNearBuildings) {
                    this.mNearBuildings.add(next);
                }
                if (arrayList != null && next.isReachable) {
                    arrayList.add(next);
                }
            }
            if (L.isLogging) {
                L.d("Nearest " + building);
            }
            this.mNearest.object = building;
            this.mNearest.status = building.isContained;
            this.mDistance = building.distance;
            this.mNearest.time = System.currentTimeMillis();
            if (arrayList != null && !arrayList.isEmpty()) {
                if (L.isLogging) {
                    L.d("shrink memory. total=" + this.mBuildings.size() + ", ReachableBuildings(cache)=" + arrayList.size() + ", NearBuildings=" + this.mNearBuildings.size());
                }
                this.mBuildings = arrayList;
            }
            return building;
        }
    }

    public void downBuildings() {
        Configuration configuration = this.mConfiguration;
        if (configuration == null) {
            return;
        }
        try {
            this.mDownloadStatus.changeStatus(true);
            String url = configuration.getUrl();
            ByteBuffer allocate = ByteBuffer.allocate(ErrorCode.SENSOR_ACC_TIMESTAMP_ERROR);
            allocate.putShort((short) 2);
            allocate.putInt(1);
            allocate.putShort((short) 0);
            MapUtils.put(allocate, MapUtils.getImei());
            MapUtils.put(allocate, MapUtils.getImsi());
            allocate.putInt(this.mVersion);
            allocate.putInt(0);
            allocate.putInt(0);
            allocate.putShort(6, (short) ((allocate.position() - 8) + 1));
            allocate.put(GeoFenceHelper.getCheckData(allocate));
            GeoFenceHelper.postRequest(url, System.currentTimeMillis(), MapUtils.copyOf(allocate.array(), allocate.position()), new Handler(new Handler.Callback() { // from class: com.autonavi.indooroutdoordetectorsdk.GeoFenceDetector.1
                @Override // android.os.Handler.Callback
                public boolean handleMessage(Message message) {
                    try {
                        if (message.what == 1209) {
                            byte[] bArr = (byte[]) message.obj;
                            if (L.isLogging) {
                                L.d("buf.length=" + bArr.length);
                            }
                            ByteBuffer wrap = ByteBuffer.wrap(bArr);
                            if (wrap.getShort() != 2) {
                                return false;
                            }
                            int i = wrap.getInt();
                            if (i != 1 && i != 2 && i != 3) {
                                if (L.isLogging) {
                                    L.d(" invalid actionVersion " + i);
                                }
                                return false;
                            }
                            int i2 = wrap.getInt();
                            if (i2 < 0) {
                                if (L.isLogging) {
                                    L.d(" invalid status " + i2);
                                }
                                return false;
                            }
                            int i3 = wrap.getInt();
                            if (i3 <= 0) {
                                if (L.isLogging) {
                                    L.d(" invalid length " + i3);
                                }
                                return false;
                            }
                            int i4 = wrap.getInt();
                            if (i4 <= 0) {
                                if (L.isLogging) {
                                    L.d(" invalid dataVersion " + i4);
                                }
                                return false;
                            }
                            int i5 = wrap.getInt();
                            if (L.isLogging) {
                                L.d("downloaded geofence dataVersion=" + i4 + ", dataLength=" + i5);
                            }
                            if (i5 > 0) {
                                byte[] bArr2 = new byte[i5];
                                wrap.get(bArr2);
                                ByteBuffer allocate2 = ByteBuffer.allocate(i5 + 8 + 4);
                                allocate2.putLong(System.currentTimeMillis());
                                allocate2.putInt(i4);
                                allocate2.put(bArr2);
                                GeoFenceDetector.this.writeBuildings(allocate2.array());
                            }
                        } else {
                            GeoFenceDetector.this.mDownloadStatus.changeStatus(false);
                        }
                    } catch (Throwable th) {
                        if (L.isLogging) {
                            L.d(th);
                        }
                        GeoFenceDetector.this.mDownloadStatus.changeStatus(false);
                    }
                    return false;
                }
            }));
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
            this.mDownloadStatus.changeStatus(false);
        }
    }

    public void initDetect(Configuration configuration) {
        this.mConfiguration = configuration;
        String str = configuration.mSqlitePath;
        String substring = str.substring(0, str.lastIndexOf("/"));
        File file = new File(substring);
        this.mFile = file;
        try {
            file.mkdirs();
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        this.mFilename = substring + "/Buildings";
        File file2 = new File(this.mFilename);
        this.mFile = file2;
        if (file2.exists()) {
            readBuildings();
        }
        downBuildings();
    }

    public void readBuildings() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.mFile);
            byte[] bArr = new byte[(int) this.mFile.length()];
            fileInputStream.read(bArr);
            fileInputStream.close();
            decodeBuildings(bArr);
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
    }

    public int startDetect() {
        this.mDistance = 0.0d;
        this.mNearBuildings.clear();
        this.mNearest.reset();
        this.mNearCoord = null;
        this.mGlobalSearchTimes = 0;
        this.mDetectTimes = 0;
        return 0;
    }

    public int stopDetect() {
        this.mDistance = 0.0d;
        this.mNearBuildings.clear();
        this.mNearest.reset();
        this.mNearCoord = null;
        this.mGlobalSearchTimes = 0;
        this.mDetectTimes = 0;
        return 0;
    }

    public String toString() {
        String str;
        synchronized (this.mBuildings) {
            str = "围栏(" + this.mBuildings.size() + "栋建筑, 附近" + this.mNearBuildings.size() + "栋, 版本" + this.mVersion + ", 参数" + this.N1 + "," + this.N2 + "), DownloadStatus:" + this.mDownloadStatus.status + ", 次数(全局搜索/总数):" + this.mGlobalSearchTimes + "/" + this.mDetectTimes;
            if (this.mNearest.object != null) {
                Building building = (Building) this.mNearest.object;
                String str2 = str + " 离" + building.buildingId + "约" + GeoFenceHelper.round(this.mDistance, 2) + "米  ";
                if (building.isContained) {
                    str = str2 + "进入围栏了 :)))))";
                } else {
                    str = str2 + "围栏之外";
                }
            }
        }
        return str;
    }

    public void writeBuildings(byte[] bArr) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mFile);
            fileOutputStream.write(bArr);
            fileOutputStream.close();
        } catch (Throwable th) {
            if (L.isLogging) {
                L.d(th);
            }
        }
        decodeBuildings(bArr);
    }
}
