package com.autonavi.indooroutdoordetectorsdk;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Base64;
import com.amap.location.common.f.g;
import com.autonavi.eaglet.surfacemng.cfg.Config;
import com.autonavi.indoor.constant.MessageCode;
import com.autonavi.indoor.util.L;
import com.autonavi.indoor.util.MapUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: classes.dex */
public class GeoFenceHelper {
    public static double a = 6378245.0d;
    public static double ee = 0.006693421622965943d;
    public static double pi = 3.141592653589793d;
    public static final StringBuffer mLogsBuffer = new StringBuffer();
    public static final StringBuffer mFlagsBuffer = new StringBuffer();

    /* loaded from: classes.dex */
    public static class TimeStatus {
        public Object object;
        public boolean status;
        public long time;

        public TimeStatus() {
            reset();
        }

        public void changeStatus(boolean z) {
            this.time = System.currentTimeMillis();
            this.status = z;
        }

        public int elapsedTime() {
            return (int) (System.currentTimeMillis() - this.time);
        }

        public boolean isTimeout(long j) {
            return System.currentTimeMillis() - this.time > j;
        }

        public void reset() {
            this.time = 0L;
            this.status = false;
        }

        public String toString() {
            return new Date(this.time) + " Status:" + this.status;
        }
    }

    public static String datetimeFormat(String str, long j) {
        return new SimpleDateFormat(str, Locale.CHINA).format(new Date(j));
    }

    public static byte getCheckData(ByteBuffer byteBuffer) {
        byte b = 0;
        for (int i = 0; i < byteBuffer.position(); i++) {
            b = (byte) (b ^ byteBuffer.get(i));
        }
        return b;
    }

    public static byte[] getMacBytes(String str) {
        byte[] bArr = new byte[6];
        String[] split = str.split("_");
        for (int i = 0; i < split.length; i++) {
            bArr[i] = (byte) Integer.parseInt(split[i], 16);
        }
        return bArr;
    }

    public static void logFile(String str) {
        logFile("scen", str);
    }

    public static boolean outOfChina(double d, double d2) {
        return d2 < 72.004d || d2 > 137.8347d || d < 0.8293d || d > 55.8271d;
    }

    public static int postRequest(final String str, final long j, byte[] bArr, final Handler handler) {
        final byte[] bArr2;
        byte[] compressBody = BuildingLocateThread.compressBody(bArr);
        byte[] amapEncode = MapUtils.amapEncode(compressBody);
        if (amapEncode != null) {
            if (L.isLogging) {
                L.d("Request encryptData is null");
            }
            bArr2 = amapEncode;
        } else {
            bArr2 = compressBody;
        }
        if (L.isLogging) {
            L.d("Request " + str + ", buffer.length=" + bArr2.length);
        }
        if (L.isLogging) {
            L.d("Request body" + Base64.encodeToString(bArr2, 0));
        }
        new Thread("GeofenceNetwork") { // from class: com.autonavi.indooroutdoordetectorsdk.GeoFenceHelper.1
            @Override // java.lang.Thread, java.lang.Runnable
            public void run() {
                int i;
                int responseCode;
                try {
                    if (L.isLogging) {
                        L.d(j + ", Request " + str + ", buffer.length=" + bArr2.length);
                    }
                    HttpURLConnection httpURLConnection = (HttpURLConnection) new URL(str).openConnection();
                    try {
                        httpURLConnection.setReadTimeout(10000);
                        httpURLConnection.setConnectTimeout(10000);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setDoInput(true);
                        i = 0;
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setInstanceFollowRedirects(true);
                        httpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
                        httpURLConnection.setRequestProperty("Charset", "UTF-8");
                        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                        OutputStream outputStream = httpURLConnection.getOutputStream();
                        outputStream.write(bArr2);
                        outputStream.close();
                        httpURLConnection.connect();
                        responseCode = httpURLConnection.getResponseCode();
                    } catch (Throwable th) {
                        try {
                            if (L.isLogging) {
                                L.d("postRequest异常：" + th + ", url=" + str);
                            }
                            if (L.isLogging) {
                                L.d(th);
                            }
                            if (L.isLogging) {
                                L.d(handler);
                            }
                            if (L.isLogging) {
                                L.d(handler.getLooper().getThread());
                            }
                            if (handler.getLooper() != null) {
                                handler.sendMessage(handler.obtainMessage(212, Long.valueOf(j)));
                            } else if (L.isLogging) {
                                L.d("Thread has been died");
                            }
                        } finally {
                            httpURLConnection.disconnect();
                        }
                    }
                    if (responseCode != 200) {
                        httpURLConnection.disconnect();
                        handler.sendMessage(handler.obtainMessage(MessageCode.MSG_SERVER_ERROR, Long.valueOf(j)));
                        if (L.isLogging) {
                            L.d("服务器建立连接失败，返回值错误code：" + responseCode);
                        }
                        Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
                        if (L.isLogging) {
                            L.d(headerFields.toString() + ", " + headerFields.size());
                        }
                        for (String str2 : headerFields.keySet()) {
                            List<String> list = headerFields.get(str2);
                            if (L.isLogging) {
                                L.d(list.toString() + ", " + list.size());
                            }
                            for (String str3 : list) {
                                if (L.isLogging) {
                                    L.d(str2 + ": " + str3);
                                }
                            }
                        }
                        return;
                    }
                    String contentType = httpURLConnection.getContentType();
                    int contentLength = httpURLConnection.getContentLength();
                    if (contentLength <= 0) {
                        contentLength = 2097152;
                        if (L.isLogging) {
                            L.d(httpURLConnection.getResponseMessage());
                        }
                    }
                    byte[] bArr3 = new byte[contentLength];
                    InputStream inputStream = httpURLConnection.getInputStream();
                    while (i < contentLength) {
                        int read = inputStream.read(bArr3, i, contentLength - i);
                        if (read <= 0) {
                            break;
                        } else {
                            i += read;
                        }
                    }
                    byte[] copyOf = MapUtils.copyOf(bArr3, i);
                    inputStream.close();
                    if (L.isLogging) {
                        L.d("Response mUrl=" + str + ", buffer[1]=" + ((int) bArr2[1]) + ", code=" + responseCode + ", length=" + copyOf.length + ", len=" + contentLength + ", contentLength=" + httpURLConnection.getContentLength() + ", " + httpURLConnection.getResponseMessage() + ", " + contentType);
                    }
                    if (contentType.startsWith("application/json")) {
                        String str4 = new String(copyOf);
                        if (L.isLogging) {
                            L.d(str4);
                        }
                        JSONObject jSONObject = new JSONObject(str4);
                        if (jSONObject.has("status")) {
                            String string = jSONObject.getString("status");
                            if (L.isLogging) {
                                L.d("json status:" + string);
                            }
                            String string2 = jSONObject.getString("info");
                            if (L.isLogging) {
                                L.d("json info:" + string2);
                            }
                            int i2 = MessageCode.MSG_LBS_ERROR;
                            if (string2.equals("OK")) {
                                if (L.isLogging) {
                                    L.d("正常");
                                }
                            } else if (string2.equals("INVALID_USER_KEY")) {
                                i2 = MessageCode.MSG_LBS_INVALID_USER_KEY;
                                if (L.isLogging) {
                                    L.d("用户key非法或过期");
                                }
                            } else if (string2.equals("SERVICE_NOT_AVAILBALE")) {
                                i2 = MessageCode.MSG_LBS_SERVICE_NOT_AVAILBALE;
                                if (L.isLogging) {
                                    L.d("请求服务不存在");
                                }
                            } else if (string2.equals("SERVICE_RESPONSE_ERROR")) {
                                i2 = MessageCode.MSG_LBS_SERVICE_RESPONSE_ERROR;
                                if (L.isLogging) {
                                    L.d("请求服务响应错误");
                                }
                            } else if (string2.equals("INSUFFICIENT_PRIVILEGES")) {
                                i2 = MessageCode.MSG_LBS_INSUFFICIENT_PRIVILEGES;
                                if (L.isLogging) {
                                    L.d("无权限访问此服务");
                                }
                            } else if (string2.equals("OVER_QUOTA")) {
                                i2 = MessageCode.MSG_LBS_OVER_QUOTA;
                                if (L.isLogging) {
                                    L.d("请求超出配额");
                                }
                            } else if (string2.equals("INVALID_PARAMS")) {
                                i2 = MessageCode.MSG_LBS_INVALID_PARAMS;
                                if (L.isLogging) {
                                    L.d("请求参数非法");
                                }
                            } else if (string2.equals("UNKNOWN_ERROR")) {
                                i2 = MessageCode.MSG_LBS_UNKNOWN_ERROR;
                                if (L.isLogging) {
                                    L.d("未知错误");
                                }
                            }
                            if (handler != null && handler.getLooper() != null && handler.getLooper().getThread().isAlive()) {
                                handler.sendMessage(handler.obtainMessage(MessageCode.MSG_SERVER_ERROR, Integer.valueOf(i2)));
                            }
                        } else if (jSONObject.has("result")) {
                            String string3 = jSONObject.getString("result");
                            if (L.isLogging) {
                                L.d("json result:" + string3);
                            }
                            if (string3.equals(Config.FALSE)) {
                                String string4 = jSONObject.getString("message");
                                if (handler != null && handler.getLooper() != null && handler.getLooper().getThread().isAlive()) {
                                    handler.sendMessage(handler.obtainMessage(MessageCode.MSG_SERVER_ERROR, string4));
                                }
                            }
                        }
                        if (L.isLogging) {
                            L.d(httpURLConnection.getContent().toString());
                        }
                    } else if (handler.getLooper() != null) {
                        handler.sendMessage(handler.obtainMessage(1209, copyOf));
                    } else if (L.isLogging) {
                        L.d("Thread has been died");
                    }
                } catch (Throwable th2) {
                    if (L.isLogging) {
                        L.d("打开连接异常：" + th2);
                    }
                    if (handler.getLooper() != null) {
                        Handler handler2 = handler;
                        handler2.sendMessage(handler2.obtainMessage(212, Long.valueOf(j)));
                    } else if (L.isLogging) {
                        L.d("Thread has been died");
                    }
                }
            }
        }.start();
        return 0;
    }

    public static double round(double d, int i) {
        int i2 = 1;
        for (int i3 = 0; i3 < i; i3++) {
            i2 *= 10;
        }
        double d2 = i2;
        Double.isNaN(d2);
        double d3 = (int) (d * d2);
        Double.isNaN(d3);
        Double.isNaN(d2);
        return d3 / d2;
    }

    public static String timeFormat(long j) {
        return new SimpleDateFormat("HH:mm:ss.SSS", Locale.CHINA).format(new Date(j));
    }

    public static Coord transform(float f, float f2) {
        Coord coord = new Coord(f2, f);
        double d = f;
        double d2 = f2;
        if (outOfChina(d, d2)) {
            return coord;
        }
        Double.isNaN(d2);
        double d3 = d2 - 105.0d;
        Double.isNaN(d);
        double d4 = d - 35.0d;
        double transformLat = transformLat(d3, d4);
        double transformLon = transformLon(d3, d4);
        Double.isNaN(d);
        double d5 = (d / 180.0d) * pi;
        double sin = Math.sin(d5);
        double d6 = 1.0d - ((ee * sin) * sin);
        double sqrt = Math.sqrt(d6);
        double d7 = a;
        double d8 = (transformLat * 180.0d) / ((((1.0d - ee) * d7) / (d6 * sqrt)) * pi);
        double cos = (transformLon * 180.0d) / (((d7 / sqrt) * Math.cos(d5)) * pi);
        coord.latitude = f + ((float) d8);
        coord.longitude = ((float) cos) + f2;
        return coord;
    }

    public static double transformLat(double d, double d2) {
        double d3 = d * 2.0d;
        return (-100.0d) + d3 + (d2 * 3.0d) + (d2 * 0.2d * d2) + (0.1d * d * d2) + (Math.sqrt(Math.abs(d)) * 0.2d) + ((((Math.sin((d * 6.0d) * pi) * 20.0d) + (Math.sin(d3 * pi) * 20.0d)) * 2.0d) / 3.0d) + ((((Math.sin(pi * d2) * 20.0d) + (Math.sin((d2 / 3.0d) * pi) * 40.0d)) * 2.0d) / 3.0d) + ((((Math.sin((d2 / 12.0d) * pi) * 160.0d) + (Math.sin((d2 * pi) / 30.0d) * 320.0d)) * 2.0d) / 3.0d);
    }

    public static double transformLon(double d, double d2) {
        double d3 = d * 0.1d;
        return d + 300.0d + (d2 * 2.0d) + (d3 * d) + (d3 * d2) + (Math.sqrt(Math.abs(d)) * 0.1d) + ((((Math.sin((6.0d * d) * pi) * 20.0d) + (Math.sin((d * 2.0d) * pi) * 20.0d)) * 2.0d) / 3.0d) + ((((Math.sin(pi * d) * 20.0d) + (Math.sin((d / 3.0d) * pi) * 40.0d)) * 2.0d) / 3.0d) + ((((Math.sin((d / 12.0d) * pi) * 150.0d) + (Math.sin((d / 30.0d) * pi) * 300.0d)) * 2.0d) / 3.0d);
    }

    public static void logFile(String str, String str2) {
        if (L.isLogging) {
            L.d(str + ", " + str2);
        }
        try {
            synchronized (mLogsBuffer) {
                if (new File(g.a((Context) null) + "/autonavi/indoor/iodetector").exists()) {
                    if (str == "scen") {
                        try {
                            if (str2.equals("startDetect")) {
                                if (mFlagsBuffer.length() > 128) {
                                    mFlagsBuffer.delete(0, mFlagsBuffer.length());
                                }
                                mFlagsBuffer.append(datetimeFormat("yyyy-MM-dd", System.currentTimeMillis()) + " " + Build.BRAND + "," + Build.MANUFACTURER + "," + Build.MODEL + "," + Build.DEVICE + "," + Build.SERIAL + "," + Build.FINGERPRINT + "," + Build.ID + "," + Build.PRODUCT + "," + Build.TYPE + "," + Build.USER + "," + Build.VERSION.RELEASE + "," + Build.VERSION.INCREMENTAL + "," + Build.VERSION.SDK_INT + "," + Build.getRadioVersion() + "," + Build.TIME + "," + Build.HARDWARE + "\n");
                            }
                            mFlagsBuffer.append(datetimeFormat("HH:mm:ss.SSS", System.currentTimeMillis()) + " " + str2 + "\n");
                            if (str2.equals("stopDetect") && mFlagsBuffer.length() > 128) {
                                mFlagsBuffer.delete(0, mFlagsBuffer.length());
                            }
                        } catch (Throwable th) {
                            if (L.isLogging) {
                                L.d(th);
                            }
                        }
                    }
                    if (str2.equals("startDetect")) {
                        mLogsBuffer.delete(0, mLogsBuffer.length());
                    }
                    mLogsBuffer.append(str + " " + System.currentTimeMillis() + " " + str2 + "\n");
                    if (str2.equals("stopDetect") && mLogsBuffer.length() > 64) {
                        try {
                            File file = new File(g.a((Context) null) + "/autonavi/indoor/iodetector/log." + datetimeFormat("yyyyMMdd_HHmmss", System.currentTimeMillis()) + ".txt");
                            file.createNewFile();
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.write(mLogsBuffer.toString().getBytes());
                            fileOutputStream.close();
                            mLogsBuffer.delete(0, mLogsBuffer.length());
                        } catch (Throwable th2) {
                            if (L.isLogging) {
                                L.d(th2);
                            }
                        }
                    }
                }
            }
        } catch (Throwable th3) {
            if (L.isLogging) {
                L.d(th3);
            }
        }
    }

    public static String timeFormat() {
        return timeFormat(System.currentTimeMillis());
    }

    /* loaded from: classes.dex */
    public static class Coord {
        public float latitude;
        public float longitude;

        public Coord() {
            this.longitude = 0.0f;
            this.latitude = 0.0f;
        }

        public double distance(Coord coord) {
            return MapUtils.distance(this.longitude, this.latitude, coord.longitude, coord.latitude);
        }

        public String toString() {
            return "(" + this.longitude + ", " + this.latitude + ")";
        }

        public Coord(float f, float f2) {
            this.longitude = f;
            this.latitude = f2;
        }
    }
}
